/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.parser;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Request;

import net.fclabs.util.Queue;

/**
 * ݡȤ򥭥塼ˤݡ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class CacheReporter implements Reporter {
    private Reporter reporter    = null;
    private Queue    reportQueue = null;
    private boolean  run         = true;

    /**
     * ݡåѤݡ
     *
     * @param  reporter 顼ݡ
     */
    CacheReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    /**
     * ϥ塼ίᡢʳľܥݡȤޤ
     *
     * @param  facility եƥ
     * @param  level    åΥ٥
     * @param  emphasis 
     * @param  source   
     * @param  line     ֹ
     * @param  column   
     * @param  tag      
     * @param  message  å
     */
    public synchronized void report(int facility, int level, int emphasis,
                                    Content source, int line, int column,
                                    String tag, String message) {
        if (run) {
            reporter.report(facility, level, emphasis, source, line, column, tag, message);
        } else {
            if (reportQueue == null) {
                reportQueue = new Queue();
            }
            reportQueue.put(new Report(facility, level, emphasis, source, line, column, tag, message));
        }
    }

    /** {@inheritDoc} */
    public void report(Throwable t, Request request) {
    }

    /** {@inheritDoc} */
    public boolean isReported(int facility, int level) {
        return reporter.isReported(facility, level);
    }

    /**
     * ݡȤ쥯Ȥ˽Ϥ褦ˤޤ
     *
     * @param  junk ˤޤä塼˴
     *              <code>true</code>ʳξ <code>false</code>
     */
    synchronized void restart(boolean junk) {
        this.run = true;

        if (!junk) {
            if (reportQueue != null) {
                Report report = null;
                while ((report = (Report) reportQueue.get()) != null) {
                    report.flush(reporter);
                }
            }
        }
        reportQueue = null;
    }

    /**
     * ˤޤä塼򥯥ꥢޤ
     */
    synchronized void clear() {
        if (reportQueue != null) {
            reportQueue.clear();
        }
    }

    /**
     * ݡȤνϤߤʹߤ줿ݡȤ
     * 塼ˤ褦ˤޤ
     */
    synchronized void pause() {
        this.run = false;
    }

//### Report
    /** ݡȾݻ륯饹 */
    private final class Report {
        private int       facility;
        private int       level;
        private int       emphasis;
        private Content   source;
        private int       line;
        private int       column;
        private String    tag;
        private String    message;
        private Throwable throwable;
        private Request   request;

        /** ꤵ줿ݡȾ */
        private Report(int facility, int level, int emphasis,
                     Content source, int line, int column, String tag, String message) {
            this.facility = facility;
            this.level    = level;
            this.emphasis = emphasis;
            this.source   = source;
            this.line     = line;
            this.column   = column;
            this.tag      = tag;
            this.message  = message;
        }

        /** ꤵ줿ݡȾ */
        private Report(Throwable t, Request request) {
            this.throwable = t;
            this.request   = request;
        }

        /** ݡȤ */
        private void flush(Reporter reporter) {
            if (throwable == null) {
                reporter.report(facility, level, emphasis, source, line, column, tag, message);
            } else {
                reporter.report(throwable, request);
            }
        }
    }
}
