/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.net.URL;
import java.net.MalformedURLException;

/**
 * URL ˴ؤ桼ƥƥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public final class URLUtils {
    /** ߡ */
    private URLUtils() {
    }

    /**
     * ꤵ줿 URL Υѥޤ
     * ե󥹤ޤޤޤ
     *
     * @param  url URL
     *
     * @return ե󥹤ʤ URL
     */
    public static String getFullPath(URL url) {
        StringBuffer sb = new StringBuffer();
        sb.append(url.getProtocol());
        sb.append("://");
        sb.append(url.getHost());
        if (url.getPort() > 0) {
            sb.append(":");
            sb.append(url.getPort());
        }
        sb.append(url.getFile());
        return sb.toString();
    }

    /**
     * <code>url2</code> ˥ե󥹤ͭˡ
     * <code>url1</code> ˥ե󥹤ղä֤ޤ
     *
     * @param  url1 ե󥹤ɲä URL
     * @param  url2 ե󥹤Υԡ URL
     *
     * @return ե󥹤򥳥ԡ URL
     */
    public static URL copyRef(URL url1, URL url2) {
        if (url2.getRef() != null) {
            try {
                return new URL(url1.getProtocol(),
                               url1.getHost    (),
                               url1.getPort    (),
                               url1.getFile    () + "#" + url2.getRef());
            } catch (MalformedURLException e) { }
        }
        return url1;
    }

    /**
     * <code>url</code> ˥ե󥹤ͭäˡ
     * ե󥹤֤ޤ
     *
     * @param  url ե󥹤ɲä URL
     *
     * @return ե󥹤򥳥ԡ URL
     */
    public static URL removeRef(URL url) {
        if (url.getRef() != null) {
            try {
                return new URL(url.getProtocol(),
                               url.getHost    (),
                               url.getPort    (),
                               url.getFile    ());
            } catch (MalformedURLException e) { }
        }
        return url;
    }
}
