/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

/**
 * URL 򥨥󥳡ǥ󥰤륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public final class URLEncoder {
    private static final String DEFAULT_ENCODING = "UTF8";
    private static final int CASE_DIFF = ('a' - 'A');
    private static BitSet dontNeedEncoding;
    static {
        dontNeedEncoding = new BitSet(256);
        int i;
        for (i = 'a'; i <= 'z'; i++) {
            dontNeedEncoding.set(i);
        }
        for (i = 'A'; i <= 'Z'; i++) {
            dontNeedEncoding.set(i);
        }
        for (i = '0'; i <= '9'; i++) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(' ');
        dontNeedEncoding.set('-');
        dontNeedEncoding.set('_');
        dontNeedEncoding.set('.');
        dontNeedEncoding.set('*');
    }

    /** ߡ */
    private URLEncoder() {
    }

    /**
     * ʸ <code>x-www-form-urlencoded</code> Ѵޤ
     *
     * @param  s Ѵʸ
     * @param  encoding ѴѤ륨󥳡ǥ
     *
     * @return Ѵʸ
     */
    public static String encode(String s, String encoding) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length() * 2);
        byte[] bytes = null;

        if (encoding != null) {
            try {
                bytes = s.getBytes(encoding);
            } catch (UnsupportedEncodingException e) { }
        }
        if (bytes == null) {
            bytes = s.getBytes();
        }

        int length = bytes.length;
        byte b;
        for (int i = 0; i < length; i++) {
            b = bytes[i];

            if (dontNeedEncoding.get((char) b)) {
                // Ѵʤ

                // ' ' -> '+' Ѵ
                out.write(b != ' ' ? (char) b : '+');
            } else {
                // Ѵɬפ

                // Х %xx Ѵ
                out.write('%');
                out.write(toHexFromByte((b >> 4) & 0xF));  // ̥Х
                out.write(toHexFromByte( b       & 0xF));  // ̥Х
            }
        }

        return out.toString();
    }

    /**
     * <code>x-www-form-urlencoded</code> ̾ʸѴޤ
     *
     * @param  s Ѵʸ
     * @param  encoding ѴѤ륨󥳡ǥ
     *
     * @return Ѵʸ
     */
    public static String decode(String s, String encoding) {
        int length = s.length();
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);

        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }

        char c;
        for (int i = 0; i < length; i++) {
            c = s.charAt(i);

            // '+' -> '-' Ѵ
            if (c == ' ') {
                out.write('+');
            } else if (c == '%'
                    && i + 2 < length
                    && isDigit(s.charAt(i + 1))
                    && isDigit(s.charAt(i + 2))) {
                // %xx Ѵɬפ
                out.write((toByteFromHex(s.charAt(i + 1)) * 0x10
                         + toByteFromHex(s.charAt(i + 2))) & 0xFF);
                i += 2;
            } else {
                out.write(c);
            }
        }

        if (encoding != null) {
            try {
                return out.toString(encoding);
            } catch (UnsupportedEncodingException e) { }
        }
        return out.toString();
    }

    /** ХȤͤ 16 ʿѴ */
    private static char toHexFromByte(int digit) {
        if (digit < 10) {
            return (char) ('0' + digit);
        }
        return (char) ('A' - 10 + digit);
    }


    /** ꤵ줿ʸ 16 ʤɤ֤ */
    private static boolean isDigit(char c) {
        return ('0' <= c && c <= '9'
             || 'A' <= c && c <= 'F'
             || 'a' <= c && c <= 'f');
    }

    /** 16 ʿ byte Ѵ */
    private static byte toByteFromHex(char c) {
        if (c <= '9') {
            return (byte) (c - '0');
        }
        if ('a' <= c) {
            return (byte) (c - 0x57);           // c - 'a' + 10
        }
        return (byte) (c - 0x37);       // c - 'A' + 10
    }
}
