/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.net.URL;

/**
 * {@link URLConnection} åѡǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class URLConnectionWrapper extends URLConnection {
    /** ͥ */
    protected URLConnection connection;
    /** ϥȥ꡼ */
    protected InputStream   inputStream;

    /**
     * {@link URLConnection} Υåѡ饹ޤ
     *
     * @param  url        URL
     * @param  connection ͥ
     * @param  is         ϥȥ꡼ࡣ
     *                    <code>connection</code> 
     *                    <code>null</code>
     *
     * @see    URLConnection
     */
    public URLConnectionWrapper(URL url, URLConnection connection,
                                InputStream is) {
        super(url);
        this.connection  = connection;
        this.inputStream = is;
    }

//### Object
    /**
     * ֥Ȥʸɽ֤ޤ
     *
     * @return ʸɽ
     *
     * @see    Object#toString()
     */
    public String toString() {
        return connection.toString();
    }

    /**
     * Υ֥Ȥ¾Υ֥Ȥɤ򼨤ޤ
     *
     * @param  obj оݤλȥ֥
     *
     * @return obj ˻ꤵ줿֥ȤȤΥ֥Ȥ
     *         <code>true</code>Ǥʤ <code>false</code>
     *
     * @see    Object#equals(Object)
     */
    public boolean equals(Object obj) {
        return connection.equals(obj);
    }

    /**
     * ֥ȤΥϥå女֤ͤޤ
     *
     * @return ϥå女
     *
     * @see    Object#hashCode()
     */
    public int hashCode() {
        return connection.hashCode();
    }

//### URLConnection
    /**
     * ³Ԥޤ
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     *
     * @see    URLConnection#connect()
     */
    public void connect() throws IOException {
        connection.connect();
    }

    /**
     * URL ե֤ͤޤ
     *
     * @return URL ե
     *
     * @see    URLConnection#getURL()
     */
    public URL getURL() {
        return url;
    }

    /**
     * <code>content-length</code> إåեɤ֤ͤޤ
     *
     * @return ³ URL Ȥ꥽Υƥĥ
     *         ξ <code>-1</code>
     *
     * @see    URLConnection#getContentLength()
     */
    public int getContentLength() {
        return connection.getContentLength();
    }

    /**
     * <code>content-type</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽Υƥķ
     *         ξ <code>null</code>
     *
     * @see    URLConnection#getContentType()
     */
    public String getContentType() {
        return connection.getContentType();
    }

    /**
     * <code>content-encoding</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽ΥƥĤ沽
     *         ξ <code>null</code>
     *
     * @see    URLConnection#getContentEncoding()
     */
    public String getContentEncoding() {
        return connection.getContentEncoding();
    }

    /**
     * <code>expires</code> إåեɤ֤ͤޤ
     *
     * @return  URL Ȥ꥽ͭ¡
     *         ξ <code>0</code>
     *         ͤϥ˥åɸ 1970 ǯ 1  1  鵯ߥÿ
     *
     * @see    URLConnection#getExpiration()
     */
    public long getExpiration() {
        return connection.getExpiration();
    }

    /**
     * <code>date</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽
     *         ξ <code>0</code>
     *         ͤϥ˥åɸ 1970 ǯ 1  1  鵯ߥÿ
     *
     * @see    URLConnection#getDate()
     */
    public long getDate() {
        return connection.getDate();
    }

    /**
     * <code>last-modified</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽ѹ줿ա
     *         ξ <code>0</code>
     *         ͤϥ˥åɸ 1970 ǯ 1  1  鵯ߥÿ
     *
     * @see    URLConnection#getLastModified()
     */
    public long getLastModified() {
        return connection.getLastModified();
    }

    /**
     * ꤵ줿إåեɤ֤ͤޤ
     *
     * @param  name  إåեɤ̾
     *
     * @return ꤵ줿إåեɤ̾
     *         ꤵ줿̾ĥեɤإåˤʤ
     *         <code>null</code>
     *
     * @see    URLConnection#getHeaderField(String)
     */
    public String getHeaderField (String name) {
        return connection.getHeaderField(name);
    }

    /**
     * إåեɤѹԲǽʥޥåפ֤ޤ
     *
     * @return إåեɤΥޥå
     *
     * @see    URLConnection#getHeaderFields()
     */
/*
    public Map getHeaderFields() {
        return connection.getHeaderFields();
    }
*/

    /**
     * ꤵ줿եɤͤȤƲϤ֤ͤޤ
     *
     * @param  name إåեɤ̾
     * @param  def  ǥե
     *
     * @return ꤷեɤͤȤƲϤ͡
     *         եɤʤޤϥեɤηξˤ
     *         <code>def</code> 
     *
     * @see    URLConnection#getHeaderFieldInt(String, int)
     */
    public int getHeaderFieldInt(String name, int  def) {
        return connection.getHeaderFieldInt(name, def);
    }

    /**
     * ꤵ줿եɤդȤƲϤ֤ͤޤ
     *
     * @param  name إåեɤ̾
     * @param  def  ǥե
     *
     * @return դȤƲϤե͡
     *         եɤʤޤϥեɤηʾ
     *         <code>def</code> 
     *
     * @see    URLConnection#getHeaderFieldDate(String, long)
     */
    public long getHeaderFieldDate(String name, long def) {
        return connection.getHeaderFieldDate(name, def);
    }

    /**
     * <code>n</code> ܤΥإåեɤΥ֤ޤ
     *
     * @param  n ǥå
     *
     * @return <code>n</code> ܤΥإåեɤΥ
     *         եɤο <code>n</code> Ĥ⾯ʤ
     *         <code>null</code>
     *
     * @see    URLConnection#getHeaderFieldKey(int)
     */
    public String getHeaderFieldKey(int n) {
        return connection.getHeaderFieldKey(n);
    }

    /**
     * <code>n</code> ܤΥإåեɤ֤ͤޤ
     *
     * @param  n ǥå
     *
     * @return <code>n</code> ܤΥإåեɤ͡
     *         եɤο <code>n</code> Ĥ⾯ʤ
     *         <code>null</code>
     *
     * @see    URLConnection#getHeaderField(int)
     */
    public String getHeaderField(int n) {
        return connection.getHeaderField(n);
    }

    /**
     *  URL ³ΥƥĤޤ
     *
     * @return ֥
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException
     *         ץȥ뤬Υƥķ򥵥ݡȤƤʤ
     *
     * @see    URLConnection#getContent()
     */
    public Object getContent() throws IOException {
        return connection.getContent();
    }

    /**
     *  URL ³ΥƥĤޤ
     *
     * @param  classes ׵ᤵ줿פ򼨤 <code>Class</code> 
     *
     * @return 饹ǻꤵ줿פǽ˰פ
     *         ֥ȡ
     *         ׵ᤵ줿פݡȤƤʤ <code>null</code>
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws UnknownServiceException
     *         ץȥ뤬Υƥķ򥵥ݡȤƤʤ
     *
     * @see    URLConnection#getContent(Class[])
     */
/*
    public Object getContent(Class[] classes) throws IOException {
        return connection.getContent(classes);
    }
*/

    /**
     * Υ֥Ȥɽ³μ¹Ԥɬפʥɽ
     * <code>Permission</code> ֥Ȥ֤ޤ
     *
     * @return ³Τɬפʥɽ
     *         <code>Permission</code> ֥
     *
     * @throws IOException
     *         ν˥ͥåȥ
     *         ޤϥեϤɬפʤȤˡ㳰ȯ
     *
     * @see    URLConnection#getPermission()
     */
/*
    public Permission getPermission() throws IOException {
        return connection.getPermission();
    }
*/

    /**
     * ϥȥ꡼֤ޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException
     *         ץȥ뤬Ϥ򥵥ݡȤƤʤ
     *
     * @see    URLConnection#getInputStream()
     */
    public InputStream getInputStream() throws IOException {
        return (inputStream != null ? inputStream : connection.getInputStream());
    }

    /**
     * ꥯȤǽϤϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException Фؤ³ǥ顼ȯ
     * @throws java.net.UnknownServiceException
     *         ץȥ뤬Ϥ򥵥ݡȤƤʤ
     *
     * @see    URLConnection#getOutputStream()
     */
    public OutputStream getOutputStream() throws IOException {
        return connection.getOutputStream();
    }

    /**
     * <code>doInput</code> եͤꤷͤꤷޤ
     *
     * @param  doinput 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#setDoInput(boolean)
     */
    public void setDoInput(boolean doinput) {
        connection.setDoInput(doinput);
    }

    /**
     * <code>doInput</code> ե饰֤ͤޤ
     *
     * @return <code>doInput</code> ե饰
     *
     * @see    URLConnection#getDoInput()
     */
    public boolean getDoInput() {
        return connection.getDoInput();
    }

    /**
     * <code>doOutput</code> եɤͤ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  dooutput 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#setDoOutput(boolean)
     */
    public void setDoOutput(boolean dooutput) {
        connection.setDoOutput(dooutput);
    }

    /**
     * <code>doOutput</code> ե饰֤ͤޤ
     *
     * @return <code>doOutput</code> ե饰
     *
     * @see    URLConnection#getDoOutput()
     */
    public boolean getDoOutput() {
        return connection.getDoOutput();
    }

    /**
     * <code>allowUserInteraction</code> եͤꤷޤ
     *
     * @param  allowuserinteraction 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#setAllowUserInteraction(boolean)
     */
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        connection.setAllowUserInteraction(allowuserinteraction);
    }

    /**
     * <code>allowUserInteraction</code> ե֤ͤޤ
     *
     * @return <code>allowUserInteraction</code> ե
     *
     * @see    URLConnection#getAllowUserInteraction()
     */
    public boolean getAllowUserInteraction() {
        return connection.getAllowUserInteraction();
    }

    /**
     * <code>useCaches</code> եɤ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  usecaches 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#setUseCaches(boolean)
     */
    public void setUseCaches(boolean usecaches) {
        connection.setUseCaches(usecaches);
    }

    /**
     * <code>useCaches</code> ե֤ͤޤ
     *
     * @return <code>useCaches</code> ե
     *
     * @see    URLConnection#getUseCaches()
     */
    public boolean getUseCaches() {
        return connection.getUseCaches();
    }

    /**
     * <code>ifModifiedSince</code> եͤ򡢻ꤵ줿ͤꤷޤ
     *
     * @param  ifmodifiedsince 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#setIfModifiedSince(long)
     */
    public void setIfModifiedSince(long ifmodifiedsince) {
        connection.setIfModifiedSince(ifmodifiedsince);
    }

    /**
     * <code>ifModifiedSince</code> ե֤ͤޤ
     *
     * @return <code>ifModifiedSince</code> ե
     *
     * @see    URLConnection#getIfModifiedSince()
     */
    public long getIfModifiedSince() {
        return connection.getIfModifiedSince();
    }

    /**
     * <code>useCaches</code> ե饰Υǥե֤ͤޤ
     *
     * @return <code>useCaches</code> ե饰Υǥե
     *
     * @see    URLConnection#getDefaultUseCaches()
     */
    public boolean getDefaultUseCaches() {
        return connection.getDefaultUseCaches();
    }

    /**
     * <code>useCaches</code> եɤΥǥեͤ
     * ꤵ줿ͤꤷޤ
     *
     * @param  defaultusecaches 
     *
     * @see    URLConnection#setDefaultUseCaches(boolean)
     */
    public void setDefaultUseCaches(boolean defaultusecaches) {
        connection.setDefaultUseCaches(defaultusecaches);
    }

    /**
     * ꥯȥץѥƥꤷޤ
     *
     * @param  key   
     * @param  value 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     * @throws NullPointerException  <code>null</code> ξ
     *
     * @see    URLConnection#setRequestProperty(String, String)
     */
    public void setRequestProperty(String key, String value) {
        connection.setRequestProperty(key, value);
    }

    /**
     * ꥯȥץѥƥɲäޤ
     *
     * @param  key   
     * @param  value 
     *
     * @throws IllegalStateException Ǥ³Ƥ
     * @throws NullPointerException  <code>null</code> ξ
     *
     * @see    URLConnection#addRequestProperty(String, String)
     */
/*
    public void addRequestProperty(String key, String value) {
        connection.addRequestProperty(key, value);
    }
*/

    /**
     * ꥯȥץѥƥ֤ޤ
     *
     * @param  key   
     *
     * @return ꥽
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#getRequestProperty(String)
     */
    public String getRequestProperty(String key) {
        return connection.getRequestProperty(key);
    }

    /**
     * ꥯȥץѥƥ֤ޤ
     *
     * @return ꥯȥץѥƥ
     *
     * @throws IllegalStateException Ǥ³Ƥ
     *
     * @see    URLConnection#getRequestProperties()
     */
/*
    public Map getRequestProperties() {
        return connection.getRequestProperties();
    }
*/
}
