/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.InputStream;
import java.io.IOException;

/**
 * ꤵ줿ĹΤߤɤ߹ॹȥ꡼Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
class PartInputStream extends DirectInputStream {
    private static final int BUFFER_SIZE = 512;

    /** ĤĹ */
    protected int totalOdd;

    /**
     * ꤵ줿Ĺϥȥ꡼फɤ߹।󥹥󥹤ޤ
     *
     * @param  http   HTTP 饤
     * @param  in     ϥȥ꡼
     * @param  length ǡĹ
     *                <code>1</code> ʾ夬ɬ
     */
    PartInputStream(HttpClient http, InputStream in, int length) {
        super(http, in);
        if (length <= 0) {
            throw new IllegalArgumentException("invalid length <= 0");
        }
        this.totalOdd = length;
    }

    /* ΥХϥȥ꡼फ顢ǡμΥХȤɤ߹ */
    /** {@inheritDoc} */
    public synchronized int read()
            throws IOException {
        ensureOpen();
        if (overOdd == 0 && totalOdd == 0) {
            return -1;
        }

        int ret;
        try {
            ret = in.read();
        } catch (IOException e) {
            release(StreamMonitor.ERROR);
            throw e;
        }

        if (ret == -1) {
            release(StreamMonitor.ABORT);
        } else if (overOdd > 0) {
            overOdd--;
            markOffset++;
        } else {
            // ȥ꡼˥
            if (streamMonitor != null) {
                streamMonitor.pass(ret);
            }
            if (--totalOdd == 0) {
                release(StreamMonitor.END_OF_STREAM);
            }

            if (markOffset != -1) {
                markOffset++;
            }
        }
        return ret;
    }

    /* ΥХϥȥ꡼फХɤ߹ */
    /** {@inheritDoc} */
    public synchronized int read(byte[] b, int off, int len)
            throws IOException {
        ensureOpen();
        if ((off | len | (off + len) | (b.length - (off + len))) < 0) {
            throw new IndexOutOfBoundsException();
        } else if (len == 0) {
            return 0;
        } else if (overOdd == 0 && totalOdd == 0) {
            return -1;
        }

        // ͭɤ߹ߥ˽
        int avail = overOdd + totalOdd;
        if (avail == 0) {
            return -1;
        }
        if (len > avail) {
            len = avail;
        }

        int readlen;
        try {
            readlen = in.read(b, off, len);
        } catch (IOException e) {
            release(StreamMonitor.ERROR);
            throw e;
        }

        if (readlen == -1) {
            release(StreamMonitor.ABORT);
        } else if (overOdd > 0) {
            if (overOdd < readlen) {
                int movelen = readlen - overOdd;

                // ȥ꡼˥
                if (streamMonitor != null) {
                    streamMonitor.pass(b, off + overOdd, movelen);
                }
                if ((totalOdd -= movelen) == 0) {
                    release(StreamMonitor.END_OF_STREAM);
                }

                overOdd = 0;
            } else {
                overOdd -= readlen;
            }
            markOffset += readlen;
        } else {
            // ȥ꡼˥
            if (streamMonitor != null) {
                streamMonitor.pass(b, off, readlen);
            }
            if ((totalOdd -= readlen) == 0) {
                release(StreamMonitor.END_OF_STREAM);
            }

            if (markOffset != -1) {
                markOffset += readlen;
            }
        }
        return readlen;
    }

    /* ϥȥ꡼फ饹åפƥǡΤ */
    /** {@inheritDoc} */
    public synchronized long skip(long n)
            throws IOException {
        ensureOpen();
        if (n == 0) {
            return 0;
        }

        // ͭʥåץ˽
        int avail = overOdd + totalOdd;
        if (avail == 0) {
            return 0;
        }
        int len = (n <= avail ? (int) n : avail);

        // ȥ꡼˥Τ뤿˼ºݤɤ߹
        if (streamMonitor != null) {
            if (len > BUFFER_SIZE) {
                len = BUFFER_SIZE;
            }
            byte[] b = new byte[len];
            return Math.max(read(b, 0, len), 0);
        }

        // ľܥå
        try {
            len = (int) in.skip(len);
        } catch (IOException e) {
            release(StreamMonitor.ERROR);
            throw e;
        }

        if (len == 0) {
            return 0;
        } else if (overOdd > 0) {
            if (overOdd < len) {
                if ((totalOdd -= (len - overOdd)) == 0) {
                    release(StreamMonitor.END_OF_STREAM);
                }

                overOdd = 0;
            } else {
                overOdd -= len;
            }
            markOffset += len;
        } else {
            if ((totalOdd -= len) == 0) {
                release(StreamMonitor.END_OF_STREAM);
            }

            if (markOffset != -1) {
                markOffset += len;
            }
        }
        return len;
    }

    /* ϥȥ꡼򥯥 */
    /** {@inheritDoc} */
    public synchronized void close()
            throws IOException {
        if (in == null) {
            return;
        }

        try {
            // äϡĤ򥹥åפƤߤ
            if (streamMonitor != null) {
                int len;
                while ((len = available()) > 0) {
                    skip(len);
                }
            }
            release(StreamMonitor.ABORT);
        } finally {
            in = null;
        }
    }

    /* HTTP 饤Ȥ */
    /** {@inheritDoc} */
    protected void release(int cause) {
        try {
            super.release(cause);
        } finally {
            totalOdd = 0;
        }
    }

    /* ϥȥ꡼θ֤߰˥ޡդ */
    /** {@inheritDoc} */
    public synchronized void mark(int readlimit) {
        // ͭɤ߹ߥ˽
        int avail = overOdd + totalOdd;
        if (readlimit > avail) {
            readlimit = avail;
        }

        super.mark(readlimit);
    }
}
