/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.IOException;
import java.net.Socket;

/**
 * ͥåȥ饤ȤδŪʵǽ󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class NetworkClient {
    /** ǥեȤ SO_TIMEOUT */
    protected static int defaultSoTimeout;
    /** ǥեȤ CONNECT_TIMEOUT */
    protected static int defaultConnectTimeout;
    /** ǥեȤνϥ󥳡ǥ */
    protected static String defaultOutputEncoding;

    /** ƥå */
    static {
        Integer i;
        String  s;

        // SO_TIMEOUT
        i = Integer.getInteger("kagetaka.net.client.defaultReadTimeout");
        if (i == null) {
            i = Integer.getInteger("sun.net.client.defaultReadTimeout");
        }
        defaultSoTimeout = (i != null ? i.intValue() : -1);

        // CONNECT_TIMEOUT
        i = Integer.getInteger("kagetaka.net.client.defaultConnectTimeout");
        if (i == null) {
            i = Integer.getInteger("sun.net.client.defaultConnectTimeout");
        }
        defaultConnectTimeout = (i != null ? i.intValue() : -1);

        // OUTPUT_ENCODING
        s = System.getProperty("kagetaka.net.client.defaultOutputEncoding",
                               System.getProperty("file.encoding",
                                                  "ISO8859_1"));
        try {
            if (!isAsciiSuperset(s)) {
                s = "ISO8859_1";
            }
        } catch (Exception e) {
            s = "ISO8859_1";
        }
        defaultOutputEncoding = s;
    }

    /** 󥳡ǥ󥰤 ASCII ߴĴ٤ */
    private static boolean isAsciiSuperset(String encoding)
            throws Exception {
        String strings = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
        byte[] bytes   = strings.getBytes(encoding);

        if (bytes.length != strings.length()) {
            return false;
        }

        int length = bytes.length;
        for (int i = 0; i < length; i++) {
            if (bytes[i] != (byte) strings.charAt(i)) {
                return false;
            }
        }

        return true;
    }

    /**
     * ³Ԥ³åȤ֤ޤ
     *
     * @param  host ФΥۥ
     * @param  port ФΥݡ
     *
     * @return ³ѤߤΥå
     *
     * @throws IOException IO 顼ȯ
     * @throws java.net.UnknownHostException ʥۥȤꤷ
     */
    public static Socket doConnect(String host, int port) throws IOException {
        Socket s = new Socket(host, port);
        //### BUGS java2 Ǻ
/*
        Socket s = new Socket();

        if (defaultConnectTimeout > 0) {
            s.connect(new InetSocketAddress(server, port), defaultConnectTimeout);
        } else {
            s.connect(new InetSocketAddress(server, port));
        }
*/

        if (defaultSoTimeout > 0) {
            s.setSoTimeout(defaultSoTimeout);
        }

        return s;
    }

    /**
     * ͥåȥ饤Ȥޤ
     */
    protected NetworkClient() {
    }
}
