/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.net.URL;
import java.util.StringTokenizer;

/**
 * ͥåȥ˴ؤ桼ƥƥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public final class NetUtils {
    /** ߡ */
    private NetUtils() {
    }

    /**
     * ꤵ줿̾ IP ɥ쥹ɤ֤ޤ
     *
     * @param  name å̾
     *
     * @return IP ɥ쥹ξ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public static boolean isIpAddress(String name) {
        int length = name.length();
        if (length == 0) {
            return false;
        }

        // ǽ 16 ʰʳξϥۥ̾
        if (/*---*/!isHexDigit(name.charAt(0         ))
                || !isHexDigit(name.charAt(length - 1))) {
            return false;
        }

        if (name.indexOf('.') == -1) {
            // ͤΤߤå
            return isDigit(name);
        } else if (name.indexOf(':') != -1) {
            // IPv6  IP ɥ쥹å
            StringTokenizer st = new StringTokenizer(name, ":", true);
            String s;
            int count = 0;
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.compareTo(":") == 0) {
                    count++;
                } else {
                    if (!isHexDigit(s)) {
                        return false;
                    }
                }
            }
            return (2 <= count && count <= 6);
        } else {
            // nnn.nnn.nnn.nnn Υå
            StringTokenizer st = new StringTokenizer(name, ".");
            int count = 0;
            while (st.hasMoreTokens()) {
                count++;
                if (!isDigit(st.nextToken())) {
                    return false;
                }
            }
            return (count == 4);
        }
    }

    /**
     * ꤵ줿Ĥ URL Υѥ
     * ꤵ줿֤ޤƱɤåޤ
     *
     * @param  url1  URL1
     * @param  url2  URL2
     * @param  level åѥΥ٥
     *
     * @return <code>url1</code>  <code>url2</code> Υѥ
     *         <code>level</code> ޤƱ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public static boolean isSamePath(URL url1, URL url2, int level) {
        if (url1.getHost().compareTo(url2.getHost()) != 0) {
            return false;
        }

        if (url1.getPort() != url2.getPort()) {
            return false;
        }

        String s1 = url1.getFile();
        String s2 = url2.getFile();
        int p;

        // ѥ¸ߤʤabout: ʤɡ
        if ((p = s1.indexOf('/')) == -1) {
            return true;
        }

        while (level-- > 0 && ((p = s1.indexOf('/', p + 1)) != -1)) {
            // AVOID
        }
        if (p == -1) {
            p = s1.lastIndexOf('/');
        }

        if (s2.length() <= p) {
            return false;
        }

        for (int i = 0; i <= p; i++) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return false;
            }
        }

        return true;
    }

    /** ꤵ줿ʸ 16 ʤɤ֤ */
    private static boolean isHexDigit(char c) {
        return ('0' <= c && c <= '9'
             || 'A' <= c && c <= 'F'
             || 'a' <= c && c <= 'f');
    }

    /** ꤵ줿ʸ 16 ʤɤ֤ */
    private static boolean isHexDigit(String value) {
        for (int i = value.length() - 1; i >= 0; i--) {
            if (!isHexDigit(value.charAt(i))) {
                return false;
            }
        }

        return true;
    }

    /** ꤵ줿ʸ 10 ʤɤ֤ */
    private static boolean isDigit(String value) {
        char c;
        for (int i = value.length() - 1; i >= 0; i--) {
            c = value.charAt(i);
            if (c > '0' || '9' < c) {
                return false;
            }
        }

        return true;
    }
}
