/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import net.hizlab.kagetaka.io.TextOutputStream;

import java.io.InputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

/**
 * RFC 844  MIME إåɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class MessageHeader {
    private Entry top;

    /**
     * 󥹥󥹤ޤ
     */
    public MessageHeader() {
    }

    /**
     * إåΰ֤ޤ
     *
     * @return إå
     */
    public synchronized Hashtable getHeaders() {
        return getHeaders(null);
    }

    /**
     * إåΰ֤ޤ
     *
     * @param  excludeList ˴ޤޤʤꥹ
     *
     * @return إå
     */
    public synchronized Hashtable getHeaders(String[] excludeList) {
        Hashtable hash   = new Hashtable();
        Vector    v;
        boolean   skipIt = false;

        Entry entry = top;
        while (entry != null) {
            // ¾ꥹ
            if (excludeList != null) {
                for (int i = 0; i < excludeList.length; i++) {
                    if (/*---*/excludeList[i] != null
                            && excludeList[i].equalsIgnoreCase(entry.key)) {
                        skipIt = true;
                        break;
                    }
                }
            }

            if (!skipIt) {
                if ((v = (Vector) hash.get(entry.key)) == null) {
                    v = new Vector();
                    hash.put(entry.key, v);
                }
                v.addElement(entry.value);
            } else {
                skipIt = false;
            }
            entry = entry.next;
        }

        return hash;
    }

    /**
     * Ƭͤɲäޤ
     *
     * @param  key   
     * @param  value 
     */
    public synchronized void prepend(String key, String value) {
        Entry entry = new Entry(key, value);
        entry.next = top;
        top = entry;
    }

    /**
     * ˤޤ
     */
    public synchronized void reset() {
        top = null;
    }

    /**
     * ͤɲäޤ˥¸ߤϾ񤭤ޤ
     *
     * @param  key   
     * @param  value 
     */
    public synchronized void set(String key, String value) {
        if (top == null) {
            top = new Entry(key, value);
        } else if (key.equalsIgnoreCase(top.key)) {
            top.value = value;
        } else {
            Entry entry = top;
            while (entry.next != null) {
                if (key.equalsIgnoreCase(entry.next.key)) {
                    entry.next.value = value;
                    return;
                }
                entry = entry.next;
            }
            entry.next = new Entry(key, value);
        }
    }

    /**
     * ꤷǥåΥͤꤷޤ
     *
     * @param  index ǥå
     * @param  key   
     * @param  value 
     */
    public synchronized void set(int index, String key, String value) {
        if (top == null) {
            return;
        }

        Entry entry = top;
        while (entry != null) {
            if (index == 0) {
                entry.key   = key;
                entry.value = value;
                return;
            }
            entry = entry.next;
            index--;
        }
    }

    /**
     * ¸ߤʤȤΤͤɲäޤ
     *
     * @param  key   
     * @param  value 
     */
    public synchronized void setIfNotSet(String key, String value) {
        if (top == null) {
            top = new Entry(key, value);
        } else if (!key.equalsIgnoreCase(top.key)) {
            Entry entry = top;
            while (entry.next != null) {
                if (key.equalsIgnoreCase(entry.next.key)) {
                    return;
                }
                entry = entry.next;
            }
            entry.next = new Entry(key, value);
        }
    }

    /**
     * ͤɲäޤ
     *
     * @param  key   
     * @param  value 
     */
    public synchronized void add(String key, String value) {
        if (top == null) {
            top = new Entry(key, value);
        } else {
            Entry entry = top;
            while (entry.next != null) {
                entry = entry.next;
            }
            entry.next = new Entry(key, value);
        }
    }

    /**
     * ͤޤ
     *
     * @param  key   
     *
     * @return ͡¸ߤʤ <code>null</code>
     */
    public synchronized String get(String key) {
        if (top == null) {
            return null;
        }
        if (key.equalsIgnoreCase(top.key)) {
            return top.value;
        }

        Entry entry = top;
        while (entry.next != null) {
            if (key.equalsIgnoreCase(entry.next.key)) {
                return entry.next.value;
            }
            entry = entry.next;
        }
        return null;
    }

    /**
     * ͤޤ
     *
     * @param  index ǥå
     *
     * @return ͡¸ߤʤ <code>null</code>
     */
    public synchronized String get(int index) {
        if (top == null) {
            return null;
        }

        Entry entry = top;
        while (entry != null) {
            if (index == 0) {
                return entry.value;
            }
            entry = entry.next;
            index--;
        }

        return null;
    }

    /**
     * ޤ
     *
     * @param  index ǥå
     *
     * @return ͡¸ߤʤ <code>null</code>
     */
    public synchronized String keyAt(int index) {
        if (top == null) {
            return null;
        }

        Entry entry = top;
        while (entry != null) {
            if (index == 0) {
                return entry.key;
            }
            entry = entry.next;
            index--;
        }

        return null;
    }

    /**
     * ͤΥڥޤ
     *
     * @param  index ǥå
     */
    public synchronized void remove(int index) {
        if (top == null) {
            return;
        }

        Entry entry = top;

        if (index == 0) {
            top = entry.next;
            return;
        }

        while (entry != null) {
            if (index == 1) {
                if (entry.next != null) {
                    entry.next = entry.next.next;
                }
                return;
            }
            entry = entry.next;
            index--;
        }
    }

    /**
     * ϥȥ꡼फإåɤ߼ޤ
     *
     * @param  is ϥȥ꡼
     *
     * @return ɤ᤿ <code>true</code>
     *         ǥȥ꡼κǸãƤޤä <code>false</code>
     *
     * @throws IOException IO 顼ȯ
     */
    public boolean parse(InputStream is)
            throws IOException {
        synchronized (this) {
            top = null;
        }
        return merge(is);
    }

    /**
     * ϥȥ꡼फإåɲäޤ
     *
     * @param  is ϥȥ꡼
     *
     * @return ɤ᤿ <code>true</code>
     *         ǥȥ꡼κǸãƤޤä <code>false</code>
     *
     * @throws IOException IO 顼ȯ
     */
    public boolean merge(InputStream is)
            throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("stream is null");
        }

        char[]  buffer = new char[100];
        int     c;
        boolean inKey, cr;
        int     length;
        int     colonPos;

        for (;;) {
            inKey    = true;
            cr       = false;
            length   = 0;
            colonPos = 0;

            READ:
            for (;;) {
                switch (c = is.read()) {
                case '\r':
                    cr = true;
                    c  = ' ';
                    break;
                case '\n':
                    if (cr) {        // CRLF ξ
                        length--;    // CR ʬ᤹
                    }
                    break READ;      // LF ñȤǤԤȸʤ
                case ':':
                    if (inKey && length > 0) {
                        colonPos = length;
                    }
                    inKey = false;
                    break;
                case ' ':
                    // إåΥ˥ڡϤʤΤǡñ̤ͤȤ
                    inKey = false;
                    break;
                case -1:
                    break READ;
                default:
                    // ȥ륳ɤϥڡˤƤޤ
                    if (c < ' ') {
                        c = ' ';
                    }
                }
                // ХåեΥ䤹
                if (length >= buffer.length) {
                    char[] newCs = new char[buffer.length * 2];
                    System.arraycopy(buffer, 0, newCs, 0, length);
                    buffer = newCs;
                }
                buffer[length++] = (char) c;
            }

            // ԤιԤ䡢üä
            if (length == 0) {
                return (c != -1);
            }

            // ǸΥ֥󥯤̵
            while (length > 0 && buffer[length - 1] == ' ') {
                length--;
            }

            String key;
            if (colonPos == 0) {
                key = null;
            } else {
                key = new String(buffer, 0, colonPos);
                // ѥ졼ξɤФʥڡξ⤢ꤨ
                if (colonPos < length && buffer[colonPos] == ':') {
                    colonPos++;
                }
                // ʬƬΥڡɤФ
                while (colonPos < length && buffer[colonPos] <= ' ') {
                    colonPos++;
                }
            }

            String value;
            if (colonPos >= length) {
                value = new String();
            } else {
                value = new String(buffer, colonPos, length - colonPos);
            }

//Debug.out.println("2[" + (key != null ? (key + ": " + value) : value) + "]");
            add(key, value);

            // ȥ꡼νüãƤ
            if (c == -1) {
                return false;
            }
        }
    }

    /**
     * ƤϤޤ
     *
     * @param  out ϥȥ꡼
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(TextOutputStream out)
            throws IOException {
        Entry entry = top;
        while (entry != null) {
            out.write(entry.key);
            if (entry.value != null) {
                out.write(": ");
                out.write(entry.value);
            }
            out.write("\r\n");
//Debug.out.println("1[" + (entry.value != null ? (entry.key + ": " + entry.value) : entry.key) + "]");
            entry = entry.next;
        }
        out.write("\r\n");
        out.flush();
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());

        Entry entry = top;
        while (entry != null) {
            sb.append(entry.toString());
            entry = entry.next;
        }

        return sb.toString();
    }

//### Entry
    /** ȥ꡼ */
    private final class Entry {
        private String key;
        private String value;
        private Entry  next;

        /** 󥹥󥹤 */
        private Entry(String key, String value) {
            this.key   = key;
            this.value = value;
        }

        /** ʸɽ֤ */
        public String toString() {
            return "{" + key + ": " + value + "}";
        }
    }
}
