/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.util.Vector;

/**
 * HTTP/RFC822 إåեɤʬ򤷤ޤ
 * 'timeout=15, max=5'  {{"timeout", "15"}, {"max", "5"}} ˡ
 * 'Basic Realm="FuzzFace" Foo="Biz Bar Baz"' 
 * {{"basic", null}, {"realm", "FuzzFace"}, {"foo", "Biz Bar Baz"}}
 * ʬ򤷤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class HeaderParser {
    private String     raw;
    private String[][] values;

    /**
     * եɤʬ򤷤̤ޤ
     *
     * @param  raw ե
     */
    public HeaderParser(String raw) {
        this.raw = raw;
        parse();
    }

    /** ʬ */
    private void parse() {
        if (raw == null) {
            return;
        }

        char[] cs     = raw.toCharArray();
        int    length = cs.length;
        int    start, end = 0, save;
        char c;
        Vector       v   = new Vector();
        String       key = null;
        StringBuffer sb  = null;

        // ƬΥڡ̵
        while (end < length && (cs[end] == ' ' || cs[end] == ',')) {
            end++;
        }
        start = end;

        while (end < length) {
            c = cs[end];
            switch (c) {
            case '=':
                if (key != null) {
                    end++;
                    continue;
                }

                save = end - 1;
                // Υڡ
                while (save > start && cs[save] == ' ') {
                    save--;
                }
                key = (new String(cs, start, save - start + 1)).toLowerCase();
                end++;
                // = ľΥڡɤФ
                while (end < length && cs[end] == ' ') {
                    end++;
                }
                start = end;
                if (end < length && cs[end] != '"') {
                    continue;
                }

                // " ǻϤޤϤ٤ڤФƤޤ
                start++;
                while (++end < length) {
                    c = cs[end];
                    if (c == '\\') {                  // \ ϼʸ򥨥
                        if (start < end) {
                            if (sb == null) {
                                sb = new StringBuffer(length - start);
                            }
                            sb.append(cs, start, end - start);
                        }
                        start = end + 1;
                        if (++end >= length) {
                            break;
                        }
                    } else if (c == '"') {
                        break;
                    }
                }
                // Ͽ
                if (sb != null && sb.length() > 0) {
                    if (start < end) {
                        sb.append(cs, start, end - start);
                    }
                    v.addElement(new String[]{key, sb.toString()});
                    sb.setLength(0);
                } else {
                    v.addElement(new String[]{key, new String(cs, start, end - start)});
                }
                // ΥڡޤɤФ
                do {
                    end++;
                } while (end < length && (cs[end] == ' ' || cs[end] == ','));
                key   = null;
                start = end;
                continue;
            case ' ':
            case ',':
                if (key == null) {
                    save = end;
                    if (c == ' ') {
                        // ľΥڡɤФ= Ƥʤå
                        do {
                            end++;
                        } while (end < length && cs[end] == ' ');
                        if (end < length && cs[end] == '=') {
                            continue;
                        }
                        end--;
                    }
                    v.addElement(new String[]{(new String(cs, start, save - start)).toLowerCase(), null});
                } else {
                    v.addElement(new String[]{key, new String(cs, start, end - start)});
                }
                do {
                    end++;
                } while (end < length && (cs[end] == ' ' || cs[end] == ','));
                key   = null;
                start = end;
                continue;
            default:
                end++;
            }
        }

        // ǸΥڥ
        if (start < end) {
            if (key == null) {
                v.addElement(new String[]{new String(cs, start, end - start), null});
            } else {
                v.addElement(new String[]{key, new String(cs, start, end - start)});
            }
        }

        values = new String[v.size()][2];
        v.copyInto(values);
    }

    /**
     * бͤޤ
     *
     * @param  key 
     *
     * @return ͡䡢бͤ¸ߤʤ <code>null</code>
     */
    public String get(String key) {
        if (values == null) {
            return null;
        }

        key = key.toLowerCase();
        for (int i = 0; i < values.length; i++) {
            if (values[i][0].compareTo(key) == 0) {
                return values[i][1];
            }
        }

        return null;
    }

    /**
     * бͤ int Ǽޤ
     *
     * @param  key 
     * @param  def ¸ߤʤäꡢͤͤǤϤʤ䡢
     *             ͤʤν
     *
     * @return 
     */
    public int getInt(String key, int def) {
        String value = get(key);

        if (value != null) {
            try {
                return Integer.parseInt(value);
            } catch (Exception e) { }
        }

        return def;
    }

    /**
     * ¸ߤ뤫ɤ֤ޤ
     *
     * @param  key 
     *
     * @return ¸ߤ <code>true</code>
     *         ¸ߤʤ <code>false</code>
     */
    public boolean containsKey(String key) {
        if (values == null) {
            return false;
        }

        key = key.toLowerCase();
        for (int i = 0; i < values.length; i++) {
            if (values[i][0].compareTo(key) == 0) {
                return true;
            }
        }

        return false;
    }

/*
///// ƥ
public static final void main(String[] args) {
    String[] rows =
    {
        "timeout=15, max=5",
        " timeout = 15, max = 5 ",
        "Basic Realm=\"FuzzFace\" Foo=\"Biz Bar Baz\"",
        "novalue=\"\"",
        "short=\"abc\"long=a\"bc\"",
        "invalid=\"012 789",
        "invalid==abc",
    };
    HeaderParser p;
    for (int i = 0; i < rows.length; i++) {
        p = new HeaderParser(rows[i]);
        Debug.out.println("#[" + rows[i] + "]");
        for (int j = 0; j < p.values.length; j++) {
            Debug.out.println("[" + p.values[j][0] + (p.values[j][1]!=null?"]=[" + p.values[j][1] + "]":"]"));
        }
    }
}
*/
}
