/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.net;

import java.io.InputStream;
import java.io.IOException;

/**
 * Υȥ꡼Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
class EmptyInputStream extends InputStream implements InputStreamExtension {
    /** HTTP 饤 */
    protected HttpClient http;
    /** ϥȥ꡼ */
    protected InputStream in;

    private StreamMonitor streamMonitor;    // ȥ꡼˥

    /**
     * Υȥ꡼ޤ
     *
     * @param  http HTTP 饤
     * @param  in   ϥȥ꡼
     */
    EmptyInputStream(HttpClient http, InputStream in) {
        this.http = http;
        this.in   = in;
    }

    /**
     * ɤ߹߲ǽʥХȿ֤ޤ
     *
     * @return ɤ߹߲ǽʥХȿɬ <code>0</code>
     *
     * @throws IOException I/O 顼ȯ
     */
    public int available() throws IOException {
        ensureOpen();

        release();
        return 0;
    }

    /**
     * ɤ߹ߤԤޤ
     *
     * @return ɤ߹ǡ
     *         ɬȥ꡼νãȤ򼨤 <code>-1</code>
     *
     * @throws IOException I/O 顼ȯ
     */
    public int read() throws IOException {
        ensureOpen();

        release();
        return -1;
    }

    /**
     * ϥȥ꡼򥯥˴ϢƤΥƥ꥽
     * ޤ
     *
     * @throws IOException I/O 顼ȯ
     */
    public synchronized void close()
            throws IOException {
        if (in == null) {
            return;
        }

        release();
        in = null;
    }

    /** HTTP 饤Ȥ */
    private void release() {
        if (http != null) {
            http.release(in, false);
            http = null;

            if (streamMonitor != null) {
                try {
                    streamMonitor.stop(StreamMonitor.END_OF_STREAM);
                } finally {
                    streamMonitor = null;
                }
            }
        }
    }

    /** Ƥ뤫å */
    private void ensureOpen()
            throws IOException {
        if (in == null) {
            throw new IOException("Stream closed");
        }
    }

    /* ȥ꡼ήǡƻ뤹뤿Υ˥ */
    /** {@inheritDoc} */
    public void setStreamMonitor(StreamMonitor sm) {
        this.streamMonitor = sm;
    }
}
