/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import java.io.BufferedWriter;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.IOException;

/**
 * ʸϤǤ륹ȥ꡼Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class TextOutputStream extends FilterOutputStream {
    private boolean            closed;
    private BufferedWriter     textOut;
    private String             encoding;

    /**
     * ꤷ󥳡ǥ󥰤ʸϤ륹ȥ꡼ޤ
     *
     * @param  out      
     * @param  encoding ʸΥ󥳡ǥ
     */
    public TextOutputStream(OutputStream out, String encoding) {
        super(out);
        this.textOut  = new BufferedWriter(new OutputStreamWriter(out));
        this.encoding = encoding;
    }

    /**
     * ХȥǡϤޤ
     *
     * @param  b Х
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(int b)
            throws IOException {
        ensureOpen();
        out.write(b);
    }

    /**
     * ХϤޤ
     *
     * @param  b Х
     * @param  off 񤭽Фեå
     * @param  len 񤭽ФĹ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(byte[] b, int off, int len)
            throws IOException {
        ensureOpen();
        out.write(b, off, len);
    }

    /**
     * ñʸϤޤ
     *
     * @param  c ʸ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(char c)
            throws IOException {
        ensureOpen();
        textOut.write(c);
    }

    /**
     * ʸϤޤ
     *
     * @param  cbuf ʸ
     * @param  off  񤭽Фեå
     * @param  len  񤭽ФĹ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(char[] cbuf, int off, int len)
            throws IOException {
        ensureOpen();
        textOut.write(cbuf, off, len);
    }

    /**
     * ʸϤޤ
     *
     * @param  s ʸ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(String s)
            throws IOException {
        write(s, 0, s.length());
    }

    /**
     * ʸϤޤ
     *
     * @param  s   ʸ
     * @param  off 񤭽Фեå
     * @param  len 񤭽ФĹ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void write(String s, int off, int len)
            throws IOException {
        ensureOpen();
        textOut.write(s, off, len);
    }

    /**
     * ȥ꡼եå夷ޤ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void flush()
            throws IOException {
        ensureOpen();
        textOut.flush();
        out    .flush();
    }

    /**
     * ޤ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void close()
            throws IOException {
        if (!closed) {
            closed = true;
            textOut.close();
            out    .close();
            textOut = null;
            out     = null;
        }
    }

    /**
     * ߤʸ󥨥󥳡ǥ󥰤֤ޤ
     *
     * @return 󥳡ǥ
     */
    public String getEncoding() {
        return encoding;
    }

    /** ȥ꡼बƤ뤫å */
    private void ensureOpen()
            throws IOException {
        if (closed) {
            throw new IOException("Stream closed");
        }
    }
}
