/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import net.hizlab.kagetaka.addin.java2.IOWrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

/**
 * ǽ˰ե˽Ϥ
 * Ȥեž
 * ե륢ȥץåȥȥ꡼Ǥ
 * <p>
 * ˡˤꡢǥ顼ȯƤ⡢
 * ե˱ƶͿޤ
 * <p>
 * ե뤿ˡλˤ
 * {@link #close()}  {@link #abort()} Τɤ餫
 * ƤӽФ褦ˤƤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class SafetyFileOutputStream extends FileOutputStream {
    private File realFile;
    private File tempFile;

    /**
     * եͳơ
     * <code>file</code> ؽϤ륹ȥ꡼ޤ
     *
     * @param  file ե
     *
     * @throws java.io.FileNotFoundException
     *         ե¸ߤ뤬̤ΥեǤϤʤ
     *         ǥ쥯ȥǤ硢ե¸ߤǤʤ硢
     *         ޤϤʤ餫ͳǳȤǤʤ
     * @throws IOException IO 顼ȯ
     */
    public SafetyFileOutputStream(File file)
            throws IOException {
        this(file, createTempFile(file));
    }

    /** źեեѥ뤿Υ󥹥ȥ饯 */
    private SafetyFileOutputStream(File real, File temp)
            throws IOException {
        super(temp);

        this.realFile = real;
        this.tempFile = temp;
    }

    /**
     * ե뤫ե
     * ϥǡ¸ޤ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void close() throws IOException {
        close(true);
    }

    /**
     * ޤե뤫ե
     * ϥǡ¸ޤ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized void abort() throws IOException {
        close(false);
    }

    /**
     * եؤ³򥯥꡼󥢥åפ
     * Υȥ꡼ؤλȤʤʤäȤ
     * Υեϥȥ꡼ {@link #abort()}
     * ᥽åɤƤӽФ褦ˤޤ
     *
     * @throws IOException IO 顼ȯ
     */
    protected void finalize() throws IOException {
        try {
            abort();
        } finally {
            super.finalize();
        }
    }

    /** Ĥ */
    private synchronized void close(boolean save) throws IOException {
        if (tempFile != null) {
            try {
                super.close();

                // ԡ
                if (save) {
                    FileUtils.copy(tempFile, realFile);
                }
            } finally {
                // 
                tempFile.delete();

                tempFile = null;
                realFile = null;
            }
        }
    }

    /** ե֤ */
    private static File createTempFile(File file) throws IOException {
        // Ƭ
        String prefix = file.getName();
        int    n      = prefix.indexOf('.');
        if (n != -1) {
            prefix = prefix.substring(0, n);
        }
        if (prefix.length() < 3) {
            prefix += "xxx";
        }
        if (prefix.length() > 3) {
            prefix = prefix.substring(0, 3);
        }
        // ǥ쥯ȥ
        File directory = new File(file.getParent());

        // Java2 θƤӽФ
        IOWrapper ioWrapper = IOWrapper.getInstance();
        if (ioWrapper != null) {
            return ioWrapper.createTempFile(prefix, null, directory);
        }

        // õ
        Random random = new Random(System.currentTimeMillis());
        FileOutputStream os = null;
        File    temp;
        boolean created = false;
        for (;;) {
            temp = new File(directory,
                            prefix + ((int) (random.nextDouble() * 99999)) + ".tmp");
            if (temp.exists()) {
                continue;
            }

            /*
             * Ƥߤ롣ΤȤ̯Υߥ󥰤
             * ˥ե뤬¸ߤƤ뤫⤷ʤ
             * ξϥե뤬롦
             */
            try {
                os = new FileOutputStream(temp);
                created = true;
            } finally {
                if (os != null) {
                    try {
                        os.close();
                    } catch (IOException e) {
                        created = false;
                    } finally {
                        os = null;
                    }
                }
            }

            if (created) {
                return temp;
            }

            // 
            temp.delete();
        }
    }
}
