/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import java.io.InputStream;
import java.io.IOException;

/**
 * ȥ꡼फɤ߹ǡĹݻ륹ȥ꡼Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class MeteredInputStream extends InputStream {
    /** ؤϥȥ꡼ */
    protected InputStream in;
    /** ɤ߹Хȿ */
    protected long    readLength = 0;
    /** ѤǤޡ */
    protected int     markLimit  = -1;
    /** ޡλĤХȿ */
    protected int     markLength;
    /** ޡ֤ɤ߹ߺѤߥХȿ */
    protected long    markedCount;

    /**
     * ꤵ줿ϥȥ꡼򸵤ˤ󥹥󥹤ޤ
     *
     * @param  in ϥȥ꡼
     */
    public MeteredInputStream(InputStream in) {
        this.in = in;
    }

    /**
     * ΥХϥȥ꡼फ顢ǡμΥХȤɤ߹ߤޤ
     * ΥХȤϡ<code>0</code>  <code>255</code> ϰϤ
     * <code>int</code> Ȥ֤ޤ
     * ȥ꡼νãƥХȤʤϡ
     *  <code>-1</code> ֤ޤ
     * Υ᥽åɤϡϥǡɤ߹ޤ褦ˤʤ뤫
     * ȥ꡼ν꤬Ф뤫
     * ޤ㳰ޤǥ֥åޤ
     *
     * @return ǡμΥХȡ
     *         ȥ꡼νã <code>-1</code>
     *
     * @throws IOException I/O 顼ȯ
     */
    public synchronized int read()
            throws IOException {
        ensureOpen();

        int n = in.read();
        append((n != -1 ? 1 : -1));

        return n;
    }

    /**
     * ΥХϥȥ꡼फХȤɤ߼äơ
     * ꤵ줿Х˻ΥեåȤޤ
     *
     * @param  b   žХåե
     * @param  off ХȤγǼϥեå
     * @param  len ɤ߹ХȤκ
     *
     * @return ɤ߹ޤХȿ
     *         ȥ꡼νã <code>-1</code>
     *
     * @throws IOException I/O 顼ȯ
     */
    public synchronized int read(byte[] b, int off, int len)
            throws IOException {
        ensureOpen();

        int readlen = in.read(b, off, len);
        append(readlen);

        return readlen;
    }

    /**
     * ϥȥ꡼फΥǡФ
     * <code>n</code> ХȤåפƥǡΤƤޤ
     *
     * @param  n åפХȿ
     *
     * @return ºݤ˥åפ줿Хȿ
     *
     * @throws IOException I/O 顼ȯ硣
     */
    public synchronized long skip(long n)
            throws IOException {
        ensureOpen();

        n = in.skip(n);
        append(n);

        return n;
    }

    /**
     * ֥å󥰤ȯ뤳Ȥʤˡ
     * Ϥɤ߹ळȤΤǤХȿ֤ޤ
     *
     * @return ɤ߹Хȿ
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized int available()
            throws IOException {
        ensureOpen();

        return in.available();
    }

    /**
     * ϥȥ꡼򥯥˴ϢƤΥƥ꥽
     * ޤ
     *
     * @throws IOException I/O 顼ȯ
     */
    public void close()
            throws IOException {
        if (in == null) {
            return;
        }

        try {
            in.close();
        } finally {
            in = null;
        }
    }

    /**
     * ϥȥ꡼θ֤߰˥ޡդޤ
     *
     * @param  readlimit ޡ̵֤ˤʤɤ߹߲ǽʺХȿ
     */
    public synchronized void mark(int readlimit) {
        if (in == null) {
            return;
        }

        in.mark(readlimit);
        markedCount = readLength;
        markLimit   = readlimit;
        markLength  = readlimit;
    }

    /**
     * ϥȥ꡼غǸ {@link #mark(int)} ᥽åɤ
     * ƤӽФ줿ȤΥޡ֤ؤΥȥ꡼ΰ֤ꤷޤ
     *
     * @throws IOException ȥ꡼˥ޡդƤʤä硢
     *                     ޤϥޡ̵ˤʤäƤ
     */
    public synchronized void reset()
            throws IOException {
        ensureOpen();

        if (markLength < 0) {
            throw new IOException ("Resetting to an invalid mark");
        }

        in.reset();
        if (readLength != markedCount) {
            readLength = markedCount;
            markLength = markLimit;
            changed(readLength);
        }
    }

    /**
     * ޡ򥵥ݡȤƤ뤫ɤ֤ޤ
     *
     * @return ޡ򥵥ݡȤƤ <code>true</code>
     *         ݡȤƤʤ <code>false</code>
     */
    public boolean markSupported() {
        return (in == null ? false : in.markSupported());
    }

    /**
     * ɤ߹ߺѤߤĹѹä˸ƤӽФޤ
     *
     * @param  length ߤĹ
     */
    protected void changed(long length) {
    }

    /** ɤ߹ХȤ򥫥ȥå */
    private void append(long count)
            throws IOException {
        if (count == -1) {
            return;
        }

        readLength += count;

        if (markLength >= 0) {
            if ((markLength -= count) < -1) {
                markLength = -1;
            }
        }

        changed(readLength);
    }

    /** Ƥ뤫å */
    private void ensureOpen()
            throws IOException {
        if (in == null) {
            throw new IOException("Stream closed");
        }
    }
}
