/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

/**
 * ե˴ؤΥ桼ƥƥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public final class FileUtils {
    private static final int BUFFER_SIZE = 512;

    /** ߡ */
    private FileUtils() {
    }

    /**
     * ե <code>src</code>  <code>dst</code> إԡޤ
     * ե°ϥԡޤ
     * եΥԡ㳰ȯǤ⡢
     * ԡեϺޤ
     *
     * @param  src ԡե
     * @param  dst ԡե
     *
     * @throws IOException IO 顼ȯ
     */
    public static void copy(File src, File dst) throws IOException {
        InputStream  is = null;
        OutputStream os = null;

        try {
            is = new BufferedInputStream(
                   new FileInputStream(src),
                   BUFFER_SIZE);
            os = new BufferedOutputStream(
                   new FileOutputStream(dst),
                   BUFFER_SIZE);

            byte[] buffer = new byte[BUFFER_SIZE];
            int    length;

            while ((length = is.read(buffer, 0, BUFFER_SIZE)) != -1) {
                os.write(buffer, 0, length);
            }
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) { }
            }
            if (os != null) {
                try {
                    os.flush();
                } catch (IOException e) { }
                try {
                    os.close();
                } catch (IOException e) { }
            }
        }
    }
}
