/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.IOException;

/**
 * Ƚ̤뤿Υ饹Ǥ
 * ޡꥻåȤϥݡȤƤޤ
 * ޤåɥդǤϤʤΤǡʣΥåɴ֤
 * Ʊ˻ѤϡƱ˵ĤƤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class EolInputStream extends FilterInputStream {
    private static final int NO = 0;
    private static final int CR = 1;

    private int last = NO;
    private int crlf = 0;
    private int cr   = 0;
    private int lf   = 0;

    /**
     * ꤵ줿ץåȥȥ꡼򸵤ˤ󥹥󥹤ޤ
     *
     * @param  in ץåȥȥ꡼
     */
    public EolInputStream(InputStream in) {
        super(in);
    }

    /**
     * ΥХϥȥ꡼फ顢ǡμΥХȤɤ߹ߤޤ
     * ΥХȤϡ<code>0</code>  <code>255</code> ϰϤ
     * <code>int</code> Ȥ֤ޤ
     * ȥ꡼νãƥХȤʤϡ
     *  <code>-1</code> ֤ޤ
     * Υ᥽åɤϡϥǡɤ߹ޤ褦ˤʤ뤫
     * ȥ꡼ν꤬Ф뤫
     * ޤ㳰ޤǥ֥åޤ
     *
     * @return ǡμΥХȡ
     *         ȥ꡼νã <code>-1</code>
     *
     * @throws IOException I/O 顼ȯ
     */
    public int read()
            throws IOException {
        int b = in.read();

        if (b == '\r') {
            if (last == CR) {
                cr++;
            }
            last = CR;
        } else {
            if (b == '\n') {
                if (last == CR) {
                    crlf++;
                } else {
                    lf++;
                }
            } else {
                if (last == CR) {
                    cr++;
                }
            }
            last = NO;
        }

        return b;
    }

    /**
     * ΥХϥȥ꡼फХȤɤ߼äơ
     * ꤵ줿Х˻ΥեåȤޤ
     *
     * @param  b   žХåե
     * @param  off ХȤγǼϥեå
     * @param  len ɤ߹ХȤκ
     *
     * @return ɤ߹ޤХȿ
     *         ȥ꡼νã <code>-1</code>
     *
     * @throws IOException I/O 顼ȯ
     */
    public int read(byte[] b, int off, int len)
            throws IOException {
        int length = in.read(b, off, len);

        int end = length + off;
        for (int i = off; i < end; i++) {
            switch (b[i]) {
            case '\r':
                if (last == CR) {
                    cr++;
                }
                last = CR;
                continue;
            case '\n':
                if (last == CR) {
                    crlf++;
                } else {
                    lf++;
                }
                last = NO;
                continue;
            default:
                if (last == CR) {
                    cr++;
                }
                last = NO;
            }
        }

        return length;
    }

    /**
     * ɤ߹ޤ줿ǡι֤ޤ
     *
     * @return 
     */
    public String getEol() {
        int cr = this.cr;
        if (last == CR) {
            cr++;
        }

        if (crlf == 0 && lf == 0 && cr == 0) {
            return "\n";
        }

        if (crlf >= cr && crlf >= lf) {
            return "" + '\r' + '\n';
        }

        if (lf >= cr && lf >= crlf) {
            return String.valueOf('\n');
        }

        return String.valueOf('\r');
    }
}
