/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.tate;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.event.ActionEvent;
import net.hizlab.kagetaka.rendering.Option;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * ɽΥܥǤ
 *
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class TextField extends TextComponent {
    private static final String RESOURCE    = "net.hizlab.kagetaka.awt.tate.Resources";
    private static final String BASE        = "textfield";
    private static       int    nameCounter = 0;

    /** @serial ޥ̾ */
    private String command;
    /** @serial ʸ */
    private int    maxlength;

    private transient ActionListener actionListener;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  option ץ
     * @param  ic     ᡼ꥨ
     */
    public TextField(Option option, ImageCreator ic) {
        this(option, ic, null, 20);
    }

    /**
     * ꤵ줿ƥȤޤ।󥹥󥹤ޤ
     *
     * @param  option  ץ
     * @param  ic      ᡼ꥨ
     * @param  text    ƥ
     */
    public TextField(Option option, ImageCreator ic, String text) {
        this(option, ic, text, (text != null ? text.length() : 20));
    }

    /**
     * ꤵ줿Υ󥹥󥹤ޤ
     *
     * @param  option  ץ
     * @param  ic      ᡼ꥨ
     * @param  columns 
     */
    public TextField(Option option, ImageCreator ic, int columns) {
        this(option, ic, null, columns);
    }

    /**
     * ꤵ줿ƥȤΥ󥹥󥹤ޤ
     *
     * @param  option  ץ
     * @param  ic      ᡼ꥨ
     * @param  text    ƥ
     * @param  columns 
     */
    public TextField(Option option, ImageCreator ic, String text, int columns) {
        super(option, ic, text, 1, columns, false);

        addKeyListener(
            new KeyAdapter() {
                /** 줿 */
                public void keyPressed(KeyEvent e) {
                    if (!isEnabled()) {
                        return;
                    }

                    switch (e.getKeyCode()) {
                    case KeyEvent.VK_ENTER:
                        e.consume();
                        postActionEvent(e.getModifiers());
                        break;
                    default: // AVOID
                    }
                }
            }
        );
    }

    /**
     * ΥƥȥեɤΥѥ᡼ʸ֤ޤ
     *
     * @return ѥ᡼ʸ
     */
    protected String paramString() {
        String str = super.paramString();
        if (echoChar != 0) {
            str += ",echo=" + echoChar;
        }
        return str;
    }

    /** {@inheritDoc} */
    String getComponentName() {
        return BASE + nameCounter++;
    }

    /** {@inheritDoc} */
    public int getColumns() {
        return super.getColumns();
    }

    /** {@inheritDoc} */
    public void setColumns(int columns) {
        super.setColumns(columns);
    }

    /**
     * ʸ֤ޤ
     *
     * @return ʸ
     */
    public char getEchoChar() {
        return echoChar;
    }

    /**
     *  TextField Υʸꤷޤ
     * ϡѥɤɽ TextField Τ褦ˡ
     * 桼Ϥ̤˥ʤեɤǤ
     *
     * @param  c ʸ
     */
    public void setEchoChar(char c) {
        char oldEchoChar = this.echoChar;
        if (oldEchoChar == c) {
            return;
        }

        echoChar = c;
        Text text = this.text;
        if (text != null) {
            this.text = text.getText(c);
        }
    }

    /**
     * TextField ʸäƤ뤫ɤ֤ޤ
     *
     * @return ʸäƤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean echoCharIsSet() {
        return (echoChar != 0);
    }

    /**
     * ϤǤʸ֤ޤ
     *
     * @return ʸ̵¤ξ <code>0</code>
     */
    public int getMaxLength() {
        return maxlength;
    }

    /**
     * ϤǤʸꤷޤ
     * ̵¤ˤ <code>0</code> ꤷޤ
     *
     * @param  max ϤǤʸ
     */
    public void setMaxLength(int max) {
        this.maxlength = max;
    }

    /**
     * Υܥȯ륢󥤥٥ȤΥޥ֤̾ޤ
     *
     * @return ޥ̾
     */
    public String getActionCommand() {
        return (command != null ? command : getText());
    }

    /**
     * Υܥȯ륢󥤥٥ȤΥޥ̾ꤷޤ
     * ǥեȤǤϡΥޥ̾ܥΥ٥ꤵޤ
     *
     * @param  command ޥ̾
     */
    public void setActionCommand(String command) {
        this.command = command;
    }

    /**
     * ֥ꥹʤϿޤ
     *
     * @param  l Ͽ֥ꥹ
     */
    public synchronized void addActionListener(ActionListener l) {
        enableEvents(AWTEvent.ACTION_EVENT_MASK);
        actionListener = AWTEventMulticaster.add(actionListener, l);
    }

    /**
     * ֥ꥹʤޤ
     *
     * @param  l ֥ꥹ
     */
    public synchronized void removeActionListener(ActionListener l) {
        actionListener = AWTEventMulticaster.remove(actionListener, l);
    }

    /**
     * ΥݡͥȤȯ륳ݡͥȥ٥Ȥޤ
     *
     * @param  e ٥
     */
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            processActionEvent((ActionEvent) e);
            return;
        }
        super.processEvent(e);
    }

    /**
     * ΥݡͥȤȯ륢󥤥٥Ȥ
     * ϿƤ뤹٤Ƥ {@link ActionListener} 뤳Ȥˤꡢ
     * 󥤥٥Ȥޤ
     *
     * @param  e ٥
     */
    protected void processActionEvent(ActionEvent e) {
        if (actionListener != null) {
            actionListener.actionPerformed(e);
        }
    }

    /** 󥤥٥Ȥȯޤ */
    private void postActionEvent(int modifiers) {
        ActionEvent e = new ActionEvent(this,
                                        ActionEvent.ACTION_USER_PERFORMED,
                                        getActionCommand(),
                                        modifiers);
        try {
            getToolkit().getSystemEventQueue().postEvent(e);
        } catch (SecurityException ex) {
            processActionEvent(e);
        }
    }

    /** {@inheritDoc} */
    Window showInputBox(Frame owner, int x, int y) {
        Input input = new Input(owner);

        Dimension inputSize  = input.getSize();
        Dimension screenSize = getToolkit().getScreenSize();
        Point     point      = getLocationOnScreen();
        x += point.x;
        y += point.y;
        x -= inputSize.width  * x / screenSize.width;
        y -= inputSize.height * y / screenSize.height;
        input.setLocation(x, y);
        input.show();
        input.text.requestFocus();
        input.toFront();

        return input;
    }

//### Input
    /** ϥ */
    private final class Input extends Dialog {
        private java.awt.TextField text;
        private boolean isClosed;

        /** 󥹥󥹤 */
        private Input(Frame parent) {
            super(parent, Resource.getMessage(RESOURCE, "input.title", null), false);

            text = new java.awt.TextField(getText(), getColumns());
            text.setForeground(TextField.this.getForeground());
            text.setBackground(TextField.this.getBackground());
            text.setFont      (TextField.this.getFont      ());
            if (echoChar != 0) {
                text.setEchoChar(echoChar);
            }
            if (isLocked()) {
                text.setEditable(false);
                setTitle(Resource.getMessage(RESOURCE, "view.title", null));
            }
            add(text);

            pack();

            // ꥹʤϿ
            addWindowListener(
                new WindowAdapter() {
                    /** ɥĤ */
                    public void windowClosing(WindowEvent e) {
                        close(false);
                    }

                    /** ƥ֤ǤϤʤʤä */
                    public void windowDeactivated(WindowEvent e) {
                        close(true);
                    }
                }
            );
            text.addKeyListener(
                new KeyAdapter() {
                    /** ʸϤ줿 */
                    public void keyTyped(KeyEvent e) {
                        if (maxlength != 0 && text.getText().length() >= maxlength) {
                            char c = e.getKeyChar();
                            // ̾ʸ 0x16 (Ctrl+V) ̵
                            if (!Character.isISOControl(c) || c == 0x16) {
                                e.consume();
                            }
                        }
                    }

                    /** 줿 */
                    public void keyPressed(KeyEvent e) {
                        switch (e.getKeyCode()) {
                        case KeyEvent.VK_ESCAPE:
                            e.consume();
                            close(false);
                            break;
                        case KeyEvent.VK_ENTER:
                            e.consume();
                            close(true);
                            break;
                        default: // AVOID
                        }
                    }
                }
            );
        }

        /** Ĥ */
        private void close(boolean commit) {
            synchronized (this) {
                if (isClosed) {
                    return;
                }
                isClosed = true;
            }

            if (commit) {
                String v = text.getText();
                if (maxlength != 0 && v.length() >= maxlength) {
                    v = v.substring(0, maxlength);
                }
                setText(v);
            }

            dispose();
        }

        /**  */
        public void update(Graphics g) {
            paint(g);
        }
    }
}
