/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.tate;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.rendering.Option;

import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;

/**
 * Υ饹ϡϢ Checkbox ܥѤ¿¾פޤ
 *
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class FileField extends Container {
    private static final String RESOURCE    = "net.hizlab.kagetaka.awt.tate.Resources";
    private static final String BASE        = "filefield";
    private static       int    nameCounter = 0;

    /** @serial ̾ */
    private String  name;
    /** @serial ̾ꤵ줿ɤ */
    private boolean nameExplicitlySet = false;

    /** @serial ƥ */
    private TextField text;
    /** @serial ܥ */
    private Button    button;

    /** @serial Υȥ */
    private String         title;
    /** @serial ե̾Υե륿 */
    private FilenameFilter filter;

    /**
     * Υեեɤޤ
     *
     * @param  option ץ
     * @param  ic     ᡼ꥨ
     */
    public FileField(Option option, ImageCreator ic) {
        this(option, ic, null, 20);
    }

    /**
     * ꤷե̾ޤեեɤޤ
     *
     * @param  option ץ
     * @param  ic     ᡼ꥨ
     * @param  file   ե̾
     */
    public FileField(Option option, ImageCreator ic, String file) {
        this(option, ic, file, 20);
    }

    /**
     * ꤷե̾ޤեեɤޤ
     *
     * @param  option  ץ
     * @param  ic      ᡼ꥨ
     * @param  file    ե̾
     * @param  columns 
     */
    public FileField(Option option, ImageCreator ic, String file, int columns) {
        text   = new TextField(option, ic, file, columns);
        button = new Button   (option, ic, Resource.getMessage(RESOURCE, "filefield.button.browse", null));

        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(0, 0, 0, 0);
        setLayout(gbl);
        LayoutUtils.addGridBag(this, text  , gbl, 0, 0, 1, 1, 1, 1, GridBagConstraints.VERTICAL, GridBagConstraints.NORTH, insets);
        insets.top = 2;
        LayoutUtils.addGridBag(this, button, gbl, 0, 1, 1, 1, 1, 0, GridBagConstraints.NONE    , GridBagConstraints.SOUTH, insets);

        button.addActionListener(
            new ActionListener() {
                /**  */
                public void actionPerformed(ActionEvent e) {
                    // Frame 򸡽
                    Frame owner = LayoutUtils.getFrame(FileField.this);
                    if (owner == null) {
                        return;
                    }

                    // ȥ
                    String title = FileField.this.title;
                    if (title == null) {
                        title = Resource.getMessage(RESOURCE, "filefield.browse.title", null);
                    }

                    // 
                    FileDialog fd = new FileDialog(owner, title);
                    String fileName = text.getText();
                    // ե̾ꤵƤơ磻ɥɤʤ
                    if (/*---*/fileName.length() > 0
                            && fileName.indexOf('*') == -1
                            && fileName.indexOf('?') == -1) {
                        File file = new File(fileName);
                        fd.setDirectory(file.getParent());
                        fd.setFile     (file.getName  ());
                    }
                    if (filter != null) {
                        fd.setFilenameFilter(filter);
                    }

                    // ɽ
                    fd.show();

                    // OK 򲡤줿
                    if ((fileName = fd.getFile()) != null) {
                        text.setText(fd.getDirectory() + fileName);
                    }
                }
            }
        );
    }

    /**
     * ̤򥢥åץǡȤޤ
     *
     * @param  g եå
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ΥեեɤΥѥ᡼ʸ֤ޤ
     *
     * @return ѥ᡼ʸ
     */
    protected String paramString() {
        String str = super.paramString();
        return str + ",file=" + text.getText();
    }

    /**
     * ݡͥȤ֤̾ޤ
     *
     * @return ̾
     */
    public String getName() {
        String nowName = this.name;
        if (nowName != null) {
            return nowName;
        }
        synchronized (this) {
            if (name == null && !nameExplicitlySet) {
                name = (BASE + nameCounter++);
            }
        }
        return name;
    }

    /**
     * ݡͥȤ̾ꤷޤ
     *
     * @param  name ̾
     */
    public void setName(String name) {
        synchronized (this) {
            super.setName(name);
            this.name              = name;
            this.nameExplicitlySet = true;
        }
    }

    /**
     * ե뤳Ȥ뤫֤ޤ
     *
     * @return ΥݡͥȤϥեΤǡ
     *         <code>true</code> ֤ޤ
     */
    public boolean isFocusTraversable() {
        return true;
    }

    /**
     * ꤵƤܡ֤ޤ
     *
     * @return ܡ
     */
    public Border getBorder() {
        return text.getBorder();
    }

    /**
     * ܡꤷޤ
     *
     * @param  border ܡ
     */
    public void setBorder(Border border) {
        text  .setBorder(border);
        button.setBorder(border);
    }

    /**
     * ե̾򤹤Υȥ֤ޤ
     *
     * @return ȥ
     */
    public String getTitle() {
        return title;
    }

    /**
     * ե̾򤹤Υȥꤷޤ
     *
     * @param  title ȥ
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * ե֤̾ޤ
     *
     * @return ե̾
     */
    public String getFile() {
        return text.getText();
    }

    /**
     * ե̾ꤷޤ
     *
     * @param  file ե̾
     */
    public void setFile(String file) {
        text.setText(file);
    }

    /**
     * եꤹե륿֤ޤ
     *
     * @return ե륿
     */
    public FilenameFilter getFilenameFilter() {
        return filter;
    }

    /**
     * եꤹե륿ꤷޤ
     * ǻꤵե륿ϡȥܥˤե
     * ѤޤƥȥեɤؤľϤϡ
     * Υե륿˴طʤϤ뤳Ȥޤ
     *
     * @param  filter ե륿
     */
    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }
}
