/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.tate;

import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.event.ActionEvent;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.rendering.Option;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * ɽΥܥǤ
 *
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class Button extends Component {
    private static final String BASE        = "button";
    private static       int    nameCounter = 0;

    private static final int   INSET_H      = 5;
    private static final int   INSET_V      = 8;

    /** @serial ٥ʸ */
    private Text   label;
    /** @serial ޥ̾ */
    private String command;

    private transient ActionListener actionListener;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  option ץ
     * @param  ic     ᡼ꥨ
     */
    public Button(Option option, ImageCreator ic) {
        this(option, ic, null);
    }

    /**
     * ꤵ줿٥ɽ롢󥹥󥹤ޤ
     *
     * @param  option ץ
     * @param  ic     ᡼ꥨ
     * @param  label  ܥΥ٥
     */
    public Button(Option option, ImageCreator ic, String label) {
        super(option, ic);
        setLabel(label);

        addKeyListener(
            new KeyAdapter() {
                /** 줿 */
                public void keyPressed(KeyEvent e) {
                    if (!isEnabled()) {
                        return;
                    }

                    switch (e.getKeyCode()) {
                    case KeyEvent.VK_ENTER:
                        e.consume();
                        if (isEnabled()) {
                            postActionEvent(e.getModifiers());
                        }
                        break;
                    case KeyEvent.VK_SPACE:
                        e.consume();
                        setViewState(KEY_DOWN);
                        break;
                    default: // AVOID
                    }
                }

                /** Υ줿 */
                public void keyReleased(KeyEvent e) {
                    if (!isEnabled()) {
                        return;
                    }

                    e.consume();

                    switch (e.getKeyCode()) {
                    case KeyEvent.VK_SPACE:
                        e.consume();
                        if (getViewState() == KEY_DOWN) {
                            setViewState(NORMAL);
                            if (isEnabled()) {
                                postActionEvent(e.getModifiers());
                            }
                        }
                        break;
                    default: // AVOID
                    }
                }
            }
        );

        addMouseListener(
            new MouseAdapter() {
                /** ޥå줿 */
                public void mouseClicked(MouseEvent e) {
                    if (!isEnabled()) {
                        return;
                    }

                    e.consume();

                    if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
                        postActionEvent(e.getModifiers());
                    }
                }
            }
        );
    }

    /**
     * ΥܥΥѥ᡼ʸ֤ޤ
     *
     * @return ѥ᡼ʸ
     */
    protected String paramString() {
        String str = super.paramString();
        return str + ",label=" + getLabel();
    }

    /** {@inheritDoc} */
    String getComponentName() {
        return BASE + nameCounter++;
    }

    /** {@inheritDoc} */
    protected Dimension createPreferredSize() {
        Text label = this.label;
        if (label == null) {
            return new Dimension(INSET_H * 2, INSET_V * 2);
        }

        this.label = label = label.getText(getFont());
        Dimension size = label.getSize(0);
        size.width  += INSET_H * 2;
        size.height += INSET_V * 2;
        return size;
    }

    /** {@inheritDoc} */
    protected void refresh(Image offscreen, Graphics g, Dimension size,
                           int state, boolean focus) {
        Color fg = getForeground();
        Color bg = getBackground();

        Text label = this.label;

        // طʿɤ
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);

        // ٥
        if (label != null) {
            this.label = label = label.getText(getFont());
            g.setFont(label.getFont());
            int   fix   = (state == MOUSE_DOWN || state == KEY_DOWN ? 1 : 0);
            Color color = fg;
            if (state == DISABLE) {
                g.setColor(SystemColor.controlLtHighlight);
                label.draw(g, size.width - INSET_H + fix + 1, INSET_V + fix + 1, 0);
                color = new Color((new GrayFilter(bg)).filterRGB(0, 0, color.getRGB()));
            }
            g.setColor(color);
            label.draw(g, size.width - INSET_H + fix, INSET_V + fix, 0);
        }

        // Ȥ
        Border border = getBorder();
        if (border != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        } else {
            int fix = (focus ? 1 : 0);
            if (state == MOUSE_DOWN || state == KEY_DOWN) {
                g.setColor(SystemColor.controlShadow);
                g.drawLine(fix, fix, size.width - 1 - fix,  fix);
                g.drawLine(fix, fix, fix, size.height - 1 - fix);
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(1 + fix, 1 + fix, size.width - 2 - fix,  1 + fix);
                g.drawLine(1 + fix, 1 + fix, 1 + fix, size.height - 2 - fix);
                g.setColor(SystemColor.controlLtHighlight);
//                g.drawLine(size.width - 2 - fix,  2 + fix, size.width - 2 - fix, size.height - 2 - fix);
//                g.drawLine(2 + fix, size.height - 2 - fix, size.width - 2 - fix, size.height - 2 - fix);
                g.drawLine(size.width - 1 - fix,  1 + fix, size.width - 1 - fix, size.height - 1 - fix);
                g.drawLine(1 + fix, size.height - 1 - fix, size.width - 1 - fix, size.height - 1 - fix);
            } else {
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(fix, fix, size.width - 1 - fix,  fix);
                g.drawLine(fix, fix, fix, size.height - 1 - fix);
//                g.drawLine(1 + fix, 1 + fix, size.width - 2 - fix,  1 + fix);
//                g.drawLine(1 + fix, 1 + fix, 1 + fix, size.height - 2 - fix);
                g.setColor(SystemColor.controlShadow);
                g.drawLine(size.width - 2 - fix,  2 + fix, size.width - 2 - fix, size.height - 2 - fix);
                g.drawLine(2 + fix, size.height - 2 - fix, size.width - 2 - fix, size.height - 2 - fix);
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(size.width - 1 - fix,  1 + fix, size.width - 1 - fix, size.height - 1 - fix);
                g.drawLine(1 + fix, size.height - 1 - fix, size.width - 1 - fix, size.height - 1 - fix);
            }
        }

        // եȤɽ
        if (focus) {
            g.setColor(fg);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            GraphicsUtils.drawDashed(g, 3, 3, size.width  - 7, 1, 1, 1, GraphicsUtils.HORIZONTAL);
            GraphicsUtils.drawDashed(g, 3, 3, 1, size.height - 7, 1, 1, GraphicsUtils.VERTICAL  );
            GraphicsUtils.drawDashed(g, 3, size.height - 4, size.width - 7, 1, 1, 1, GraphicsUtils.HORIZONTAL);
            GraphicsUtils.drawDashed(g, size.width - 4, 3, 1, size.height - 7, 1, 1, GraphicsUtils.VERTICAL  );
        }
    }

    /**
     * ܥɽ٥֤ޤ
     *
     * @return ܥΥ٥
     */
    public String getLabel() {
        Text label = this.label;
        return (label != null ? label.getValue() : "");
    }

    /**
     * ܥɽ٥ꤷޤ
     *
     * @param  label ܥΥ٥
     */
    public synchronized void setLabel(String label) {
        Text oldLabel = this.label;

        if (label != null) {
            if (oldLabel != null && oldLabel.getValue().compareTo(label) == 0) {
                return;
            }

            this.label = getText(label, (char) 0);
        } else if (oldLabel == null) {
            return;
        } else {
            this.label = null;
        }

        invalidate();
        repaintForce();
    }

    /**
     * Υܥȯ륢󥤥٥ȤΥޥ֤̾ޤ
     *
     * @return ޥ̾
     */
    public String getActionCommand() {
        return (command != null ? command : getLabel());
    }

    /**
     * Υܥȯ륢󥤥٥ȤΥޥ̾ꤷޤ
     * ǥեȤǤϡΥޥ̾ܥΥ٥ꤵޤ
     *
     * @param  command ޥ̾
     */
    public void setActionCommand(String command) {
        this.command = command;
    }

    /**
     * ꥹʤϿޤ
     *
     * @param  l Ͽ륢ꥹ
     */
    public synchronized void addActionListener(ActionListener l) {
        enableEvents(AWTEvent.ACTION_EVENT_MASK);
        actionListener = AWTEventMulticaster.add(actionListener, l);
    }

    /**
     * ꥹʤޤ
     *
     * @param  l 륢ꥹ
     */
    public synchronized void removeActionListener(ActionListener l) {
        actionListener = AWTEventMulticaster.remove(actionListener, l);
    }

    /**
     * ΥݡͥȤȯ륳ݡͥȥ٥Ȥޤ
     *
     * @param  e ٥
     */
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            processActionEvent((ActionEvent) e);
            return;
        }
        super.processEvent(e);
    }

    /**
     * ΥݡͥȤȯ륢󥤥٥Ȥ
     * ϿƤ뤹٤Ƥ {@link ActionListener} 뤳Ȥˤꡢ
     * 󥤥٥Ȥޤ
     *
     * @param  e ٥
     */
    protected void processActionEvent(ActionEvent e) {
        if (actionListener != null) {
            actionListener.actionPerformed(e);
        }
    }

    /** 󥤥٥Ȥȯޤ */
    private void postActionEvent(int modifiers) {
        ActionEvent e = new ActionEvent(this,
                                        ActionEvent.ACTION_USER_PERFORMED,
                                        getActionCommand(),
                                        modifiers);
        try {
            getToolkit().getSystemEventQueue().postEvent(e);
        } catch (SecurityException ex) {
            processActionEvent(e);
        }
    }
}
