/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.panel;

import net.hizlab.kagetaka.rendering.Request;

/**
 * ԤδĶɽޤ
 * Υ󥿡եͳơĶѹޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public interface PanelListener {
    /** åѤɤ߹ߤԤޤ */
    int RELOAD_CACHE  = Request.CACHE_SOFT;
    /** ̾κɤ߹ߤԤޤ */
    int RELOAD_NORMAL = Request.CACHE_NORMAL;
    /** åԤޤ */
    int RELOAD_CHECK  = Request.CACHE_CHECK;
    /** å򤤤äѤʤɤ߹ߤԤޤ */
    int RELOAD_FORCE  = Request.CACHE_NONE;

    /**
     * ꤷꥯȤɽޤ
     *
     * @param  request ꥯ
     */
    void openHawk(Request request);

    /**
     * ޤ
     */
    void back();

    /**
     * 뤫ɤ֤ޤ
     *
     * @return  <code>true</code>
     *         ʤ <code>false</code>
     */
    boolean canBack();

    /**
     * ؿʤߤޤ
     */
    void forward();

    /**
     * ؿʤ뤫ɤ֤ޤ
     *
     * @return ؿʤ <code>true</code>
     *         ʤʤ <code>false</code>
     */
    boolean canForward();

    /**
     * ɹޤ
     *
     * @param  mode ɤ߹ߤΥ⡼
     */
    void reload(int mode);

    /**
     * ɹǤ뤫ɤ֤ޤ
     *
     * @return ɹ <code>true</code>
     *         ʤ <code>false</code>
     */
    boolean canReload();

    /**
     * ߤޤ
     */
    void stop();

    /**
     * ߤǤ뤫ɤ֤ޤ
     *
     * @return ߽ <code>true</code>
     *         ʤ <code>false</code>
     */
    boolean canStop();

    /**
     * 襹꡼Υѹ줿ΤΤޤ
     *
     * @param  tag ѹ̤륿
     */
    void screenResized(int tag);
}
