/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import net.hizlab.kagetaka.Debug;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

/**
 * 򱦤 90 ٲžե륿
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class RotateFilter extends ImageFilter {
    private static ColorModel defaultColorModel = ColorModel.getRGBdefault();

    private int srcHeight;                  // ꥸʥβι⤵

    /**
     * 򱦤 90 ٲžե륿ޤ
     */
    public RotateFilter() {
    }

    /**
     * žΥѴޤ
     *
     * @param  width  
     * @param  height ⤵
     */
    public void setDimensions(int width, int height) {
        srcHeight = height;
        consumer.setDimensions(height, width);
    }

    /**
     * 顼ǥѴޤºݤˤ RGB ǥ뤬Ѥޤ
     *
     * @param  model ǥ
     */
    public void setColorModel(ColorModel model) {
        consumer.setColorModel(defaultColorModel);
    }

    /**
     * žΥҥȤѴޤ
     *
     * @param  hintflags ҥ
     */
    public void setHints(int hintflags) {
        consumer.setHints(RANDOMPIXELORDER
                        | COMPLETESCANLINES
                        | SINGLEPASS
                        | (hintflags & SINGLEFRAME));
    }

    /**
     * ԥѴޤ
     * ºݤˤϡΥ᥽åǤѴ줺
     * {@link #imageComplete(int)} ƤӽФޤǡХåե˳Ǽޤ
     *
     * @param  x X
     * @param  y Y
     * @param  w 
     * @param  h ⤵
     * @param  model    顼ǥ
     * @param  pixels   ԥ
     * @param  off      եå
     * @param  scansize 󥵥
     */
    public void setPixels(int x, int y, int w, int h, ColorModel model,
                          byte[] pixels, int off, int scansize) {
//Debug.out.println("setPixels1 " + Integer.toHexString(hashCode()) + "="+x+","+y+","+w+","+h+","+pixels.length+","+off+","+scansize+","+srcHeight);
if (srcHeight == 0) {
    Debug.err.println("### ERROR ### RotateFilter.setPixels1 : " + Integer.toHexString(hashCode()) + " : h=" + srcHeight);
    return;
}

        if (h == -1) {
            // ˰Ԥξϡϰ֤ scansize Ѥ
            consumer.setPixels(srcHeight - y - 1, x, h, w, model, pixels, off, 1);
        } else {
            byte[] rotate = new byte[w * h];

            // ž
            int dx, dy, sp, dp = 0;
            for (dy = 0; dy < w; dy++) {
                sp = h * scansize + dy + off;
                for (dx = h; dx > 0; dx--) {
                    rotate[dp++] = pixels[sp -= scansize];
                }
            }

            consumer.setPixels(srcHeight - y - h, x, h, w, model, rotate, 0, h);
        }
    }

    /**
     * ԥѴޤ
     * ºݤˤϡΥ᥽åǤѴ줺
     * {@link #imageComplete(int)} ƤӽФޤǡХåե˳Ǽޤ
     *
     * @param  x X
     * @param  y Y
     * @param  w 
     * @param  h ⤵
     * @param  model    顼ǥ
     * @param  pixels   ԥ
     * @param  off      եå
     * @param  scansize 󥵥
     */
    public void setPixels(int x, int y, int w, int h, ColorModel model,
                          int[] pixels, int off, int scansize) {
//Debug.out.println("setPixels2 " + Integer.toHexString(hashCode()) + "="+x+","+y+","+w+","+h+","+pixels.length+","+off+","+scansize+","+srcHeight);
if (srcHeight == 0) {
    Debug.err.println("### ERROR ### RotateFilter.setPixels2 : " + Integer.toHexString(hashCode()) + " : h=" + srcHeight);
    return;
}
        if (h == 1) {
            // ˰Ԥξϡϰ֤ scansize Ѥ
            consumer.setPixels(srcHeight - y - 1, x, h, w, model, pixels, off, 1);
        } else {
            int[] rotate = new int[w * h];

            // ž
            int dx, dy, sp, dp = 0;
            for (dy = 0; dy < w; dy++) {
                sp = h * scansize + dy + off;
                for (dx = h; dx > 0; dx--) {
                    rotate[dp++] = pixels[sp -= scansize];
                }
            }

            consumer.setPixels(srcHeight - y - h, x, h, w, model, rotate, 0, h);
        }
    }
}
