/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

/**
 * ե꡼Ф빹򡢥ݡͥȤΤ뤿Υ饹Ǥ
 * <p>
 * {@link Graphics#drawImage(Image, int, int, ImageObserver)}
 * θƤӽФѤǤޤ
 * <code>drawImage</code> ͤ <code>false</code> ξ硢
 * Υ饹Υ󥹥󥹤ꤷݡͥȤФ
 * Ԥޤ⤷ <code>true</code> äϡ
 * Υ饹Υ󥹥󥹤ѤʤΤǡ¾ؤѤǽǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class OffscreenObserver implements ImageObserver {
    private Component c;
    private Image     offscreen;

    /** 褹 x ɸ */
    public int   x;
    /** 褹 y ɸ */
    public int   y;
    /** ꥸʥ륤᡼ */
    public Image original;

    private volatile boolean stop;

    /**
     * 褹륤󥹥󥹤ޤ
     *
     * @param  c         ե꡼ѤƤ륳ݡͥ
     * @param  offscreen ե꡼
     */
    public OffscreenObserver(Component c, Image offscreen) {
        this.c         = c;
        this.offscreen = offscreen;
    }

    /**
     * ꤷ֤褹륤󥹥󥹤ޤ
     *
     * @param  c         ե꡼ѤƤ륳ݡͥ
     * @param  offscreen ե꡼
     * @param  x         x ɸ
     * @param  y         y ɸ
     */
    public OffscreenObserver(Component c, Image offscreen, int x, int y) {
        this.c         = c;
        this.offscreen = offscreen;
        this.x         = x;
        this.y         = y;
    }

    /**
     * ꥸʥ륤᡼褷Ƥ顢
     * ꤷ֤褹륤󥹥󥹤ޤ
     * <p>
     * ƩΤ륢˥᡼󥤥᡼ʤɤξ硢
     * ˥ꥸʥ륤᡼Ǿ񤭤Ƥ褷ʤȡ
     * ŤʤäƤޤѤޤ
     *
     * @param  c         ե꡼ѤƤ륳ݡͥ
     * @param  offscreen ե꡼
     * @param  x         x ɸ
     * @param  y         y ɸ
     * @param  original  ꥸʥ륤᡼
     */
    public OffscreenObserver(Component c, Image offscreen, int x, int y, Image original) {
        this.c         = c;
        this.offscreen = offscreen;
        this.x         = x;
        this.y         = y;
        this.original  = original;
    }

    /**
     * ᡼ΤФԤޤ
     *
     * @see    ImageObserver#imageUpdate(Image, int, int, int, int, int)
     */
    public boolean imageUpdate(Image img, int infoflags,
                               int x, int y, int width, int height) {
        if (stop) {
            return false;
        }

        Graphics g = offscreen.getGraphics();
        try {
            // 
            if ((infoflags & (ImageObserver.FRAMEBITS | ImageObserver.ALLBITS)) != 0) {
                if (original != null) {
                    g.drawImage(original, this.x, this.y, width, height, this);
                }
                g.drawImage(img, this.x, this.y, width, height, this);
                c.repaint(this.x, this.y, width, height);
            }
        } finally {
            g.dispose();
        }

        return ((infoflags & (ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR)) == 0);
    }

    /**
     * ٤ƤΥ꥽ޤ
     * ˥᡼󥤥᡼ʤɤιߤ뤿˸ƤӽФɬפޤ
     */
    public void dispose() {
        stop = true;
    }
}
