/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

/**
 * ե꡼󥤥᡼󶡤륯饹Ǥ
 * Υ饹ϡĤΥݡͥȤˤĤĤΥ󥹥󥹤
 * {@link Component#paint(java.awt.Graphics)} ᥽åǤ
 * ѤˤƤΤǡ{@link #paint(Graphics)} ᥽åɤ
 * åɥդǤϤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public abstract class OffscreenImage implements Serializable {
    /** @serial ʡ */
    private Component owner;
    /** @serial ʡƥʤɤ */
    private boolean   isContainer;

    /** @serial ե꡼󥤥᡼ */
    private Image     offScreenImage;
    /** @serial ե꡼󥵥 */
    private Dimension offScreenSize;
    /** @serial 褹ɬפ뤫ɤ */
    private boolean   repaint = true;

    /**
     * ե꡼󥤥᡼󶡤륤󥹥󥹤ޤ
     *
     * @param  owner ե꡼ΥʡǤ륳ݡͥ
     */
    public OffscreenImage(Component owner) {
        this.owner       = owner;
        this.isContainer = (owner instanceof Container);
    }

    /**
     * ե꡼󥤥᡼ͳ褷ޤ
     * ƥݡͥȤ {@link Component#paint(Graphics)} 
     * ƤӽФޤ
     * <p>
     * Υ᥽åɤƤӽФȤˤꡢ
     * ºݤ˺褬ɬפʾ {@link #update(Image, Graphics, Dimension)} 
     * ƤӽФޤ
     * <p>
     * Ǹ˥ե꡼褷Ƥ顢
     * ݡͥȤΥѹä硢
     * ե꡼󥤥᡼ʤޤ
     *
     * @param  g եå
     */
    public void paint(Graphics g) {
        Dimension size = owner.getSize();
        boolean   repaint;

        if (offScreenImage == null || !size.equals(offScreenSize)) {
            // ѹƤϡե꡼ƺ
            if (offScreenImage != null) {
                offScreenImage.flush();
            }

            if (size.width == 0 || size.height == 0) {
                offScreenImage = null;
                offScreenSize  = null;
                return;
            }

            offScreenImage = owner.createImage(size.width, size.height);
            offScreenSize  = size;
            repaint        = true;
        } else {
            repaint = this.repaint;
        }
        if (!isContainer) {
            this.repaint = false;
        }

        if (repaint) {
            // ե꡼
            Graphics og = offScreenImage.getGraphics();
            try {
/*
                Rectangle clip = g.getClipBounds();
                if (clip != null) {
                    og.setClip(clip.x, clip.y, clip.width, clip.height);
                }
*/
                update(offScreenImage, og, size);
            } finally {
                og.dispose();
            }
        }

        g.drawImage(offScreenImage, 0, 0, size.width, size.height, owner);
    }

    /**
     * ե꡼󥤥᡼򹹿뤿νޤ
     * ե꡼󥤥᡼ιɬפʾ˸ƤӽФޤ
     *
     * @param  offscreen ե꡼󥤥᡼
     * @param  g         ե꡼󥤥᡼ؤΥեå
     * @param  size      ե꡼󥤥᡼Υ
     */
    public abstract void update(Image offscreen, Graphics g, Dimension size);

    /**
     * ե꡼Τ褹褦˻ؼޤ
     * ե꡼Ƥ񤭴ݡͥȤȿǤɬפ
     * ˸ƤӽФޤ
     */
    public void repaint() {
        if (repaint) {
            return;
        }
        repaint = true;
        if (owner.isShowing()) {
            owner.repaint();
        }
    }

    /**
     * ե꡼ΰ褹褦˻ؼޤ
     * ե꡼Ƥ񤭴ݡͥȤȿǤɬפ
     * ˸ƤӽФޤ
     *
     * @param  x      X
     * @param  y      Y
     * @param  width  
     * @param  height ⤵
     */
    public void repaint(int x, int y, int width, int height) {
        if (repaint) {
            return;
        }
        repaint = true;
        if (owner.isShowing()) {
            owner.repaint(x, y, width, height);
        }
    }

    /**
     * ꥽ޤ
     */
    public void dispose() {
        if (offScreenImage != null) {
            offScreenImage.flush();
            offScreenImage = null;
            offScreenSize  = null;
        }
    }
}
