/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.Serializable;

/**
 * ե꡼󥤥᡼Ѥ褹뤿Υ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class OffscreenBuffer implements Serializable {
    /** @serial ʡ */
    private Container         owner;
    /** @serial ƥʥꥹ */
    private ContainerListener listener;
    /** @serial ݡͥ */
    private Component[]       components;
    /** @serial ե꡼󥤥᡼ */
    private OffscreenImage    offscreenImage;

    /**
     * ե꡼󥤥᡼Ѥ褹뤿Υ󥹥󥹤ޤ
     *
     * @param  owner եåΥʡǤ륳ƥ
     */
    public OffscreenBuffer(Container owner) {
        this.owner          = owner;
        this.components     = owner.getComponents();
        this.offscreenImage = new OffscreenImage(owner) {
            public void update(Image offscreen, Graphics g, Dimension size) {
                refresh(offscreen, g, size);
            }
        };

        // ꥹʡϿ
        owner.addContainerListener(
            listener = new ContainerListener() {
                /** ݡͥȤɲä줿 */
                public void componentAdded(ContainerEvent e) {
                    components = OffscreenBuffer.this.owner.getComponents();
                }

                /** ݡͥȤ줿 */
                public void componentRemoved(ContainerEvent e) {
                    components = OffscreenBuffer.this.owner.getComponents();
                }
            }
        );
    }

    /**
     * ݡͥȤºݤ褷ޤ
     *
     * @param  g եå
     */
    public synchronized void paint(Graphics g) {
        offscreenImage.paint(g);
    }

    /**
     * ꥽ޤ
     */
    public synchronized void dispose() {
        if (offscreenImage != null) {
            offscreenImage.dispose();
            offscreenImage = null;

            owner.removeContainerListener(listener);
            components = null;
            listener   = null;
        }
    }

    /**  */
    private void refresh(Image offscreen, Graphics g, Dimension size) {
        // åΰѾطʿ
        g.setColor(owner.getBackground());
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        } else {
            g.fillRect(0, 0, size.width, size.height);
        }

        // ľΥݡͥȤ
        Component[] components = this.components;
        if (components != null) {
            int ncomponents = components.length;
            Component c;
            Rectangle bounds;
            Graphics  cg;
            for (int i = ncomponents - 1 ; i >= 0 ; i--) {
                if ((c = components[i]) != null && c.isVisible()) {
                    bounds = c.getBounds();
                    if ((clip == null) || bounds.intersects(clip)) {
                        cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
                        try {
                            cg.setFont(c.getFont());
                            c.paint(cg);
                        } finally {
                            cg.dispose();
                        }
                    }
                }
            }
        }
    }
}
