/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import net.hizlab.kagetaka.Debug;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;

/**
 * Ǽ뤿Υ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class ImageContainer {
    private static final int IMAGE_SIZE_WAIT = 5000;

    /**  */
    public final Image image;
    /**  */
    public final int   width;
    /** ⤵ */
    public final int   height;

    private final int hashCode;

    /**
     * <code>image</code>  <code>old</code> βƱ
     * <code>old</code> ֤ޤäƤϡ
     * <code>image</code> Ǽ󥹥󥹤֤ޤ
     * <code>image</code>  <code>null</code> ξ硢
     * <code>null</code> ֤ޤ
     *
     * @param  old   åо
     * @param  image 
     *
     * @return ˱󥹥󥹡
     *         뤤 <code>null</code>
     */
    public static ImageContainer setupImageContainer(ImageContainer old, Image image) {
        if (image == null) {
            return null;
        }
        return (old == null || !old.equalsImage(image)
                ? new ImageContainer(image)
                : old);
    }

    /**
     * ꤵ줿βƥʤޤ
     *
     * @param  image 
     * @param  width  
     * @param  height ⤵
     */
    public ImageContainer(Image image, int width, int height) {
        this.image  = image;
        this.width  = width;
        this.height = height;

        this.hashCode = image.hashCode() + width + height;
    }

    /**
     * ƥʤޤ
     * ϲޤ
     *
     * @param  image 
     */
    public ImageContainer(Image image) {
        this.image = image;

        // 礭
        SizeObserver observer = new SizeObserver();
        try {
            // ̡˥å򤫤ʤȡimageUpdate ˤޤʤ
            synchronized (observer) {
                observer.width  = image.getWidth (observer);
            }
            synchronized (observer) {
                observer.height = image.getHeight(observer);
            }

            // ǤʤϡޤԵ
            synchronized (observer) {
                if (observer.width < 0 || observer.height < 0) {
                    try {
                        observer.wait(IMAGE_SIZE_WAIT);
                    } catch (InterruptedException e) {
                        //### ERROR
Debug.err.println("### WARNING ### ImageContainer : wait to get a image size");
e.printStackTrace(Debug.err);
                    }
                }
            }
        } finally {
            observer.dispose();
        }
        this.width    = observer.width;
        this.height   = observer.height;
        this.hashCode = image.hashCode() + width + height;
    }

    /**
     * Ʊɤǧޤ
     *
     * @param  size 礭
     *
     * @return Ʊ <code>true</code>
     *         㤦 <code>false</code>
     */
    public boolean equalsSize(Dimension size) {
        if (size == null) {
            return false;
        }
        return (size.width  == width
             && size.height == height);
    }

    /**
     * Ʊɤǧޤ
     *
     * @param  ic Ĵ٤⤦Ĥβƥ
     *
     * @return Ʊ <code>true</code>
     *         㤦 <code>false</code>
     */
    public boolean equalsSize(ImageContainer ic) {
        if (ic == null) {
            return false;
        }
        return (ic.width  == width
             && ic.height == height);
    }

    /**
     * Ʊɤǧޤ
     *
     * @param  image 
     *
     * @return Ʊ <code>true</code>
     *         㤦 <code>false</code>
     */
    public boolean equalsImage(Image image) {
        if (image == null) {
            return false;
        }
        return (image == this.image);
    }

    /**
     * Ʊɤǧޤ
     *
     * @param  ic Ĵ٤⤦Ĥβƥ
     *
     * @return Ʊ <code>true</code>
     *         㤦 <code>false</code>
     */
    public boolean equalsImage(ImageContainer ic) {
        if (ic == null) {
            return false;
        }
        return (ic.image == image);
    }

    /**
     * Ʊɤǧޤ
     *
     * @param  obj Ĵ٤⤦Ĥβƥ
     *
     * @return Ʊ <code>true</code>
     *         㤦 <code>false</code>
     */
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ImageContainer)) {
            return false;
        }
        ImageContainer ic = (ImageContainer) obj;
        return (ic.image  == image
             && ic.width  == width
             && ic.height == height);
    }

    /**
     * ֥ȤΥϥå女֤ͤޤ
     *
     * @return Υ֥ȤΥϥå女
     */
    public int hashCode() {
        return hashCode;
    }

//### SizeObserver
    /** μ */
    private final class SizeObserver implements ImageObserver {
        private boolean stop;
        private int     width;
        private int     height;

        /** 󥹥󥹤 */
        private SizeObserver() {
        }

        /** ᡼ */
        public boolean imageUpdate(Image img, int infoflags,
                                   int x, int y, int width, int height) {
//Debug.out.println("src=" + src + ",alt=" + alt + ",iu=" + infoflags + "," + x+"," + y+"," + width + "," + height);
            if (stop) {
                return false;
            }

            // 
            if ((infoflags & (ImageObserver.WIDTH | ImageObserver.HEIGHT)) != 0) {
                synchronized (this) {
                    if (((infoflags & ImageObserver.WIDTH ) != 0) && (this.width  == -1)) {
                        this.width  = width;
                    }
                    if (((infoflags & ImageObserver.HEIGHT) != 0) && (this.height == -1)) {
                        this.height = height;
                    }

                    if (this.width != -1 && this.height != -1) {
                        notify();
                    }
                }
            }

            // Τλ
            if ((infoflags & (ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR)) != 0) {
                synchronized (this) {
                    // ǤƤʤ 0 ˤ
                    if (this.width  == -1) {
                        this.width  = 0;
                    }
                    if (this.height == -1) {
                        this.height = 0;
                    }

                    notify();
                }
                return false;
            }

            return true;
        }

        /** ˴ */
        private void dispose() {
            stop = true;
        }
    }
}
