/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.event;

import net.hizlab.kagetaka.awt.TabPanel;

import java.awt.Component;
import java.awt.event.ComponentEvent;

/**
 * ֤Υ٥ȤƤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class TabEvent extends ComponentEvent {
    private static final long serialVersionUID = -4920569181427301866L;

    /** ƥ֤ʥ֤ѹ줿 */
    public static final int ACTIVE_CHANGED = RESERVED_ID_MAX + 1001;
    /** ֤ɲä줿 */
    public static final int TAB_ADDED      = RESERVED_ID_MAX + 1002;
    /** ֤줿 */
    public static final int TAB_REMOVED    = RESERVED_ID_MAX + 1003;
    /** ֤ѹ줿 */
    public static final int TAB_CHANGED    = RESERVED_ID_MAX + 1004;

    /** @serial  */
    private TabPanel.Tab tab;

    /**
     * ƥ֤ʥ֤ѹ줿˸ƤӽФޤ
     *
     * @param  source ֥٥ȵݡͥ
     * @param  tab    
     * @param  id     ٥ ID
     */
    public TabEvent(Component source, TabPanel.Tab tab, int id) {
        super(source, id);
        this.tab = tab;
    }

    /**
     * ٥Ȥθˤʤä֤֤ޤ
     *
     * @return 
     */
    public TabPanel.Tab getTab() {
        return tab;
    }

    /**
     * Υ٥Ȥʸ֤ޤ
     *
     * @return ٥ʸ
     */
    public String paramString() {
        String typeStr;

        switch(id) {
        case ACTIVE_CHANGED: typeStr = "ACTIVE_CHANGED"; break;
        case TAB_ADDED     : typeStr = "TAB_ADDED"     ; break;
        case TAB_REMOVED   : typeStr = "TAB_REMOVED"   ; break;
        case TAB_CHANGED   : typeStr = "TAB_CHANGED"   ; break;
        default            : typeStr = "unknown type";
        }

        return "tab=" + tab + "," + typeStr;
    }
}
