/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.awt.image.OffscreenImage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * θꤵ줿٥Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class SizedLabel extends Component {
    /** @serial 侩 */
    private Dimension      preferredSize;
    /** @serial ե꡼ */
    private OffscreenImage offscreenImage;

    /** @serial ٥ʸ */
    private Lines lines;

    /**
     * ٥ɽʸꤷƿ٥ޤ
     *
     * @param  text ٥ɽʸ
     */
    public SizedLabel(String text) {
        setText(text);
    }

    /**
     * ٥ޤ
     */
    public SizedLabel() {
    }

    /**
     * ٥ɽʸꤷޤ
     *
     * @param  text ٥ɽʸ
     */
    public void setText(String text) {
        Lines oldLines = this.lines;
        if ((oldLines == null && text == null)
                || (oldLines != null && oldLines.value.compareTo(text) == 0)) {
            return;
        }

        this.lines = (text != null ? new Lines(text) : null);

        invalidate();
        repaintForce();
    }

    /**
     * ٥ɽʸ֤ޤ
     *
     * @return ٥ɽʸ
     */
    public String getText() {
        Lines lines = this.lines;
        return (lines != null ? lines.value : "");
    }

    /**
     * ٥ΥեȤꤷޤ
     *
     * @param  font ե
     */
    public void setFont(Font font) {
        Font oldFont = getFont();
        if (oldFont != font) {
            super.setFont(font);

            invalidate();
            repaintForce();
        }
    }

    /**
     * 侩֤ޤ
     *
     * @return 侩
     */
    public Dimension getPreferredSize() {
        Dimension preferredSize = this.preferredSize;
        if (preferredSize != null && isValid()) {
            return preferredSize;
        }

        Lines lines = this.lines;
        return this.preferredSize = (lines != null
                                     ? lines.getSize(getFontMetrics(getFont()))
                                     : new Dimension(0, 0));
    }

    /**
     * ݡͥȤ̵ˤޤ
     */
    public void invalidate() {
        preferredSize = null;
        super.invalidate();
    }

    /**
     * ̤򥢥åץǡȤޤ
     *
     * @param  g եå
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ᡼ºݤ褷ޤ
     *
     * @param  g եå
     */
    public void paint(Graphics g) {
        offscreenImage.paint(g);
    }

    /**
     * ݡͥȤƥʤɲä줿ȤΤޤ
     */
    public void addNotify() {
        synchronized (getTreeLock()) {
            super.addNotify();

            // ե꡼
            offscreenImage = new OffscreenImage(this) {
                public void update(Image offscreen, Graphics g, Dimension size) {
                    refresh(offscreen, g, size);
                }
            };
        }
    }

    /**
     * ݡͥȤƥʤ줿ȤΤޤ
     */
    public void removeNotify() {
        synchronized (getTreeLock()) {
            super.removeNotify();

            // ե꡼
            if (offscreenImage != null) {
                offscreenImage.dispose();
                offscreenImage = null;
            }
        }
    }

    /**
     * ե꡼褷ޤ
     *
     * @param  offscreen ե꡼
     * @param  g         եå
     * @param  size      礭
     */
    private void refresh(Image offscreen, Graphics g, Dimension size) {
        g.setColor(getBackground());
        g.fillRect(0, 0, size.width, size.height);

        if (lines != null) {
            Font font = getFont();
            g.setColor(getForeground());
            g.setFont (font);

            FontMetrics fm = getFontMetrics(font);
            int height = fm.getHeight();
            lines.draw(g, height - fm.getDescent(), height);
        }
    }

    /** Ū˺ɽ */
    private void repaintForce() {
        OffscreenImage oi = offscreenImage;
        if (oi != null) {
            oi.repaint();
        }
    }

//### Lines
    /**
     * Ծݻ륯饹Ǥ
     */
    private final class Lines {
        private String value;
        private Vector lines = new Vector();

        /** 󥹥󥹤 */
        private Lines(String value) {
            this.value = value;

            boolean lastCr   = false;
            boolean lastText = false;
            String  line;
            StringTokenizer st = new StringTokenizer(value, "\n\r", true);
            while (st.hasMoreTokens()) {
                line = st.nextToken();

                if (line.compareTo("\n") == 0) {
                    lastCr = true;
                    if (lastText) {
                        lastText = false;
                        continue;
                    }
                    line = "";
                } else if (line.compareTo("\r") == 0) {
                    if (lastCr) {
                        lastCr = false;
                        continue;
                    }
                    if (lastText) {
                        lastText = false;
                        continue;
                    }
                    line = "";
                } else {
                    lastCr   = false;
                    lastText = true;
                }

                lines.addElement(line);
            }
        }

        /** 礭֤ */
        private Dimension getSize(FontMetrics fm) {
            int w = 0;
            int h = lines.size() * fm.getHeight();
            for (int i = lines.size() - 1; i >= 0; i--) {
                w = Math.max(w, fm.stringWidth((String) lines.elementAt(i)));
            }
            return new Dimension(w, h);
        }

        /**  */
        private void draw(Graphics g, int y, int height) {
            for (int i = 0; i < lines.size(); i++, y += height) {
                g.drawString((String) lines.elementAt(i), 0, y);
            }
        }
    }
}
