/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.awt.image.OffscreenImage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.SystemColor;

/**
 * ʹԾɽ뤿Υץ쥹СݡͥȤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class ProgressBar extends Component {
    /** @serial ե꡼ */
    private OffscreenImage offscreenImage;

    /** @serial Ǿ */
    private int min;
    /** @serial  */
    private int max;
    /** @serial ߤ */
    private int now;

    /**
     * ץ쥹Сޤ
     */
    public ProgressBar() {
        this(0, 100, 0);
    }

    /**
     * ץ쥹Сޤ
     *
     * @param  min Ǿ
     * @param  max 
     */
    public ProgressBar(int min, int max) {
        this(min, max, min);
    }

    /**
     * ץ쥹Сޤ
     *
     * @param  min Ǿ
     * @param  max 
     * @param  now ߤ
     */
    public ProgressBar(int min, int max, int now) {
        this.min = min;
        this.max = max;
        this.now = now;

        setForeground(SystemColor.controlShadow);
        setBackground(SystemColor.control      );
    }

//### Original
    /**
     * ߤ֤ͤޤ
     *
     * @return ߤ
     */
    public int getValue() {
        return now;
    }

    /**
     * ͤꤷޤ
     *
     * @param  now ߤ
     */
    public void setValue(int now) {
        int oldNow = this.now;
        if (oldNow != now) {
            this.now = now;
            repaintForce();
        }
    }

//### Override
    /**
     * ץ쥹Сο侩֤ޤ
     * ⤵Τ߻ꤵƤޤ
     *
     * @return 侩
     */
    public Dimension getPreferredSize() {
        return new Dimension(0, 16);
    }

    /**
     * ơСκԤޤ
     *
     * @param  g Graphics ɥ
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ơСԤޤ
     *
     * @param  g Graphics ɥ
     */
    public void paint(Graphics g) {
        offscreenImage.paint(g);
    }

    /**
     * ݡͥȤƥʤɲä줿ȤΤޤ
     */
    public void addNotify() {
        synchronized (getTreeLock()) {
            super.addNotify();

            // ե꡼
            offscreenImage = new OffscreenImage(this) {
                public void update(Image offscreen, Graphics g, Dimension size) {
                    refresh(offscreen, g, size);
                }
            };
        }
    }

    /**
     * ݡͥȤƥʤ줿ȤΤޤ
     */
    public void removeNotify() {
        synchronized (getTreeLock()) {
            super.removeNotify();

            // ե꡼
            if (offscreenImage != null) {
                offscreenImage.dispose();
                offscreenImage = null;
            }
        }
    }

    /**
     * ΥơСΥѥ᡼ʸ֤ޤ
     *
     * @return ѥ᡼ʸ
     */
    protected String paramString() {
        String str = super.paramString();
        return str + ",min=" + min + ",max=" + max + ",now=" + now;
    }

//### private
    /** ե꡼ */
    private void refresh(Image offscreen, Graphics g, Dimension size) {
        // طʿɤ
        Color bg = getBackground();
        Color bgDarker   = ColorConverter.getDarker  (bg);
        Color bgBrighter = ColorConverter.getBrighter(bg);
        g.setColor(bg);
        g.drawRect(1, 1, size.width - 2, size.height - 2);

        // Ȥɽ
        g.setColor(bgDarker);
        g.drawLine(0, 0, size.width,  0);
        g.drawLine(0, 0, 0, size.height);

        g.setColor(bgBrighter);
        g.drawLine(size.width - 1,  0, size.width - 1, size.height - 1);
        g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);

        // Сɽ
        double per = (double) now / (max - min);
        if (per < 0) {
            per = 0;
        } else if (per > 100) {
            per = 100;
        }
        int len = (int) ((size.width - 4) * per);

        if (len > 0) {
            g.setColor(getForeground());
            g.fillRect(2, 2, len, size.height - 4);
        }
        if (len + 4 < size.width) {
            g.setColor(bg);
            g.fillRect(len + 2, 2, size.width - len - 4, size.height - 4);
        }
    }

    /** Ū˺ɽ */
    private void repaintForce() {
        OffscreenImage oi = offscreenImage;
        if (oi != null) {
            oi.repaint();
        }
    }
}
