/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;

/**
 * åܥåǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class MessageBox extends DialogBox {
    private static final int    MARGIN   = 10;

    /** OK ܥ */
    public static final int BUTTON_OK            = DialogBox.BUTTON_OK;
    /** OK ȥ󥻥ܥ */
    public static final int BUTTON_OKCANCEL      = DialogBox.BUTTON_OKCANCEL;
    /** YES  NO ܥ */
    public static final int BUTTON_YESNO         = DialogBox.BUTTON_YESNO;
    /** YES  NO ȥ󥻥ܥ */
    public static final int BUTTON_YESNOCANCEL   = DialogBox.BUTTON_YESNOCANCEL;

    /** ܥǥեȤ */
    public static final int DEFAULT_BUTTON1      = DialogBox.DEFAULT_BUTTON1;
    /** ܥǥեȤ */
    public static final int DEFAULT_BUTTON2      = DialogBox.DEFAULT_BUTTON2;
    /** 軰ܥǥեȤ */
    public static final int DEFAULT_BUTTON3      = DialogBox.DEFAULT_BUTTON3;

    /** ᡼ޡ */
    public static final int ICON_EXCLAMATION     = 0x10000;
    /** ޡ */
    public static final int ICON_QUESTION        = 0x20000;
    /** ޡ */
    public static final int ICON_INFORMATION     = 0x30000;
    /** ȥåץޡ */
    public static final int ICON_STOP            = 0x40000;

    /** ѥޥ */
    protected static final int MASK_ICON = 0xF0000;

    /** @serial 쥤ȥޥ͡ */
    private GridBagLayout  gbl;
    /** @serial å */
    private SizedLabel     message;
    /** @serial  */
    private Icon           icon;

    /**
     * åܥåɽη̤֤ޤ
     *
     * @param  owner ʡ
     * @param  message å
     * @param  title ȥ
     * @param  mode ⡼
     *
     * @return 줿ܥ
     */
    public static int show(Frame owner, String message, String title, int mode) {
        MessageBox messageBox = new MessageBox(owner);
        messageBox.setMessage(message);
        messageBox.setTitle  (title  );
        messageBox.setMode   (mode   );
        messageBox.show();

        return messageBox.getResult();
    }

    /**
     * åܥåɽη̤֤ޤ
     *
     * @param  owner ʡ
     */
    public MessageBox(Frame owner) {
        super(owner, BUTTON_OK);

        setResizable(false);
        setModal    (true );

        // ᥤѥͥ
        gbl = new GridBagLayout();
        mainPanel.setLayout(gbl);

        addToPanel(message = new SizedLabel(), gbl, 1, 0, 1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.WEST  , new Insets(MARGIN, MARGIN, MARGIN, MARGIN));

        // ꥹʡϿ
        KeyListener keyListener = null;
        addButtonKeyListener(keyListener =
            new KeyAdapter() {
                /** Υ줿Ȥ */
                public void keyPressed(KeyEvent e) {
                    // Ctrl-C 򲡤줿
                    if (e.isControlDown() && e.getKeyCode() == KeyEvent.VK_C) {
                        Clipboard       clipboard = getToolkit().getSystemClipboard();
                        StringSelection data      = new StringSelection(message.getText());
                        clipboard.setContents(data, data);
                        e.consume();
                    }
                }
            }
        );
        addKeyListener(keyListener);

        // 礭
        pack();
    }

    /**
     * ꤵƤå֤ޤ
     *
     * @return å
     */
    public String getMessage() {
        return message.getText();
    }

    /**
     * åꤷޤ
     *
     * @param  value å
     */
    public void setMessage(String value) {
        message.setText(value);

        pack();
    }

    /**
     * ⡼ɤꤷޤ
     *
     * @param  value ⡼
     */
    public void setMode(int value) {
        super.setMode(value);

        // Ѱ
        if (icon != null) {
            remove(icon);
        }

        if ((value & MASK_ICON) != 0) {
            switch (value & MASK_ICON) {
            case ICON_EXCLAMATION: icon = new Icon(Icon.EXCLAMATION); break;
            case ICON_QUESTION   : icon = new Icon(Icon.QUESTION   ); break;
            case ICON_INFORMATION: icon = new Icon(Icon.INFORMATION); break;
            case ICON_STOP       : icon = new Icon(Icon.STOP       ); break;
            default: // AVOID
            }
            addToPanel(icon, gbl, 0, 0, 1, 1, 0, 1, GridBagConstraints.VERTICAL, GridBagConstraints.CENTER, new Insets(MARGIN, MARGIN, MARGIN, MARGIN));
        } else {
            icon = null;
        }

        pack();
    }

    /**
     * եȤꤷޤ
     *
     * @param  font ե
     */
    public void setFont(Font font) {
        super.setFont(font);
        message.setFont(font);
    }
}
