/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

/**
 * AWT 桼ƥƥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public final class LayoutUtils {
    /** ߡ */
    private LayoutUtils() {
    }

    /**
     * ƥʤ˥ݡͥȤꤷɲäޤ
     * Υ᥽åɤϡ{@link GridBagLayout} Ѥݤδʰץ᥽åɤǤ
     * äơ {@link GridBagLayout} ΤΤǡ
     * ˥ƥʤΥ쥤ȥޥ͡ {@link GridBagLayout}
     * ꤷƤɬפޤ
     *
     * @param  container ƥ
     * @param  comp      ɲä륳ݡͥ
     * @param  gbl       쥤ȥޥ͡
     * @param  x         {@link GridBagConstraints#gridx     }
     * @param  y         {@link GridBagConstraints#gridy     }
     * @param  width     {@link GridBagConstraints#gridwidth }
     * @param  height    {@link GridBagConstraints#gridheight}
     * @param  weightx   {@link GridBagConstraints#weightx   }
     * @param  weighty   {@link GridBagConstraints#weighty   }
     * @param  fill      {@link GridBagConstraints#fill      }
     * @param  anchor    {@link GridBagConstraints#anchor    }
     * @param  insets    {@link GridBagConstraints#insets    }
     */
    public static void addGridBag(Container container, Component comp,
                                  GridBagLayout gbl,
                                  int x, int y, int width, int height,
                                  double weightx, double weighty,
                                  int fill, int anchor, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx      = x;
        gbc.gridy      = y;
        gbc.gridwidth  = width;
        gbc.gridheight = height;
        gbc.weightx    = weightx;
        gbc.weighty    = weighty;
        gbc.fill       = fill;
        gbc.anchor     = anchor;
        gbc.insets     = insets;

        gbl.setConstraints(comp, gbc);
        container.add(comp);
    }

    /**
     * ꤵ줿ݡͥȤΥե졼֤ޤ
     *
     * @param  comp ݡͥ
     *
     * @return ե졼ࡢ
     *         ݡͥȤե졼°Ƥʤ <code>null</code>
     */
    public static Frame getFrame(Component comp) {
        Container parent = comp.getParent();
        if (parent == null) {
            return null;
        }

        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
        }

        return (Frame) parent;
    }
}
