/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;

/**
 * åܥåǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class InputBox extends DialogBox {
    private static final int    MARGIN   = 10;

    /** @serial å */
    private SizedLabel     message;
    /** @serial  */
    private Icon           icon;
    /** @serial  */
    private TextField      text;

    /** @serial ե饰 */
    private boolean  fixedSize;

    /**
     * åܥåɽη̤֤ޤ
     *
     * @param  owner   ʡ
     * @param  message å
     * @param  title   ȥ
     * @param  text    ƥ
     * @param  hidden  Ϥ򱣤 <code>true</code>
     *                 ɽ <code>false</code>
     *
     * @return Ϥ줿͡󥻥뤵줿 <code>null</code>
     */
    public static String show(Frame owner, String message, String title,
                              String text, boolean hidden) {
        InputBox dialog = new InputBox(owner);
        dialog.setMessage(message);
        dialog.setTitle  (title  );
        dialog.setText   (text   );
        dialog.setHidden (hidden );
        dialog.show();

        if (dialog.getResult() != RESULT_OK) {
            return null;
        }

        return dialog.getText();
    }

    /**
     * åܥåɽη̤֤ޤ
     *
     * @param  owner ʡ
     */
    public InputBox(Frame owner) {
        super(owner, BUTTON_OKCANCEL);

        setResizable(false);
        setModal    (true );

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
        mainPanel.setLayout(gbl);

        addToPanel(icon    = new Icon      (Icon.QUESTION), gbl, 0, 0, 1, 2, 0, 1, GridBagConstraints.VERTICAL  , GridBagConstraints.CENTER, insets);
        addToPanel(message = new SizedLabel(             ), gbl, 1, 0, 1, 1, 1, 1, GridBagConstraints.BOTH      , GridBagConstraints.WEST  , insets);
        addToPanel(text    = new TextField (40           ), gbl, 1, 1, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);

        // ꥹʡϿ
        KeyListener keyListener = null;
        addButtonKeyListener(keyListener =
            new KeyAdapter() {
                /** Υ줿Ȥ */
                public void keyPressed(KeyEvent e) {
                    // ƥȥեɾϡǥեư
                    if (e.getSource() instanceof TextField) {
                        return;
                    }

                    // Ctrl-C 򲡤줿
                    if (e.isControlDown() && e.getKeyCode() == KeyEvent.VK_C) {
                        Clipboard       clipboard = getToolkit().getSystemClipboard();
                        StringSelection data      = new StringSelection(message.getText());
                        clipboard.setContents(data, data);
                        e.consume();
                    }
                }
            }
        );
        addKeyListener(keyListener);
        addWindowListener(
            new WindowAdapter() {
                /** ɽ줿Ȥ */
                public void windowOpened(WindowEvent e) {
                    if (fixedSize) {
                        return;
                    }

                    // åι⤵Ĵ٤
                    Dimension preferredSize = message.getPreferredSize();
                    Dimension messageSize   = message.getSize();
                    if (preferredSize.height <= messageSize.height) {
                        return;
                    }

                    fixedSize = true;
                    pack();
                }
            }
        );

        // 礭
        pack();
    }

    /**
     * ꤵƤå֤ޤ
     *
     * @return å
     */
    public String getMessage() {
        return message.getText();
    }

    /**
     * åꤷޤ
     *
     * @param  value å
     */
    public void setMessage(String value) {
        message.setText(value);

        pack();
    }

    /**
     * ʸ֤ޤ
     *
     * @return ʸ
     */
    public String getText() {
        return text.getText();
    }

    /**
     * ϤɽƤʸꤷޤ
     *
     * @param  value ϤɽƤʸ
     */
    public void setText(String value) {
        text.setText(value);
    }

    /**
     * ϤƤ뤫ɤ֤ޤ
     *
     * @return ϤƤ <code>true</code>
     *         ɽƤ <code>false</code>
     */
    public boolean isHidden() {
        return text.echoCharIsSet();
    }

    /**
     * Ϥ򱣤ɤꤷޤ
     *
     * @param  b Ϥ򱣤 <code>true</code>
     *           ɽ <code>false</code>
     */
    public void setHidden(boolean b) {
        text.setEchoChar((b ? '*' : 0));
    }

    /**
     * եȤꤷޤ
     *
     * @param  font ե
     */
    public void setFont(Font font) {
        super.setFont(font);
        message.setFont(font);
    }
}
