/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;

/**
 * ݡͥˤΤɽġåפ󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public abstract class InnerToolTip {
    private static final int INNER_MARGIN = 3;
    private static final int OUTER_MARGIN = 3;

    private static int threadCount = 0;

    private ImageCreator  creator   = null;
    private volatile long delay     = 0;
    private volatile long term      = 0;
    private Insets        fix       = null;
    private Color         colorFore = null;
    private Color         colorBack = null;
    private Color         colorEdge = null;
    private Tip           paintTip;
    private ToolTipThread timer;


    /**
     * 󥹥󥹤ޤ
     *
     * @param  creator ᡼ꥨ
     * @param  delay ٱʥߥá
     * @param  term  ɽ֡ʥߥá
     * @param  fix ̤ͤФ˽
     */
    public InnerToolTip(ImageCreator creator, long delay, long term, Insets fix) {
        if (fix == null) {
            fix = new Insets(0, 0, 0, 0);
        }

        this.creator   = creator;
        this.delay     = delay;
        this.term      = term;
        this.fix       = fix;
        this.timer     = new ToolTipThread("Kankana-InnerToolTip-" + (++threadCount));
        this.timer.start();

        setForeground(SystemColor.infoText    );
        setBackground(SystemColor.info        );
        setEdgeColor (SystemColor.windowBorder);
    }

    /**
     * ɽåꤷޤ
     *
     * @param  value ɽå
     * @param  x X
     * @param  y Y
     * @param  width  ɽ
     * @param  height ɽι⤵
     * @param  font   ե
     */
    public synchronized void showTip(String value,
                                     int x, int y, int width, int height,
                                     Font font) {
        timer.reset(new Tip(value, x, y, width, height, font));
    }

    /**
     * ɽåäޤ
     */
    public void cancel() {
        timer.cancel();
    }

    /**
     * ʿ֤ޤ
     *
     * @return ʿ
     */
    public Color getForeground() {
        return colorFore;
    }

    /**
     * ʿꤷޤ
     *
     * @param  c ʿ
     */
    public void setForeground(Color c) {
        colorFore = c;
    }

    /**
     * طʿ֤ޤ
     *
     * @return طʿ
     */
    public Color getBackground() {
        return colorBack;
    }

    /**
     * طʿꤷޤ
     *
     * @param  c طʿ
     */
    public void setBackground(Color c) {
        colorBack = c;
    }

    /**
     * ο֤ޤ
     *
     * @return ο
     */
    public Color getEdgeColor() {
        return colorEdge;
    }

    /**
     * οꤷޤ
     *
     * @param  c ο
     */
    public void setEdgeColor(Color c) {
        colorEdge = c;
    }

    /**
     * ɽٱ֤ޤ
     *
     * @return ٱʥߥá
     */
    public long getDelay() {
        return delay;
    }

    /**
     * ɽٱ֤ߥäǻꤷޤ
     *
     * @param  delay ٱʥߥá
     */
    public void setDelay(long delay) {
        this.delay = delay;
    }

    /**
     * ɽ֤ޤ
     *
     * @return ɽ֡ʥߥá
     */
    public long getTerm() {
        return term;
    }

    /**
     * ɽ֤ߥäǻꤷޤ
     *
     * @param  term ɽ֡ʥߥá
     */
    public void setTerm(long term) {
        this.term = term;
    }

    /**
     * åɽ뤿 {@link java.awt.Component#paint(Graphics)} ƤӽФޤ
     *
     * @param  g եå
     */
    public void paint(Graphics g) {
        Tip tip = this.paintTip;
        if (tip != null) {
            tip.paint(g);
        }
    }

    /**
     * ݡͥȤ˴ޤ
     */
    public void dispose() {
        timer.interrupt();
    }

    /**
     * Υ᥽åɤƤӽФ줿硢¹Ԥɬפޤ
     *
     * @param  x X
     * @param  y Y
     * @param  width  
     * @param  height ⤵
     */
    public abstract void repaint(int x, int y, int width, int height);

//### ToolTipThread
    /** ɽԤΥå */
    private final class ToolTipThread extends Thread {
        private Tip tip;

        /** 󥹥󥹤 */
        private ToolTipThread(String name) {
            super(name);
        }

        /** ¹Ԥ */
        public void run() {
            try {
                synchronized (this) {
                    Tip tip;

                    for (;;) {
                        // ɽΤ̵Ԥ
                        wait();

                        while ((tip = this.tip) != null) {
                            // ɽޤǰԤ
                            wait(delay);
                            if (tip != this.tip) {
                                continue;
                            }

                            tip.initialize();

                            // 
                            paintTip = tip;
                            repaint(tip.x, tip.y, tip.width, tip.height);

                            // ɽ
                            wait(term);

                            // õ
                            this.tip = null;
                            paintTip = null;
                            repaint(tip.x, tip.y, tip.width, tip.height);
                        }
                    }
                }
            } catch (InterruptedException e) {
            }
        }

        /**  */
        private synchronized void reset(Tip tip) {
            this.tip = tip;
            notify();
        }

        /** λ */
        private synchronized void cancel() {
            this.tip = null;
            paintTip = null;
            notify();
        }
    }

//### Tip
    /**  */
    private final class Tip implements Cloneable {
        private String   value;
        private Font     font;
        private char[]   chars;
        private FontData fontData;

        private int baseX;
        private int baseY;
        private int baseWidth;
        private int baseHeight;

        private int x;
        private int y;
        private int width;
        private int height;

        /** 󥹥󥹤 */
        private Tip(String value, int x, int y, int width, int height, Font font) {
            this.value      = value;
            this.font       = font;
            this.baseX      = x;
            this.baseY      = y;
            this.baseWidth  = width;
            this.baseHeight = height;
        }

        /** ͤ */
        private void initialize() {
            if (fontData != null) {
                return;
            }

            this.chars    = value.toCharArray();
            this.fontData = FontData.getInstance(creator, font);

            FontMetrics fm = fontData.getFontMetrics();

            int x      = baseX;
            int y      = baseY;
            int width  = fm.stringWidth(value)
                       + INNER_MARGIN * 2 + 2;
            int height = Math.max(fontData.getFullSize().height,
                                  fontData.getHalfHeight())
                       + INNER_MARGIN * 2 + 2;

            if (baseWidth  < x + width  + OUTER_MARGIN) {
                x = baseWidth  - width  - OUTER_MARGIN;
            }
            if (x < OUTER_MARGIN) {
                x = OUTER_MARGIN;
            }
            if (baseHeight < y + height + OUTER_MARGIN) {
                y = baseHeight - height - OUTER_MARGIN;
            }
            if (y < OUTER_MARGIN) {
                y = OUTER_MARGIN;
            }

            this.x      = x;
            this.y      = y;
            this.width  = width;
            this.height = height;
        }

        /**  */
        private void paint(Graphics g) {
            int x = this.x;
            int y = this.y;

            g.setColor(colorBack);
            g.fillRect(x + 1, y + 1, width - 2, height - 2);
            g.setColor(colorEdge);
            g.drawRect(x, y, width - 1, height - 1);

            g.setColor(colorFore);
            g.setFont (fontData.getFont());

            FontMetrics fm       = fontData.getFontMetrics();
            int         baseFull = fontData.getFullBase();
            int         baseHalf = fontData.getHalfBase();

            x += INNER_MARGIN + 1;
            y += INNER_MARGIN + 1;

            char c;
            for (int i = 0; i < chars.length; i++) {
                c = chars[i];
                g.drawChars(chars,
                            i,
                            1,
                            x,
                            y + ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F)
                                 ? baseHalf
                                 : baseFull));
                x += fm.charWidth(c);
            }
        }
    }
}
