/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.awt.image.ImageContainer;
import net.hizlab.kagetaka.awt.image.OffscreenImage;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;

/**
 * ᡼դΥɽ饹Ǥ
 * ΥܥϡˤꣴĤΥ᡼̾С̵ˤѤޤ
 * ΤᡢĤξ֤٤ƤΥ᡼ꤹˡȡ
 * Ĥξ֡̾ˤΥ᡼뤤ϲлΥ᡼ꤷ
 * 줫ꤵƤʤ¾ξ֤ <code>ImageButton</code> 
 * Фˡޤ
 * <p>
 * ޤ<code>setHotspot</code> ᥽åɤǡ
 * ֥˥塼ѤΥ᡼ɲä뤳Ȥޤ
 * <p>
 * Ĥξ֤٤ƤΥ᡼ꤷƤ硢
 * <code>setHotspot</code> ᥽åɤǤϡĤΥѥϿ
 * ɬפޤΥ᥽åɤϿĤΰΰ
 * ޥưȡ֥˥塼ѤưԤޤ
 * Ĥξ֤Υ᡼Ƥ硢<code>setHotspot</code> ᥽åɤϡ
 * ĤΰΥѥϿɬפޤξ硢ۥåȥݥåѤ
 * ᡼ϡ̾Υ᡼α¦ɲäޤ
 * <p>
 * Ĥξ֤Υ᡼Ƥ硢᡼Ȱɽʸ
 * Ǥޤξ硢᡼α¦ǥۥåȥݥåȤ꺸¦
 * ʸɽޤ
 *
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class ImageLabel extends Component {
    private static final int SPACE = 2;

    /** @serial ե꡼ */
    private OffscreenImage    offscreenImage;
    /** @serial 侩 */
    private Dimension         preferredSize;
    /** @serial ե꡼󥤥᡼ */
    private OffscreenObserver offscreenObserver;

    /** @serial ̾᡼ */
    private ImageContainer imageContainer;

    /**
     * ꤵ줿᡼̵󥹥󥹤ޤ
     */
    public ImageLabel() {
        this(null);
    }

    /**
     * ꤵ줿᡼򸵤ˡ󥹥󥹤ޤ
     *
     * @param  image ᡼
     */
    public ImageLabel(Image image) {
        setImage(image);
    }

    /**
     * 侩֤ޤ
     *
     * @return 侩
     */
    public Dimension getPreferredSize() {
        Dimension preferredSize = this.preferredSize;
        if (preferredSize != null && isValid()) {
            return preferredSize;
        }

        synchronized (getTreeLock()) {
            ImageContainer ic = imageContainer;
            this.preferredSize = new Dimension(
                (ic != null ? ic.width  : 0) + SPACE * 2,
                (ic != null ? ic.height : 0) + SPACE * 2
            );
            return this.preferredSize;
        }
    }

    /**
     * Ǿ֤ޤ
     *
     * @return Ǿ
     */
    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    /**
     * ݡͥȤ̵ˤޤ
     */
    public void invalidate() {
        preferredSize = null;
        super.invalidate();
    }

    /**
     * ᡼֤ޤ
     *
     * @return ᡼
     */
    public Image getImage() {
        ImageContainer ic = imageContainer;
        return (ic != null ? ic.image : null);
    }

    /**
     * ᡼ꤷޤ
     *
     * @param  image ᡼
     */
    public void setImage(Image image) {
        ImageContainer oldIc = imageContainer;
        ImageContainer newIc = ImageContainer.setupImageContainer(oldIc, image);
        if (oldIc != newIc) {
            imageContainer = newIc;
            if (oldIc == null || !oldIc.equalsSize(newIc)) {
                invalidate();
            }

            repaintForce();
        }
    }

    /**
     * ̤򥢥åץǡȤޤ
     *
     * @param  g եå
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ᡼ºݤ褷ޤ
     *
     * @param  g եå
     */
    public void paint(Graphics g) {
        offscreenImage.paint(g);
    }

    /**
     *  ݡͥȤƥʤɲä줿Ȥ򡢤ΥݡͥȤΤ
     *  ԥɬפǤСʤФʤޤ
     */
    public void addNotify() {
        synchronized (getTreeLock()) {
            super.addNotify();

            // ե꡼
            offscreenImage = new OffscreenImage(this) {
                public void update(Image offscreen, Graphics g, Dimension size) {
                    refresh(offscreen, g, size);
                }
            };
        }
    }

    /**
     * ݡͥȤƥʤ줿Ȥ򤽤ΥݡͥȤΤ
     * ԥ¸ߤ˲ޤ
     */
    public void removeNotify() {
        synchronized (getTreeLock()) {
            super.removeNotify();

            // ե꡼
            if (offscreenImage != null) {
                releaseObserver();
                offscreenImage.dispose();
                offscreenImage = null;
            }
        }
    }

    /** ߤΥơˤä֤˺ */
    private void refresh(Image offscreen, Graphics g, Dimension size) {
        releaseObserver();

        g.setColor(getBackground());
        g.fillRect(0, 0, size.width, size.height);

        // Ȥ
        g.setColor(SystemColor.controlShadow);
        g.drawLine(0, 0, size.width - 1,  0);
        g.drawLine(0, 0, 0, size.height - 1);
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(1, 1, size.width - 2,  1);
        g.drawLine(1, 1, 1, size.height - 2);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(size.width - 2,  2, size.width - 2, size.height - 2);
        g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(size.width - 1,  1, size.width - 1, size.height - 1);
        g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);

        // 
        if (imageContainer != null) {
            int x = (size.width  - imageContainer.width ) / 2 + SPACE;
            int y = (size.height - imageContainer.height) / 2 + SPACE;
            offscreenObserver = new OffscreenObserver(this, offscreen, x, y);
            g.drawImage(imageContainer.image, x, y, offscreenObserver);
            g.drawImage(imageContainer.image, x, y, this);
        }
    }

    /** ֥Фγ */
    private void releaseObserver() {
        if (offscreenObserver != null) {
            offscreenObserver.dispose();
            offscreenObserver = null;
        }
    }

    /** Ū˺ɽ */
    private void repaintForce() {
        OffscreenImage oi = offscreenImage;
        if (oi != null) {
            oi.repaint();
        }
    }
}
