/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;

/**
 * եȾݻ륯饹Ǥ
 * եȾϡ{@link java.awt.FontMetrics} ǤϤʤ
 * ºݤΥեȤ褷Ƥߤ̤顢礭Ĵ٤ޤ
 * Τᡢեˤ¦;̵뤹褦ˤʤ뤿ᡢ
 * ºݤ褵եȤθܤΥ˶ᤤͤ
 * 뤳Ȥޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public final class FontData {
    private static final char[] SAMPLE_JP = {'\u8A9E' /*  */,
                                             '\u99C5' /*  */,
                                             '\u253C' /*  */,
                                             '\u254B' /*  */};         // ä˰̣Ϥʤ
    private static final char[] SAMPLE_EN = {'A' , 'B' , 'C' , 'D' ,
                                             'j' , 'y' , 'p' , '_' };         // ä˰̣Ϥʤ
    private static final char[] SAMPLE_SY = {'\u3041', '\u3043', '\u3045', '\u3047', '\u3049', // 
                                             '\u3063', '\u3083', '\u3085', '\u3087', '\u308E', // ä
                                             '\u30A1', '\u30A3', '\u30A5', '\u30A7', '\u30A9', // 
                                             '\u30C3', '\u30E3', '\u30E5', '\u30E7', '\u30EE', // å
                                             '\u30F5', '\u30F6'};  // 
    private static final char[] SAMPLE_X  = {'x'};
    private static final Color BACK_COLOR = Color.white;
    private static final Color FORE_COLOR = Color.black;
    private static Hashtable cache = new Hashtable();

    /**
     * եȾޤ
     *
     * @param  creator ᡼ꥨ
     * @param  font    ե
     *
     * @return եȾ
     *
     * @throws IllegalStateException AWT ޤǤƤʤˡ
     *                               եȾ󤬼Ǥʤ
     */
    public static FontData getInstance(ImageCreator creator, Font font) {
        String fontName = font.toString();

        synchronized (cache) {
            if (cache.containsKey(fontName)) {
                return (FontData) cache.get(fontName);
            }

            FontData fd = new FontData(creator, font);
            cache.put(fontName, fd);

            return fd;
        }
    }

    /**
     * եȾޤ
     *
     * @param  component ᡼ꥨεǽ󶡤륳ݡͥ
     * @param  font      ե
     *
     * @return եȾ
     *
     * @throws IllegalStateException AWT ޤǤƤʤˡ
     *                               եȾ󤬼Ǥʤ
     */
    public static FontData getInstance(Component component, Font font) {
        return getInstance(new ImageCreatorComponent(component), font);
    }

    /** ե */
    private Font        font = null;
    /** եȥޥ͡ */
    private FontMetrics fm   = null;
    /** ʸΥ١֡ʾ夫εΥ */
    private int         baseFull = 0;
    /** Ѥξʸ¥ٹˤΥ١֡ʾ夫εΥ */
    private int         baseMini = 0;
    /** ȾѱѿʸΥ١֡ʾ夫εΥ */
    private int         baseHalf = 0;
    /** Ѥξʸ¥ٹˤκΰ */
    private int         leftMini = 0;
    /** ѥեȤ礭 */
    private Dimension   sizeFull = null;
    /** եȤκ */
    private int         heightMax  = 0;
    /** ȾѥեȤι⤵ */
    private int         heightHalf = 0;
    /** ʸ x ι⤵ */
    private int         heightX    = -1;

    /** 󥹥󥹤 */
    private FontData(ImageCreator creator, Font font) {
        this.font = font;
        this.fm   = creator.getToolkit().getFontMetrics(font);

        Dimension size = new Dimension(0, 0);

        // 
        sizeFull   = new Dimension(0, 0);
        baseFull   = calculate(creator, SAMPLE_JP, true , sizeFull);

        // Ⱦ
        baseHalf   = calculate(creator, SAMPLE_EN, false, size);
        heightHalf = size.height;

        // ¥ٹ
        baseMini   = calculate(creator, SAMPLE_SY, true , size);
        leftMini   = Math.max(sizeFull.width - size.width, 0);

        // x
        calculate(creator, SAMPLE_X, false, size);
        heightX = size.height;

        // 硢Ĵ
        if (sizeFull.height > heightHalf) {
            baseHalf   += sizeFull.height - heightHalf;
            heightHalf =  sizeFull.height;
            heightMax  =  sizeFull.height;
        } else {
            heightMax = heightHalf;
        }
    }

    /**  */
    private int calculate(ImageCreator creator, char[] sample, boolean calcWidth, Dimension size) {
        int rect = fm.getHeight();
        if (rect <= 0) {
            return 0;
        }

        Image image = creator.createImage(rect, rect);
        if (image == null) {
            throw new IllegalStateException("doesn't prepare for AWT");
        }

        int desc = fm.getDescent();
        int base = rect - desc;

        Graphics g = image.getGraphics();
        try {
            g.setColor(BACK_COLOR);
            g.fillRect(0, 0, rect, rect);
            g.setColor(FORE_COLOR);
            g.setFont (font      );

            for (int i = 0; i < sample.length; i++) {
                g.drawChars(sample, i, 1, 0, base);
            }
        } finally {
            g.dispose();
        }

        int[] bitmap = new int[rect * rect];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, rect, rect, bitmap, 0, rect);
        try {
            // ѴǼԤƤ⡢̵뤷Ʒ³ƹʤ
            pg.grabPixels(10000);
        } catch (InterruptedException e) { }

        int fcc    = FORE_COLOR.getRGB();
        int magic1 = 0, magic2 = 0;
        for (int i = 0; i < bitmap.length; i++) {
            if (bitmap[i] == fcc) {
                magic1 = i / rect;
                break;
            }
        }
        for (int i = bitmap.length - 1; i >= 0; i--) {
            if (bitmap[i] == fcc) {
                magic2 = (rect - i / rect) - 1;
                break;
            }
        }
        size.height = rect - magic1 - magic2;

        // ⸡
        if (calcWidth) {
            int magic3 = rect;
            int j;
            ALL:
            for (int i = rect - 1; i >= 0; i--) {
                for (j = 0; j < rect; j++) {
                    if (bitmap[j * rect + i] == fcc) {
                        magic3 = i + 1;
                        break ALL;
                    }
                }
            }
            size.width = magic3;
        }

        return rect - desc - magic1;
    }

    /**
     * եȤ֤ޤ
     *
     * @return ե
     */
    public Font getFont() {
        return font;
    }

    /**
     * եȥȥå֤ޤ
     *
     * @return եȥȥå
     */
    public FontMetrics getFontMetrics() {
        return fm;
    }

    /**
     * ܸʸΥ֤ޤ
     * Υˤϡ岼;ޤߤޤ
     *
     * @return ܸʸΥ
     */
    public Dimension getFullSize() {
        return new Dimension(sizeFull);
    }

    /**
     * ΥեȤκ֤ޤ
     * Υˤϡ岼;ޤߤޤ
     *
     * @return եȤκ
     */
    public int getMaxHeight() {
        return heightMax;
    }

    /**
     * ȾѱѿʸΥ֤ޤ
     * Υˤϡ岼;ޤߤޤ
     *
     * @return ѳױѿʸι⤵
     */
    public int getHalfHeight() {
        return heightHalf;
    }

    /**
     * ʸ <code>x</code> ι⤵֤ޤ
     *
     * @return <code>x ι⤵
     */
    public int getXHeight() {
        return heightX;
    }

    /**
     * ܸʸΥ١饤ΰ֤򡢥եȤξεΥ֤ޤ
     *
     * @return ١饤ΰ
     */
    public int getFullBase() {
        return baseFull;
    }

    /**
     * ȾѱѿʸΥ١饤ΰ֤򡢥եȤξεΥ֤ޤ
     *
     * @return ١饤ΰ
     */
    public int getHalfBase() {
        return baseHalf;
    }

    /**
     * ¥ٹʸΥ١饤ΰ֤򡢥եȤξεΥ֤ޤ
     *
     * @return ١饤ΰ
     */
    public int getMiniBase() {
        return baseMini;
    }

    /**
     * ¥ٹʸκ¦ΰ֤򡢥եȤκεΥ֤ޤ
     *
     * @return ١饤ΰ
     */
    public int getMiniLeft() {
        return leftMini;
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getClass().getName());
        sb.append('[');
        sb.append("font=");

        int code = font.getStyle();
        sb.append(font.getName());
        if ((code & Font.BOLD) != 0 && (code & Font.ITALIC) != 0) {
            sb.append("-bolditalic-");
        } else if ((code & Font.BOLD) != 0) {
            sb.append("-bold-");
        } else if ((code & Font.ITALIC) != 0) {
            sb.append("-italic-");
        } else {
            sb.append("-plain-");
        }
        sb.append(font.getSize());

        sb.append(",fullheight=");
        sb.append(sizeFull.height);
        sb.append(",fullwidth=");
        sb.append(sizeFull.width);
        sb.append(",maxheight=");
        sb.append(heightMax);
        sb.append(",halfheight=");
        sb.append(heightHalf);
        sb.append(",xheight=");
        sb.append(heightX);
        sb.append(",basefull=");
        sb.append(baseFull);
        sb.append(",basehalf=");
        sb.append(baseHalf);
        sb.append(']');
        return sb.toString();
    }

    /**
     * ݡͥȤ顢᡼뵡ǽ󶡤뤿Υ饹Ǥ
     */
    private static final class ImageCreatorComponent implements ImageCreator {
        private Component component;

        /**
         * 󥹥󥹤ޤ
         *
         * @param  c ݡͥ
         */
        public ImageCreatorComponent(Component c) {
            this.component = c;
        }

        /** {@inheritDoc} */
        public Toolkit getToolkit() {
            return component.getToolkit();
        }

        /** {@inheritDoc} */
        public Image createImage(int width, int height) {
            return component.createImage(width, height);
        }
    }
}
