/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.addin.java2.IOWrapper;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ǥ쥯ȥ򤹤ܥå󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class DirectoryDialog extends DialogBox {
    private static final int MARGIN = 3;

    /** @serial å */
    private Label message;
    /** @serial ĥ꡼ */
    private Tree  tree;
    /** @serial 롼ȥƥ */
    private Item  root;

    /**
     * åܥåɽη̤֤ޤ
     *
     * @param  owner ʡ
     * @param  title ȥ
     * @param  message å
     * @param  path    ѥ
     *
     * @return Ϥ줿͡󥻥뤵줿 <code>null</code>
     */
    public static String show(Frame owner, String title, String message, String path) {
        DirectoryDialog dialog = new DirectoryDialog(owner, title, message);
        dialog.setPath(path);
        dialog.show();

        if (dialog.getResult() != RESULT_OK) {
            return null;
        }

        return dialog.getPath();
    }

    /**
     * ǥ쥯ȥܥåޤ
     *
     * @param  parent  
     */
    public DirectoryDialog(Frame parent) {
        this(parent, null, null);
    }

    /**
     * ꤵ줿ȥȥåɽ롢
     * ǥ쥯ȥܥåޤ
     *
     * @param  parent  
     * @param  title   ȥ
     * @param  message å
     */
    public DirectoryDialog(Frame parent, String title, String message) {
        super(parent, BUTTON_OKCANCEL | ALIGN_RIGHT);
        setTitle    (title);
        setResizable(false);
        setModal    (true );

        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(0, 0, 0, 0);
        mainPanel.setLayout(gbl);

        addToPanel(this.message = new Label(message), gbl, 0, 0, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST, insets);
        insets.top = MARGIN;
        addToPanel(this.tree    = new Tree (10, 35 ), gbl, 0, 1, 1, 1, 1, 1, GridBagConstraints.BOTH      , GridBagConstraints.WEST, insets);

        tree.setRootTreeItem(root = new Item(null, false));
        tree.setBackground(SystemColor.window);

        // 礭
        pack();
    }

    /**
     * åޤ
     *
     * @return å
     */
    public String getMessage() {
        return message.getText();
    }

    /**
     * åꤷޤ
     *
     * @param  message å
     */
    public void setMessage(String message) {
        this.message.setText(message);
    }

    /**
     * ѥޤ
     *
     * @return ѥ򤵤Ƥʤ <code>null</code>
     */
    public String getPath() {
        Item item = (Item) tree.getSelectedTreeItem();
        if (item != null) {
            return item.path.getPath();
        }

        return null;
    }

    /**
     * ѥꤷޤ
     *
     * @param  path ѥ
     */
    public void setPath(String path) {
        if (path == null) {
            tree.selecteIndex(-1);
            return;
        }

        try {
            path = (new File(path)).getCanonicalPath();
        } catch (IOException e) { }
        if (path.length() == 0) {
            return;
        }

        StringTokenizer st = new StringTokenizer(path, File.separator);
        Vector list = new Vector();
        Item   item = root;

        // Unix ʤɤ / θ
        if (path.charAt(0) == File.separatorChar) {
            item = (Item) item.getTreeItems().elementAt(0);
            list.addElement(new Integer(0));
        }

        Item in;
        String s;
        Vector v;
        int i;
        CHECK:
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            v = item.getTreeItems();
            for (i = v.size() - 1; i >= 0; i--) {
                in = (Item) v.elementAt(i);
                if (s.compareTo(in.getTreeLabel()) == 0) {
                    list.addElement(new Integer(i));
                    item = in;
                    continue CHECK;
                }
            }
            break;
        }

        if (list.size() > 0) {
            int[] indices = new int[list.size()];
            for (i = 0; i < indices.length; i++) {
                indices[i] = ((Integer) list.elementAt(i)).intValue();
            }
            tree.selectTreeItem(indices);
        }
    }

//### Item
    /** ǥ쥯ȥꥢƥ */
    private final class Item implements TreeItem {
        private File    path;
        private boolean root;
        private Vector  items;

        /** 󥹥󥹤 */
        private Item(File path, boolean root) {
            this.path = path;
            this.root = root;
        }

        /** ĥ꡼ɽ륢֤ */
        public Image getTreeIcon(boolean opened) {
            //### TODO ֤Ƥߤ
            return null;
        }

        /** ĥ꡼ɽ٥֤ */
        public String getTreeLabel() {
            if (root) {
                return (Environment.isWindows)
                       ? path.getPath().substring(0, 2)
                       : path.getPath();
            }

            if (path != null) {
                return path.getName();
            }

            return "root";
        }

        /** ҤΥƥ֤ */
        public Vector getTreeItems() {
            if (items != null) {
                return items;
            }

            items = new Vector();
            if (path != null) {
                // ߤΥǥ쥯ȥΥ֥ǥ쥯ȥ
                String[] lists = path.list();
                if (lists != null) {
                    File file;
                    int length = lists.length;
                    for (int i = 0; i < length; i++) {
                        if ((file = new File(path, lists[i])).isDirectory()) {
                            items.addElement(new Item(file, false));
                        }
                    }
                }
            } else {
                // 롼ȥեΰ
                IOWrapper wrapper = IOWrapper.getInstance();
                if (wrapper != null) {
                    File[] lists = wrapper.listRoots();
                    if (lists != null) {
                        for (int i = 0; i < lists.length; i++) {
                            items.addElement(new Item(lists[i], true));
                        }
                    }
                } else {
                    if (Environment.isWindows) {
                        File file;
                        for (char c = 'A'; c <= 'Z'; c++) {
                            if ((file = new File(c + ":\\")).exists()) {
                                items.addElement(new Item(file, true));
                            }
                        }
                    } else {
                        items.addElement(new Item(new File("/"), true));
                    }
                }
            }

            return items;
        }
    }
}
