/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.Resource;

import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * ɸŪʥܥåǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public abstract class DialogBox extends Dialog {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resources";
    private static final int    MARGIN        = 10;
    private static final int    BUTTON_LENGTH = 90;
    private static final int    BUTTON_HEIGHT =  8;

    /** OK ܥ */
    protected static final int BUTTON_OK            = 0x0000;
    /** OK ȥ󥻥ܥ */
    protected static final int BUTTON_OKCANCEL      = 0x0001;
    /** OK ȥ󥻥Ŭѥܥ */
    protected static final int BUTTON_OKCANCELAPPLY = 0x0002;
    /** YES  NO ܥ */
    protected static final int BUTTON_YESNO         = 0x0003;
    /** YES  NO ȥ󥻥ܥ */
    protected static final int BUTTON_YESNOCANCEL   = 0x0004;
    /** 󥻥ܥ */
    protected static final int BUTTON_CANCEL        = 0x0005;
    /** Ĥܥ */
    protected static final int BUTTON_CLOSE         = 0x0006;

    /** ܥǥեȤ */
    protected static final int DEFAULT_BUTTON1      = 0x0000;
    /** ܥǥեȤ */
    protected static final int DEFAULT_BUTTON2      = 0x0010;
    /** 軰ܥǥեȤ */
    protected static final int DEFAULT_BUTTON3      = 0x0020;
    /** ͥܥǥեȤ */
    protected static final int DEFAULT_BUTTON4      = 0x0030;

    /** ܥ */
    protected static final int ALIGN_CENTER         = 0x0000;
    /** ܥ򱦤 */
    protected static final int ALIGN_RIGHT          = 0x0100;
    /** ܥ򺸤 */
    protected static final int ALIGN_LEFT           = 0x0200;

    /** إץܥɲ */
    protected static final int OPTION_HELPBUTTON    = 0x1000;

    /** ѥܥѥޥ */
    protected static final int MASK_BUTTON  = 0x000F;
    /** ǥեȥܥѥޥ */
    protected static final int MASK_DEFAULT = 0x00F0;
    /** ·ޥ */
    protected static final int MASK_ALIGN   = 0x0F00;

    /** ܥϲƤʤ */
    public static final int RESULT_NONE   = -1;
    /** OK ܥ򲡤줿 */
    public static final int RESULT_OK     =  0;
    /** 󥻥ܥ򲡤줿 */
    public static final int RESULT_CANCEL =  1;
    /** YES ܥ󤬲줿 */
    public static final int RESULT_YES    =  2;
    /** NO ܥ󤬲줿 */
    public static final int RESULT_NO     =  3;
    /** Ĥ ܥ󤬲줿 */
    public static final int RESULT_CLOSE  =  4;

    /** OK ܥΥޥ */
    public static final String COMMAND_OK     =  "ok"    ;
    /** YES ܥΥޥ */
    public static final String COMMAND_YES    =  "yes"   ;
    /** NO ܥΥޥ */
    public static final String COMMAND_NO     =  "no"    ;
    /** 󥻥 ܥΥޥ */
    public static final String COMMAND_CANCEL =  "cancel";
    /** Ŭ ܥΥޥ */
    public static final String COMMAND_APPLY  =  "apply" ;
    /** Ĥ ܥΥޥ */
    public static final String COMMAND_CLOSE  =  "close" ;
    /** إ ܥΥޥ */
    public static final String COMMAND_HELP   =  "help"  ;

    /**
     * ΥᥤʬΥѥͥǤ
     * ˥ݡͥȤɲäϡ
     * Υѥͥɲäɬפޤ
     *
     * @serial ᥤѥͥ
     */
    protected Container mainPanel;

    /**
     * ΥΥʥե졼Ǥ
     *
     * @serial 
     */
    protected Frame owner;

    /** @serial  */
    private int result = RESULT_NONE;
    /** @serial ɽ⡼ */
    private int mode   = 0;

    /** @serial ѥ쥤 */
    private GridBagLayout  dialogGbl;
    /** @serial ܥѥͥ */
    private Container      buttonPanel;
    /** @serial ܥѥͥѥ쥤 */
    private GridBagLayout  buttonGbl;

    /** @serial ǥեȤΥꥹ */
    private KeyListener    defaultKeyListener;

    /** @serial ܥ */
    private Button[] buttons = new Button[4];
    /** @serial ǥեȥܥ */
    private Button   defaultButton;

    private transient ComponentListener   buttonComponentListener;
    private transient FocusListener       buttonFocusListener;
    private transient KeyListener         buttonKeyListener;
    private transient MouseListener       buttonMouseListener;
    private transient MouseMotionListener buttonMouseMotionListener;
    private transient ActionListener      buttonActionListener;

    /**
     * ꤷɽ⡼ɤ˽ܥåޤ
     *
     * @param  owner ʡ
     * @param  mode  ɽ⡼
     */
    protected DialogBox(Frame owner, int mode) {
        super(owner);
        this.owner = owner;

        dialogGbl   = new GridBagLayout();
        super.setLayout(dialogGbl);
        mainPanel   = new Panel();
        buttonPanel = new Panel(buttonGbl = new GridBagLayout());

        // ᥤѥͥɲ
        initializeMainPanel();

        // ܥ򲡤ȤΥꥹ
        addButtonActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    int r = 0;
                    if (command.compareTo(COMMAND_OK    ) == 0) { r = RESULT_OK    ; } else
                    if (command.compareTo(COMMAND_YES   ) == 0) { r = RESULT_YES   ; } else
                    if (command.compareTo(COMMAND_NO    ) == 0) { r = RESULT_NO    ; } else
                    if (command.compareTo(COMMAND_CANCEL) == 0) { r = RESULT_CANCEL; } else
                    if (command.compareTo(COMMAND_CLOSE ) == 0) { r = RESULT_CLOSE ; } else
                    {
                        return;
                    }

                    if (dialogClosing(r)) {
                        result = r;
                        dispose();
                    }
                }
            }
        );

        // ǥեȤΥԤꥹ
        addButtonKeyListener(defaultKeyListener =
            new KeyAdapter() {
                /** 줿 */
                public void keyPressed(KeyEvent e) {
                    // ESCAPE ǥܥåĤ
                    if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                        dispose();
                        e.consume();
                    }

                    // ENTER ΥǥեȤ OK ܥ
                    if (e.getKeyCode() == KeyEvent.VK_ENTER) {
                        Button target = defaultButton;
                        if (e.getSource() instanceof Button) {
                            target = (Button) e.getSource();
                        }
                        target.dispatchEvent(new ActionEvent(target,
                                                             ActionEvent.ACTION_PERFORMED,
                                                             target.getActionCommand(),
                                                             e.getModifiers()));
                        e.consume();
                    }
                }
            }
        );

        // ꥹʡϿ
        addWindowListener(
            new WindowAdapter() {
                /** ɥĤ褦ȤȤ */
                public void windowClosing(WindowEvent e) {
                    dispose();
                }
            }
        );
        addKeyListener(defaultKeyListener);

        // ǥեͤ
        setMode(mode);
    }

    /** ᥤΥѥͥɲ */
    private void initializeMainPanel() {
//setBackground(java.awt.Color.cyan);
//mainPanel.setBackground(java.awt.Color.red);
//buttonPanel.setBackground(java.awt.Color.blue);

        LayoutUtils.addGridBag(this, mainPanel, dialogGbl, 0, 0, 1, 1, 1, 1,
                               GridBagConstraints.BOTH, GridBagConstraints.CENTER,
                               new Insets(MARGIN, MARGIN, MARGIN / 2, MARGIN));

        mainPanel.addContainerListener(
            new ContainerAdapter() {
                /** ƥʤɲä줿Ȥ */
                public void componentAdded(ContainerEvent e) {
                    initComponent(e.getChild());
                }

                /** ݡͥȤν */
                private void initComponent(Component component) {
                    if (component instanceof Container) {
                        initContainer((Container) component);
                    }

                    addListener(component);
                }

                /** ƥʤν */
                private void initContainer(Container container) {
                    container.addContainerListener(this);

                    Component[] components = container.getComponents();
                    if (components != null) {
                        for (int i = 0; i < components.length; i++) {
                            initComponent(components[i]);
                        }
                    }
                }

                /** ݡͥȤ˥ꥹʤϿ */
                private void addListener(Component component) {
                    // ǥեȤΥꥹʤϿ
                    component.addKeyListener(defaultKeyListener);
                }
            }
        );
    }

    /** ܥΥѥͥɲ */
    private void initializeButtonPanel() {
        if (super.getComponentCount() > 1) {
            super.remove(1);
        }
        buttonPanel.removeAll();

        int anchor = 0;
        switch ((mode & MASK_ALIGN )) {
        case ALIGN_LEFT  : anchor = GridBagConstraints.WEST  ; break;
        case ALIGN_CENTER: anchor = GridBagConstraints.CENTER; break;
        case ALIGN_RIGHT : anchor = GridBagConstraints.EAST  ; break;
        default: // AVOID
        }

        LayoutUtils.addGridBag(this, buttonPanel, dialogGbl, 0, 1, 1, 1, 1, 0,
                               GridBagConstraints.NONE, anchor,
                               new Insets(MARGIN / 2, MARGIN, MARGIN, MARGIN));
    }

    /**
     * ̤򥢥åץǡȤޤ
     *
     * @param  g եå
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ɤΥܥ󤬲줿֤ޤ
     *
     * @return 줿ܥ
     */
    public int getResult() {
        return result;
    }

    /**
     * 줿ܥξ򥯥ꥢޤ
     */
    public void clearResult() {
        result = RESULT_NONE;
    }

    /**
     * ꤵƤ⡼ɤ֤ޤ
     *
     * @return ⡼
     */
    protected int getMode() {
        return mode;
    }

    /**
     * ⡼ɤꤷޤ
     *
     * @param  value ⡼
     */
    protected synchronized void setMode(int value) {
        mode = value;

        // ܥ򤹤٤ƾõ
        for (int i = 0; i < buttons.length; i++) {
            buttons[i] = null;
        }
        defaultButton = null;

        int buttonType  = (mode & MASK_BUTTON);

        initializeButtonPanel();

        // ܥɲ
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill   = GridBagConstraints.BOTH;
        gbc.gridx  = 0;
        gbc.gridy  = 0;
        gbc.insets = new Insets(0, 0, 0, 0);

        // ܥѰ
        if (/*---*/(buttonType == BUTTON_OK           )
                || (buttonType == BUTTON_OKCANCEL     )
                || (buttonType == BUTTON_OKCANCELAPPLY)) {
            createButton(COMMAND_OK    , gbc);
        }
        if (/*---*/(buttonType == BUTTON_YESNO        )
                || (buttonType == BUTTON_YESNOCANCEL  )) {
            createButton(COMMAND_YES   , gbc);
            gbc.insets.left = MARGIN;
            createButton(COMMAND_NO    , gbc);
        }
        if (/*---*/(buttonType == BUTTON_OKCANCEL     )
                || (buttonType == BUTTON_OKCANCELAPPLY)
                || (buttonType == BUTTON_YESNOCANCEL  )
                || (buttonType == BUTTON_CANCEL       )) {
            gbc.insets.left = MARGIN;
            createButton(COMMAND_CANCEL, gbc);
        }
        if ((buttonType == BUTTON_OKCANCELAPPLY)) {
            gbc.insets.left = MARGIN;
            createButton(COMMAND_APPLY , gbc);
        }
        if ((buttonType == BUTTON_CLOSE)) {
            createButton(COMMAND_CLOSE , gbc);
        }
        if ((mode & OPTION_HELPBUTTON) != 0) {
            gbc.insets.left = MARGIN;
            createButton(COMMAND_HELP  , gbc);
        }

        // ǥեȥܥ˽֤Ͽ
        int start = 0;
        switch (mode & MASK_DEFAULT) {
        case DEFAULT_BUTTON2: start = 1; break;
        case DEFAULT_BUTTON3: start = 2; break;
        case DEFAULT_BUTTON4: start = 3; break;
        default: // AVOID
        }
        Button button;
        for (int i = start; i < buttons.length + start; i++) {
            button = buttons[(i >= buttons.length ? i - buttons.length : i)];
            if (button != null) {
                buttonPanel.add(button);
                if (defaultButton == null) {
                    defaultButton = button;
                }
            }
        }
    }

    /**
     * ĤȤ˸ƤӽФޤ
     * ĤȤ˲¹ԤɬפȤϡ
     * Υ᥽åɤ򥪡С饤ɤǤ
     * ǥեȤǤϡ򤻤 <code>true</code> ֤ޤ
     *
     * @param  result 줿ܥ
     *
     * @return ĤƤפʾ <code>true</code>
     *         ʳξ <code>false</code>
     */
    protected boolean dialogClosing(int result) {
        return true;
    }

    /**
     * եȤꤷޤ
     *
     * @param  font ե
     */
    public synchronized void setFont(Font font) {
        super.setFont(font);

        // ٤ƤΥܥΥեȤѹ
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].setFont(font);
            }
        }
    }

    /**
     * 礭򡢿侩ꤷޤ
     */
    public void pack() {
        pack(0, 0);
    }

    /**
     * 礭򡢻ꤵ줿祵Ķʤ侩ꤷޤ
     *
     * @param  width  κ
     *                ̵¤ξ <code>0</code>
     * @param  height κι⤵
     *                ̵¤ξ <code>0</code>
     */
    public void pack(int width, int height) {
        super.pack();

        Dimension screenSize = getToolkit().getScreenSize();
        if (width  <= 0 || width  > screenSize.width ) { width  = screenSize.width;  }
        if (height <= 0 || height > screenSize.height) { height = screenSize.height; }

        Dimension size   = getSize();
        boolean   resize = false;
        if (size.width  > width ) { size.width  = width ; resize = true; }
        if (size.height > height) { size.height = height; resize = true; }
        if (resize) {
            setSize(size.width, size.height);
        }

        setLocationToCenter();
    }

    /**
     * ܥΥ٥ѹޤ
     *
     * @param  index ǽΥܥ <code>0</code> Υǥåֹ
     * @param  label ٥
     */
    public void setButtonLabel(int index, String label) {
        if (buttons[index] == null) {
            new ArrayIndexOutOfBoundsException(index);
        }

        buttons[index].setLabel(label);
    }

    /**
     * ˥ݡͥȤꤷɲäޤ
     * Υ᥽åɤϡ{@link GridBagLayout} Ѥݤδʰץ᥽åɤǤ
     * äơ {@link GridBagLayout} ΤΤǡ
     * ˥쥤ȥޥ͡ {@link GridBagLayout} ꤷƤ
     * ɬפޤ
     *
     * @param  comp    ɲä륳ݡͥ
     * @param  gbl     쥤ȥޥ͡
     * @param  x       {@link GridBagConstraints#gridx     }
     * @param  y       {@link GridBagConstraints#gridy     }
     * @param  width   {@link GridBagConstraints#gridwidth }
     * @param  height  {@link GridBagConstraints#gridheight}
     * @param  weightx {@link GridBagConstraints#weightx   }
     * @param  weighty {@link GridBagConstraints#weighty   }
     * @param  fill    {@link GridBagConstraints#fill      }
     * @param  anchor  {@link GridBagConstraints#anchor    }
     * @param  insets  {@link GridBagConstraints#insets    }
     */
    public void addToPanel(Component comp, GridBagLayout gbl,
                           int x, int y, int width, int height,
                           double weightx, double weighty,
                           int fill, int anchor, Insets insets) {
        LayoutUtils.addGridBag(mainPanel, comp, gbl, x, y, width, height,
                               weightx, weighty, fill, anchor, insets);
    }

    /**
     * ܥФ륳ݡͥȥꥹʤϿޤ
     *
     * @param  l Ͽ륳ݡͥȥꥹ
     */
    public synchronized void addButtonComponentListener(ComponentListener l) {
        buttonComponentListener = AWTEventMulticaster.add(buttonComponentListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].addComponentListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФ륳ݡͥȥꥹʤޤ
     *
     * @param  l 륳ݡͥȥꥹ
     */
    public synchronized void removeButtonComponentListener(ComponentListener l) {
        buttonComponentListener = AWTEventMulticaster.remove(buttonComponentListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].removeComponentListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФեꥹʤϿޤ
     *
     * @param  l Ͽեꥹ
     */
    public synchronized void addButtonFocusListener(FocusListener l) {
        buttonFocusListener = AWTEventMulticaster.add(buttonFocusListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].addFocusListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФեꥹʤޤ
     *
     * @param  l եꥹ
     */
    public synchronized void removeButtonFocusListener(FocusListener l) {
        buttonFocusListener = AWTEventMulticaster.remove(buttonFocusListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].removeFocusListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФ륭ꥹʤϿޤ
     *
     * @param  l Ͽ륭ꥹ
     */
    public synchronized void addButtonKeyListener(KeyListener l) {
        buttonKeyListener = AWTEventMulticaster.add(buttonKeyListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].addKeyListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФ륭ꥹʤޤ
     *
     * @param  l 륭ꥹ
     */
    public synchronized void removeButtonKeyListener(KeyListener l) {
        buttonKeyListener = AWTEventMulticaster.remove(buttonKeyListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].removeKeyListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФޥꥹʤϿޤ
     *
     * @param  l Ͽޥꥹ
     */
    public synchronized void addButtonMouseListener(MouseListener l) {
        buttonMouseListener = AWTEventMulticaster.add(buttonMouseListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].addMouseListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФޥꥹʤޤ
     *
     * @param  l ޥꥹ
     */
    public synchronized void removeButtonMouseListener(MouseListener l) {
        buttonMouseListener = AWTEventMulticaster.remove(buttonMouseListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].removeMouseListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФޥ⡼ꥹʤϿޤ
     *
     * @param  l Ͽޥ⡼ꥹ
     */
    public synchronized void addButtonMouseMotionListener(MouseMotionListener l) {
        buttonMouseMotionListener = AWTEventMulticaster.add(buttonMouseMotionListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].addMouseMotionListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФޥ⡼ꥹʤޤ
     *
     * @param  l ޥ⡼ꥹ
     */
    public synchronized void removeButtonMouseMotionListener(MouseMotionListener l) {
        buttonMouseMotionListener = AWTEventMulticaster.remove(buttonMouseMotionListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].removeMouseMotionListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФ륢ꥹʤϿޤ
     *
     * @param  l Ͽ륢ꥹ
     */
    public synchronized void addButtonActionListener(ActionListener l) {
        buttonActionListener = AWTEventMulticaster.add(buttonActionListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].addActionListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * ܥФ륢ꥹʤޤ
     *
     * @param  l 륢ꥹ
     */
    public synchronized void removeButtonActionListener(ActionListener l) {
        buttonActionListener = AWTEventMulticaster.remove(buttonActionListener, l);
        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] != null) {
                buttons[i].removeActionListener(l);
            } else {
                break;
            }
        }
    }

    /**
     * Υ򡢿ƥɥ˰ưޤ
     */
    protected void setLocationToCenter() {
        // ֤
        Point     ownerLocation = owner.getLocationOnScreen();
        Dimension ownerSize     = owner.getSize            ();
        Dimension size          = getSize();
        setLocation(ownerLocation.x + ((ownerSize.width  - size.width ) / 2),
                    ownerLocation.y + ((ownerSize.height - size.height) / 2));
    }

//### Override
    /**
     * ΥᥤѥͥФ륳ݡͥȥꥹʤϿޤ
     *
     * @param  l Ͽ륳ݡͥȥꥹ
     */
    public synchronized void addComponentListener(ComponentListener l) {
        super      .addComponentListener(l);
        mainPanel  .addComponentListener(l);
        buttonPanel.addComponentListener(l);
    }

    /**
     * Ф륳ݡͥȥꥹʤޤ
     *
     * @param  l 륳ݡͥȥꥹ
     */
    public synchronized void removeComponentListener(ComponentListener l) {
        super      .removeComponentListener(l);
        mainPanel  .removeComponentListener(l);
        buttonPanel.removeComponentListener(l);
    }

    /**
     * ФեꥹʤϿޤ
     *
     * @param  l Ͽեꥹ
     */
    public synchronized void addFocusListener(FocusListener l) {
        super      .addFocusListener(l);
        mainPanel  .addFocusListener(l);
        buttonPanel.addFocusListener(l);
    }

    /**
     * Фեꥹʤޤ
     *
     * @param  l եꥹ
     */
    public synchronized void removeFocusListener(FocusListener l) {
        super      .removeFocusListener(l);
        mainPanel  .removeFocusListener(l);
        buttonPanel.removeFocusListener(l);
    }

    /**
     * Ф륭ꥹʤϿޤ
     *
     * @param  l Ͽ륭ꥹ
     */
    public synchronized void addKeyListener(KeyListener l) {
        super      .addKeyListener(l);
        mainPanel  .addKeyListener(l);
        buttonPanel.addKeyListener(l);
    }

    /**
     * Ф륭ꥹʤޤ
     *
     * @param  l 륭ꥹ
     */
    public synchronized void removeKeyListener(KeyListener l) {
        super      .removeKeyListener(l);
        mainPanel  .removeKeyListener(l);
        buttonPanel.removeKeyListener(l);
    }

    /**
     * ФޥꥹʤϿޤ
     *
     * @param  l Ͽޥꥹ
     */
    public synchronized void addMouseListener(MouseListener l) {
        super      .addMouseListener(l);
        mainPanel  .addMouseListener(l);
        buttonPanel.addMouseListener(l);
    }

    /**
     * Фޥꥹʤޤ
     *
     * @param  l ޥꥹ
     */
    public synchronized void removeMouseListener(MouseListener l) {
        super      .removeMouseListener(l);
        mainPanel  .removeMouseListener(l);
        buttonPanel.removeMouseListener(l);
    }

    /**
     * Фޥ⡼ꥹʤϿޤ
     *
     * @param  l Ͽޥ⡼ꥹ
     */
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super      .addMouseMotionListener(l);
        mainPanel  .addMouseMotionListener(l);
        buttonPanel.addMouseMotionListener(l);
    }

    /**
     * Фޥ⡼ꥹʤޤ
     *
     * @param  l ޥ⡼ꥹ
     */
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super      .removeMouseMotionListener(l);
        mainPanel  .removeMouseMotionListener(l);
        buttonPanel.removeMouseMotionListener(l);
    }

    /**
     * Ф륳ƥʥꥹʤϿޤ
     *
     * @param  l Ͽ륳ƥʥꥹ
     */
    public synchronized void addContainerListener(ContainerListener l) {
        super.addContainerListener(l);
    }

    /**
     * Ф륳ƥʥꥹʤޤ
     *
     * @param  l 륳ƥʥꥹ
     */
    public synchronized void removeContainerListener(ContainerListener l) {
        super.removeContainerListener(l);
    }

//### private
    /**  */
    private void createButton(String command, GridBagConstraints gbc) {
        String label = Resource.getMessage(RESOURCE, "dialogbox.button." + command, null);

        Font        font = getFont();
        FontMetrics fm   = getFontMetrics((font != null ? font : owner.getFont()));
        Button      button = new SizedButton(label, BUTTON_LENGTH);
        // 
        button.setActionCommand(command);

        if (buttonComponentListener   != null) { button.addComponentListener  (buttonComponentListener  ); }
        if (buttonFocusListener       != null) { button.addFocusListener      (buttonFocusListener      ); }
        if (buttonKeyListener         != null) { button.addKeyListener        (buttonKeyListener        ); }
        if (buttonMouseListener       != null) { button.addMouseListener      (buttonMouseListener      ); }
        if (buttonMouseMotionListener != null) { button.addMouseMotionListener(buttonMouseMotionListener); }
        if (buttonActionListener      != null) { button.addActionListener     (buttonActionListener     ); }

        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i] == null) {
                buttons[i] = button;
                break;
            }
        }

        buttonGbl.setConstraints(button, gbc);
        gbc.gridx++;
    }
}
