/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

/**
 * ॳƥʤΤδ쥯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public abstract class CustomContainer extends Container {
    /** @serial ١ƥ */
    private Container baseContainer;
    /** @serial ݡͥ */
    private Vector components = new Vector();
    /** @serial ƥ */
    private Vector containers = new Vector();

    /**
     * ƥʤۤޤ
     */
    public CustomContainer() {
    }

    /**
     * ΥƥʤˡݡͥȤɲä褦Ȥˡ
     * ºݤɲä륳ƥʤꤷޤ
     *
     * @param  c ƥʡ
     *           <code>null</code> ꤹȡΥƥʼȤɲä
     */
    protected void setBaseContainer(Container c) {
        baseContainer = c;
    }

    /**
     * ΥƥʤˡݡͥѥꥹʤϿ줿Ȥ
     * Ͽ륳ݡͥȤɲäޤ
     *
     * @param  c ݡͥ
     */
    protected void addListenerComponent(Component c) {
        components.addElement(c);
    }

    /**
     * ΥƥʤˡݡͥѥꥹʤϿ줿Ȥ
     * Ͽ륳ݡͥȤޤ
     *
     * @param  c ݡͥ
     */
    protected void removeListenerComponent(Component c) {
        components.removeElement(c);
    }

    /**
     * ΥƥʤˡݡͥѥꥹʤϿ줿Ȥ
     * Ͽ륳ݡͥȤɲäޤ
     *
     * @param  c ƥ
     */
    protected void addListenerContainer(Container c) {
        containers.addElement(c);
    }

    /**
     * ΥƥʤˡƥѥꥹʤϿ줿Ȥ
     * Ͽ륳ƥʤޤ
     *
     * @param  c ƥ
     */
    protected void removeListenerContainer(Container c) {
        containers.removeElement(c);
    }

    /**
     * ΥƥΤ٤ƤΥݡͥȤ̵Τޤ
     */
    public void invalidateAll() {
        baseContainer.invalidate();
    }

//### Override
    /**
     * ꤵ줿ݡͥȤ򡢤Υƥʻźɲäޤ
     * <p>
     * ϡƥʤؤɲ׵򤹤٤פ
     * С饤ɤ᥽åɤǤС饤ɤ᥽åɤ̾
     * <code>super.addImpl(comp, constraints, index)</code> ؤ
     * ƤӽФޤʤФʤޤ
     *
     * @param  comp ɲä륳ݡͥ
     * @param  constraints ΥݡͥȤ־ɽ륪֥
     * @param  index ݡͥȤ٤֡
     *               Ǹ <code>-1</code>
     */
    protected void addImpl(Component comp, Object constraints, int index) {
        Container base = baseContainer;
        if (base != null) {
            base .add    (comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    /**
     * ॳƥΥݡͥȿ֤ޤ
     *
     * @return ݡͥȿ
     */
    public int getInnerComponentCount() {
        Container base = baseContainer;
        return (base != null
                ? base .getComponentCount()
                : super.getComponentCount());
    }

    /**
     * ॳƥ <code>n</code> ܤΥݡͥȤޤ
     *
     * @param  n 褦Ȥ륳ݡͥȤֹ
     *
     * @return ݡͥȿ
     *
     * @throws ArrayIndexOutOfBoundsException
     *         <code>n</code> ܤͤ¸ߤʤ
     */
    public Component getInnerComponentCount(int n) {
        Container base = baseContainer;
        return (base != null
                ? base .getComponent(n)
                : super.getComponent(n));
    }

    /**
     * ॳƥ⤹٤ƤΥݡͥȤޤ
     *
     * @return ݡͥȿ
     */
    public Component[] getInnerComponents() {
        Container base = baseContainer;
        return (base != null
                ? base .getComponents()
                : super.getComponents());
    }

    /**
     * ƥʤꤵ줿źΥݡͥȤޤ
     *
     * @param  index 륳ݡͥȤź
     */
    public void remove(int index) {
        Container base = baseContainer;
        if (base != null) {
            base .remove(index);
        } else {
            super.remove(index);
        }
    }

    /**
     * ƥʤꤵ줿ݡͥȤޤ
     *
     * @param  comp 륳ݡͥ
     */
    public void remove(Component comp) {
        Container base = baseContainer;
        if (base != null) {
            base .remove(comp);
        } else {
            super.remove(comp);
        }
    }

    /**
     * ƥʤ餹٤ƤΥݡͥȤޤ
     */
    public void removeAll() {
        Container base = baseContainer;
        if (base != null) {
            base .removeAll();
        } else {
            super.removeAll();
        }
    }

    /**
     * ΥƥʤΥ쥤ȥޥ֤͡ޤ
     *
     * @return 쥤ȥޥ͡
     */
    public LayoutManager getLayout() {
        Container base = baseContainer;
        return (base != null
                ? base .getLayout()
                : super.getLayout());
    }

    /**
     * ΥƥʤΥ쥤ȥޥ͡ꤷޤ
     *
     * @param  mgr 쥤ȥޥ͡
     */
    public void setLayout(LayoutManager mgr) {
        Container base = baseContainer;
        if (base != null) {
            base .setLayout(mgr);
        } else {
            super.setLayout(mgr);
        }
    }

    /**
     * ΥᥤѥͥФ륳ݡͥȥꥹʤϿޤ
     *
     * @param  l Ͽ륳ݡͥȥꥹ
     */
    public void addComponentListener(ComponentListener l) {
        super.addComponentListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).addComponentListener(l);
            }
        }
    }

    /**
     * Ф륳ݡͥȥꥹʤޤ
     *
     * @param  l 륳ݡͥȥꥹ
     */
    public void removeComponentListener(ComponentListener l) {
        super.removeComponentListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).removeComponentListener(l);
            }
        }
    }

    /**
     * ФեꥹʤϿޤ
     *
     * @param  l Ͽեꥹ
     */
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).addFocusListener(l);
            }
        }
    }

    /**
     * Фեꥹʤޤ
     *
     * @param  l եꥹ
     */
    public void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).removeFocusListener(l);
            }
        }
    }

    /**
     * Ф륭ꥹʤϿޤ
     *
     * @param  l Ͽ륭ꥹ
     */
    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).addKeyListener(l);
            }
        }
    }

    /**
     * Ф륭ꥹʤޤ
     *
     * @param  l 륭ꥹ
     */
    public void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).removeKeyListener(l);
            }
        }
    }

    /**
     * ФޥꥹʤϿޤ
     *
     * @param  l Ͽޥꥹ
     */
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).addMouseListener(l);
            }
        }
    }

    /**
     * Фޥꥹʤޤ
     *
     * @param  l ޥꥹ
     */
    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).removeMouseListener(l);
            }
        }
    }

    /**
     * Фޥ⡼ꥹʤϿޤ
     *
     * @param  l Ͽޥ⡼ꥹ
     */
    public void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).addMouseMotionListener(l);
            }
        }
    }

    /**
     * Фޥ⡼ꥹʤޤ
     *
     * @param  l ޥ⡼ꥹ
     */
    public void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        synchronized (components) {
            for (int i = components.size() - 1; i >= 0; i--) {
                ((Component) components.elementAt(i)).removeMouseMotionListener(l);
            }
        }
    }

    /**
     * Ф륳ƥʥꥹʤϿޤ
     *
     * @param  l Ͽ륳ƥʥꥹ
     */
    public void addContainerListener(ContainerListener l) {
        synchronized (containers) {
            for (int i = containers.size() - 1; i >= 0; i--) {
                ((Container) containers.elementAt(i)).addContainerListener(l);
            }
        }
    }

    /**
     * Ф륳ƥʥꥹʤޤ
     *
     * @param  l 륳ƥʥꥹ
     */
    public void removeContainerListener(ContainerListener l) {
        synchronized (containers) {
            for (int i = containers.size() - 1; i >= 0; i--) {
                ((Container) containers.elementAt(i)).removeContainerListener(l);
            }
        }
    }
}
