/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.io.PathAbsoluter;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;

/**
 * 侩줿ܥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class BrowseButton extends Button {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resources";

    /** ǥ쥯ȥ */
    public static final int DIRECTORY = 1;
    /** ե */
    public static final int FILE      = 2;

    /** @serial ǥեȥ٥ */
    private static String label = Resource.getMessage(RESOURCE, "browsebutton.label", null);
    /** @serial  */
    private int       type;
    /** @serial ƥ */
    private TextField text;

    /** @serial Υȥ */
    private String         title;
    /** @serial Υå */
    private String         message;
    /** @serial ե̾Υե륿 */
    private FilenameFilter filter;
    /** @serial ѥѴ */
    private PathAbsoluter  absoluter;

    /**
     * ꤷ
     *
     * @serial    ꥵ
     */
    protected Dimension size;

    /**
     * ƥȥեɤϢ뤷ȥܥޤ
     *
     * @param  type 
     * @param  text ƥ
     */
    public BrowseButton(int type, TextField text) {
        super(label);
        this.type = type;
        this.text = text;

        // ꥹʤϿ
        addActionListener(
            new ActionListener() {
                /** ȯ */
                public void actionPerformed(ActionEvent e) {
                    // Frame 򸡽
                    Frame owner = LayoutUtils.getFrame(BrowseButton.this);
                    if (owner == null) {
                        return;
                    }

                    // ̤
                    String title    = BrowseButton.this.title;
                    String fileName = BrowseButton.this.text.getText();
                    File   file     = null;
                    if (fileName.length() > 0) {
                        file = new File(fileName);
                        if (absoluter != null) {
                            file = absoluter.convertRelativeToCanonical(file);
                        }
                    }

                    switch (BrowseButton.this.type) {
                    case DIRECTORY:
                    {
                        if (title == null) {
                            title = Resource.getMessage(RESOURCE, "browsebutton.directory.title", null);
                        }
                        String message = BrowseButton.this.message;
                        if (message == null) {
                            message = Resource.getMessage(RESOURCE, "browsebutton.directory.message", null);
                        }

                        fileName = DirectoryDialog.show(owner, title, message, (file != null ? file.getPath() : null));

                        break;
                    }
                    case FILE:
                    {
                        if (title == null) {
                            title = Resource.getMessage(RESOURCE, "browsebutton.file.title", null);
                        }

                        // 
                        FileDialog fd = new FileDialog(owner, title);
                        // ե̾ꤵƤƤ
                        if (file != null) {
                            fd.setDirectory(file.getParent());
                            fd.setFile     (file.getName  ());
                        }
                        if (filter != null) {
                            fd.setFilenameFilter(filter);
                        }

                        // ɽ
                        fd.show();
                        if ((fileName = fd.getFile()) != null) {
                            fileName = fd.getDirectory() + fileName;
                        }

                        break;
                    }
                    default: // AVOID
                    }

                    // ̤θ
                    if (fileName != null) {
                        file = new File(fileName);
                        if (absoluter != null) {
                            file = absoluter.convertCanonicalToRelative(file);
                        }
                        BrowseButton.this.text.setText(file.getPath());
                    }
                }
            }
        );
    }

    /**
     * 侩֤ޤ
     *
     * @return 侩
     */
/*
    public Dimension getPreferredSize() {
        return new Dimension(size);
    }
*/

    /**
     * Ǿ֤ޤ
     *
     * @return Ǿ
     */
    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    /**
     * 祵֤ޤ
     *
     * @return 祵
     */
    public Dimension getMaximumSize() {
        return getPreferredSize();
    }

    /**
     * ե롦ǥ쥯ȥ򤹤Υȥ֤ޤ
     *
     * @return ȥ
     */
    public String getTitle() {
        return title;
    }

    /**
     * ե롦ǥ쥯ȥ򤹤Υȥꤷޤ
     *
     * @param  title ȥ
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * ǥ쥯ȥ򤹤Υå֤ޤ
     *
     * @return å
     */
    public String getMessage() {
        return message;
    }

    /**
     * ǥ쥯ȥ򤹤Υåꤷޤ
     *
     * @param  message å
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * եꤹե륿֤ޤ
     *
     * @return ե륿
     */
    public FilenameFilter getFilenameFilter() {
        return filter;
    }

    /**
     * եꤹե륿ꤷޤ
     * ǻꤵե륿ϡեѤޤ
     * ǥ쥯ȥǤѤޤ
     *
     * @param  filter ե륿
     */
    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    /**
     * ե̾Ѵ륳С֤ޤ
     *
     * @return С
     */
    public PathAbsoluter getPathAbsoluter() {
        return absoluter;
    }

    /**
     * ե̾Ѵ륳Сꤷޤ
     *
     * @param  absoluter С
     */
    public void setPathAbsoluter(PathAbsoluter absoluter) {
        this.absoluter = absoluter;
    }
}
