/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

/**
 * ܡȤäƥʤǤ
 * ʸåܥåդʸ٥Ȥɽ뤳Ȥޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class BorderContainer extends CustomContainer {
    private static final int BORDER = 5;
    private static final int MARGIN = 8;

    /** @serial ݡͥ */
    private Component component;
    /** @serial ٥ */
    private Label     label;
    /** @serial åܥå */
    private Checkbox  checkbox;
    /** @serial ᥤѥͥ */
    private Container mainPanel;

    /**
     * ꤷ٥Υƥʤޤ
     *
     * @param  label ٥
     */
    public BorderContainer(String label) {
        this.component = this.label = new Label(label);
        initialize();
    }

    /**
     * åܥå٥Ȥƥʤޤ
     *
     * @param  checkbox åܥå
     */
    public BorderContainer(Checkbox checkbox) {
        this.component = this.checkbox = checkbox;

        checkbox.addItemListener(
            new ItemListener() {
                /** ƥब򤵤줿 */
                public void itemStateChanged(ItemEvent e) {
                    mainPanel.setEnabled(BorderContainer.this.checkbox.getState());
                }
            }
        );


        initialize();
        mainPanel.setEnabled(checkbox.getState());
    }

    /**  */
    private void initialize() {
        GridBagLayout gbl = new GridBagLayout();
        setLayout(gbl);

        mainPanel = new MainPanel();

        Insets insets = new Insets(0, BORDER + MARGIN, 2, BORDER);
        LayoutUtils.addGridBag(this, component, gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.NONE, GridBagConstraints.WEST  , insets);
        insets.bottom = BORDER;
        LayoutUtils.addGridBag(this, mainPanel, gbl, 0, 1, 1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.CENTER, insets);

        setBaseContainer    (mainPanel);
        addListenerComponent(component);
        addListenerComponent(mainPanel);
        addListenerContainer(mainPanel);
    }

    /**
     * ֥ѥͥκԤޤ
     *
     * @param  g Graphics ɥ
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ֥ѥͥԤޤ
     *
     * @param  g Graphics ɥ
     */
    public void paint(Graphics g) {
        Dimension size  = getSize();
        Dimension cSize = component.getSize();

        // طʿɤ
        g.setColor(getBackground());
        g.fillRect(0, 0, size.width, size.height);

        int height = cSize.height / 2;
        int right  = BORDER + MARGIN + cSize.width;

        // 
        g.setColor(SystemColor.controlShadow);
        g.drawLine(1, height, 1, size.height - 3);
        g.drawLine(1, height, BORDER, height);
        g.drawLine(right, height, size.width - 3, height);
        g.drawLine(1, size.height - 3, size.width - 3, size.height - 3);
        g.drawLine(size.width - 3, height, size.width - 3, size.height - 3);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(2, height + 1, 2, size.height - 4);
        g.drawLine(2, height + 1, BORDER, height + 1);
        g.drawLine(right, height + 1, size.width - 4, height + 1);
        g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
        g.drawLine(size.width - 2, height + 1, size.width - 2, size.height - 2);

        paintComponents(g);
    }

    /**
     * ݡͥȤѲǽˤޤ
     *
     * @param  b Ѳǽˤ <code>true</code>
     *           ԲĤˤ <code>false</code>
     */
    public void setEnabled(boolean b) {
        super.setEnabled(b);

        checkbox .setEnabled(b);
        mainPanel.setEnabled(b && checkbox.getState());
    }

//### MainPanel
    /** ᥤѥͥ */
    private final class MainPanel extends Panel implements ContainerListener {
        private Hashtable components = new Hashtable();

        /** 󥹥󥹤 */
        private MainPanel() {
            addContainerListener(this);
        }

        /** ̵ͭڤؤ */
        public void setEnabled(boolean b) {
            Component[] cs = getComponents();
            boolean     enabled = isEnabled();
            if (b == enabled) {
                return;
            }

            synchronized (components) {
                if (b) {
                    Boolean bool;
                    for (int i = 0; i < cs.length; i++) {
                        if ((bool = (Boolean) components.get(cs[i])) != null) {
                            cs[i].setEnabled(bool.booleanValue());
                        }
                    }
                    components.clear();
                } else {
                    for (int i = 0; i < cs.length; i++) {
                        components.put(cs[i], (cs[i].isEnabled() ? Boolean.TRUE : Boolean.FALSE));
                        cs[i].setEnabled(false);
                    }
                }
            }

            super.setEnabled(b);
        }

        /** ݡͥȤɲä줿 */
        public void componentAdded(ContainerEvent e) {
            synchronized (components) {
                if (!isEnabled()) {
                    Component c = e.getChild();
                    components.put(c, (c.isEnabled() ? Boolean.TRUE : Boolean.FALSE));
                    c.setEnabled(false);
                }
            }
        }

        /** ݡͥȤ줿 */
        public void componentRemoved(ContainerEvent e) {
            components.remove(e.getChild());
        }
    }
}
