/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.token.Value;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;

/**
 * AWT եå桼ƥƥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class Border {
    /**      */ public static final int TOP    =  1;
    /**      */ public static final int RIGHT  =  2;
    /**      */ public static final int BOTTOM =  4;
    /**      */ public static final int LEFT   =  8;
    /** ٤ */ public static final int ALL    = 15;

    /**  */ public Line top;
    /**  */ public Line right;
    /**  */ public Line bottom;
    /**  */ public Line left;

    private FontData fd;                      // եȥǡ
    private Insets   widths = new Insets(0, 0, 0, 0);        // 

    /**
     * Υܡޤ
     */
    public Border() {
    }

    /**
     * ١ꤷޤ
     *
     * @param  fd եȥǡ
     */
    public void setBaseSize(FontData fd) {
        this.fd = fd;

        resize(ALL);
    }

    /**
     * ܡμºݤ֤ޤ
     *
     * @return ܡ
     */
    public Insets getWidths() {
        return (Insets) widths.clone();
    }

    /**
     * ܡΥꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setStyle(int target, Value value) {
        initialize(target);

        int type = value.getType();

        if ((target & TOP   ) != 0) { top   .style = type; }
        if ((target & RIGHT ) != 0) { right .style = type; }
        if ((target & BOTTOM) != 0) { bottom.style = type; }
        if ((target & LEFT  ) != 0) { left  .style = type; }

        resize(target);
    }

    /**
     * ܡꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setWidth(int target, Value value) {
        initialize(target);

        if ((target & TOP   ) != 0) { top   .width = value; }
        if ((target & RIGHT ) != 0) { right .width = value; }
        if ((target & BOTTOM) != 0) { bottom.width = value; }
        if ((target & LEFT  ) != 0) { left  .width = value; }

        resize(target);
    }

    /**
     * ܡοꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setColor(int target, Color value) {
        initialize(target);

        if ((target & TOP   ) != 0) { top   .color = value; }
        if ((target & RIGHT ) != 0) { right .color = value; }
        if ((target & BOTTOM) != 0) { bottom.color = value; }
        if ((target & LEFT  ) != 0) { left  .color = value; }
    }

    /** ܡ򤹤 */
    private void initialize(int target) {
        if ((target & TOP   ) != 0 && top    == null) { top    =  new Line(); }
        if ((target & RIGHT ) != 0 && right  == null) { right  =  new Line(); }
        if ((target & BOTTOM) != 0 && bottom == null) { bottom =  new Line(); }
        if ((target & LEFT  ) != 0 && left   == null) { left   =  new Line(); }
    }

    /** Ʒ׻ */
    private void resize(int target) {
        if (fd == null) { return; }

        if ((target & TOP   ) != 0 && top    != null && top   .width != null) { widths.top    = (top   .style != Value.BORDER_NONE ? getBorderWidth(top   .width) : 0); }
        if ((target & RIGHT ) != 0 && right  != null && right .width != null) { widths.right  = (right .style != Value.BORDER_NONE ? getBorderWidth(right .width) : 0); }
        if ((target & BOTTOM) != 0 && bottom != null && bottom.width != null) { widths.bottom = (bottom.style != Value.BORDER_NONE ? getBorderWidth(bottom.width) : 0); }
        if ((target & LEFT  ) != 0 && left   != null && left  .width != null) { widths.left   = (left  .style != Value.BORDER_NONE ? getBorderWidth(left  .width) : 0); }
    }

    /** ܡΤºݤ礭֤ */
    private int getBorderWidth(Value value) {
        switch (value.getType()) {
        case Value.TYPE_KEY_THIN  : return 1;
        case Value.TYPE_KEY_MEDIUM: return 2;
        case Value.TYPE_KEY_THICK : return 3;
        default:
            return value.getValue(1, 0, fd, Value.DATA_VERTICAL);
        }
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getClass().getName());
        sb.append('[');
        if (top    != null) { sb.append(top   .toString()); } sb.append(", ");
        if (right  != null) { sb.append(right .toString()); } sb.append(", ");
        if (bottom != null) { sb.append(bottom.toString()); } sb.append(", ");
        if (left   != null) { sb.append(left  .toString()); } sb.append(']' );
        return sb.toString();
    }

    /**
     * ܡ褷ޤ
     *
     * @param  g     եå
     * @param  x1     X ɸ
     * @param  y1     Y ɸ
     * @param  x2     X ɸ
     * @param  y2     Y ɸ
     * @param  color ǥեȤο
     */
    public void draw(Graphics g, int x1, int y1, int x2, int y2, Color color) {
        if (widths.top > 0 && (top.color == null || !(top.color instanceof Transparent))) {
            fillRectangle(g,
                          x1, y1,
                          x2, y1,
                          x2 - widths.right, y1 + widths.top,
                          x1 + widths.left , y1 + widths.top,
                          top.style,
                          (top.color != null ? top.color : color),
                          TOP);
        }

        if (widths.right > 0 && (right.color == null || !(right.color instanceof Transparent))) {
            fillRectangle(g,
                          x2 - widths.right, y1 + widths.top,
                          x2, y1,
                          x2, y2,
                          x2 - widths.right, y2 - widths.bottom,
                          right.style,
                          (right.color != null ? right.color : color),
                          RIGHT);
        }

        if (widths.bottom > 0 && (bottom.color == null || !(bottom.color instanceof Transparent))) {
            fillRectangle(g,
                          x1 + widths.left , y2 - widths.bottom,
                          x2 - widths.right, y2 - widths.bottom,
                          x2, y2,
                          x1, y2,
                          bottom.style,
                          (bottom.color != null ? bottom.color : color),
                          BOTTOM);
        }

        if (widths.left > 0 && (left.color == null || !(left.color instanceof Transparent))) {
            fillRectangle(g,
                          x1, y1,
                          x1 + widths.left, y1 + widths.top,
                          x1 + widths.left, y2 - widths.bottom,
                          x1, y2,
                          left.style,
                          (left.color != null ? left.color : color),
                          LEFT);
        }
    }

    /** ʺ塢塢 */
    private void fillRectangle(Graphics g,
                               int x1, int y1, int x2, int y2,
                               int x3, int y3, int x4, int y4,
                               int style, Color color, int sense) {
        switch (style) {
        case Value.BORDER_DOTTED: // 
        case Value.BORDER_DASHED: // 
        {
            g.setColor(color);
            int n = 0;
            switch (sense) {
            case TOP   :
                n = y4 - y1;
                GraphicsUtils.drawDashed(g, x1, y1, x2 - x1, n,
                                         (style == Value.BORDER_DOTTED ? n : n * 3),
                                         (style == Value.BORDER_DOTTED ? n : n * 2),
                                         GraphicsUtils.HORIZONTAL);
                break;
            case RIGHT :
                n = x2 - x1;
                GraphicsUtils.drawDashed(g, x1, y2, n, y3 - y2,
                                         (style == Value.BORDER_DOTTED ? n : n * 3),
                                         (style == Value.BORDER_DOTTED ? n : n * 2),
                                         GraphicsUtils.VERTICAL  );
                break;
            case BOTTOM:
                n = y4 - y1;
                GraphicsUtils.drawDashed(g, x4, y1, x3 - x4, n,
                                         (style == Value.BORDER_DOTTED ? n : n * 3),
                                         (style == Value.BORDER_DOTTED ? n : n * 2),
                                         GraphicsUtils.HORIZONTAL);
                break;
            case LEFT  :
                n = x2 - x1;
                GraphicsUtils.drawDashed(g, x1, y1, n, y4 - y1,
                                         (style == Value.BORDER_DOTTED ? n : n * 3),
                                         (style == Value.BORDER_DOTTED ? n : n * 2),
                                         GraphicsUtils.VERTICAL  );
                break;
            default: // AVOID
            }

            break;
        }
        case Value.BORDER_SOLID:  // 
            g.setColor(color);
            fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
            break;
        case Value.BORDER_DOUBLE: // 
        {
            g.setColor(color);
            int w = 0;
            if (sense == TOP || sense == BOTTOM) {
                w = y4 - y1;
            } else {
                w = x2 - x1;
            }

            //  3 ̤ξ̾
            if (w < 3) {
                fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
                break;
            }

            int n = (w / 3) + ((w % 3) == 2 ? 1 : 0);
            double d = (double) n / (double) w;
            switch (sense) {
            case TOP   :
                fillRectanglePart(g, x1, y1, x2, y2, (int) (x2 - (x2 - x3) * d), y2 + n, (int) (x1 + (x4 - x1) * d), y1 + n);
                fillRectanglePart(g, (int) (x4 - (x4 - x1) * d), y4 - n, (int) (x3 + (x2 - x3) * d), y3 - n, x3, y3, x4, y4);
                break;
            case RIGHT :
                fillRectanglePart(g, x1, y1, x1 + n, (int) (y1 - (y1 - y2) * d), x4 + n, (int) (y4 + (y3 - y4) * d), x4, y4);
                fillRectanglePart(g, x2 - n, (int) (y2 + (y1 - y2) * d), x2, y2, x3, y3, x3 - n, (int) (y3 - (y3 - y4) * d));
                break;
            case BOTTOM:
                fillRectanglePart(g, x1, y1, x2, y2, (int) (x2 + (x3 - x2) * d), y2 + n, (int) (x1 - (x1 - x4) * d), y1 + n);
                fillRectanglePart(g, (int) (x4 + (x1 - x4) * d), y4 - n, (int) (x3 - (x3 - x2) * d), y3 - n, x3, y3, x4, y4);
                break;
            case LEFT  :
                fillRectanglePart(g, x1, y1, x1 + n, (int) (y1 + (y2 - y1) * d), x4 + n, (int) (y4 - (y4 - y3) * d), x4, y4);
                fillRectanglePart(g, x2 - n, (int) (y2 - (y2 - y1) * d), x2, y2, x3, y3, x3 - n, (int) (y3 + (y4 - y3) * d));
                break;
            default: // AVOID
            }

            break;
        }
        case Value.BORDER_GROOVE: // ؤ
        case Value.BORDER_RIDGE:  // δ
        {
            int w = 0;
            if (sense == TOP || sense == BOTTOM) {
                w = y4 - y1;
            } else {
                w = x2 - x1;
            }

            //  2 ̤ξ̾
            if (w < 2) {
                g.setColor(color);
                fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
                break;
            }

            int n = w / 2;
            double d = (double) n / (double) w;
            int x5 = 0, y5 = 0, x6 = 0, y6 = 0;

            if (style == Value.BORDER_GROOVE) {
                g.setColor(ColorConverter.getDarker  (color));
            } else {
                g.setColor(ColorConverter.getBrighter(color));
            }

            // ¦
            switch (sense) {
            case TOP   :
                x5 = (int) (x2 - (x2 - x3) * d);
                y5 = y2 + n;
                x6 = (int) (x1 + (x4 - x1) * d);
                y6 = y1 + n;
                fillRectanglePart(g, x1, y1, x2, y2, x5, y5, x6, y6);
                break;
            case RIGHT :
                x5 = x2 - n;
                y5 = (int) (y2 + (y1 - y2) * d);
                x6 = x3 - n;
                y6 = (int) (y3 - (y3 - y4) * d);
                fillRectanglePart(g, x1, y1, x5, y5, x6, y6, x4, y4);
                break;
            case BOTTOM:
                x5 = (int) (x3 - (x3 - x2) * d);
                y5 = y3 - n;
                x6 = (int) (x4 + (x1 - x4) * d);
                y6 = y4 - n;
                fillRectanglePart(g, x1, y1, x2, y2, x5, y5, x6, y6);
                break;
            case LEFT  :
                x5 = x1 + n;
                y5 = (int) (y1 + (y2 - y1) * d);
                x6 = x4 + n;
                y6 = (int) (y4 - (y4 - y3) * d);
                fillRectanglePart(g, x1, y1, x5, y5, x6, y6, x4, y4);
                break;
            default: // AVOID
            }

            if (style == Value.BORDER_GROOVE) {
                g.setColor(ColorConverter.getBrighter(color));
            } else {
                g.setColor(ColorConverter.getDarker  (color));
            }

            // ¦
            switch (sense) {
            case TOP   :
                fillRectanglePart(g, x6, y6, x5, y5, x3, y3, x4, y4);
                break;
            case RIGHT :
                fillRectanglePart(g, x5, y5, x2, y2, x3, y3, x6, y6);
                break;
            case BOTTOM:
                fillRectanglePart(g, x6, y6, x5, y5, x3, y3, x4, y4);
                break;
            case LEFT  :
                fillRectanglePart(g, x5, y5, x2, y2, x3, y3, x6, y6);
                break;
            default: // AVOID
            }

            break;
        }
        case Value.BORDER_INSET:  // ¦ؤ
            if (sense == TOP || sense == LEFT) {
                g.setColor(ColorConverter.getDarker  (color));
            } else {
                g.setColor(ColorConverter.getBrighter(color));
            }
            fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
            break;
        case Value.BORDER_OUTSET: // ¦δ
            if (sense == TOP || sense == LEFT) {
                g.setColor(ColorConverter.getBrighter(color));
            } else {
                g.setColor(ColorConverter.getDarker  (color));
            }
            fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
            break;
        default: // AVOID
        }
    }

    /** ʬʺ塢塢 */
    private void fillRectanglePart(Graphics g,
                                   int x1, int y1, int x2, int y2,
                                   int x3, int y3, int x4, int y4) {
        if (y1 != y2 || x2 != x3 || y3 != y4 || x4 != x1) {
            Polygon polygon = new Polygon();
            polygon.addPoint(x1, y1);
            polygon.addPoint(x2, y2);
            polygon.addPoint(x3, y3);
            polygon.addPoint(x4, y4);
            g.fillPolygon(polygon);
//Debug.out.println("p=" + polygon);
        } else {
            g.fillRect(x1, y1, x3 - x1, y3 - y1);
//Debug.out.println("r=[" + x1 + "," + y1 + "," + (x3 - x1) + "," + (y3 - y1) + "]");
        }
    }

//### Line
    /**
     * γƥ饤ɽޤ
     */
    public final class Line {
        /**  */
        public int   style = Value.BORDER_SOLID;
        /**  */
        public Value width;
        /**  */
        public Color color;

        /** 󥹥󥹤 */
        private Line() {
        }

        /**
         * ʸɽ֤ޤ
         *
         * @return ʸɽ
         */
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(getClass().getName());
            sb.append('[');
            sb.append(style);
            if (width != null) { sb.append(' '); sb.append(width.toString()); }
            if (color != null) { sb.append(' '); sb.append(color.toString()); }
            sb.append(']');
            return sb.toString();
        }
    }
}
