/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;

/**
 * ݡͥȤľ¤٤֤쥤ȥޥ͡Ǥ
 * <p>
 * Υ쥤ȥޥ͡ϡƥʤ˥ݡͥȤɲäˡ
 * {@link java.awt.Container#setLayout(java.awt.LayoutManager)}
 * ѤϿƤɬפޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class AlignLayout implements LayoutManager2, Serializable {
    /** ʿ֤ޤ */
    public static final int HORIZONTAL = 1;
    /** ľ֤ޤ */
    public static final int VERTICAL   = 2;

    /** @serial  */
    private int sense;
    /** @serial ƬΥǥå */
    private int nowtop = -1;
    /** @serial Ƭˤ륤ǥå */
    private int top;
    /** @serial ɽ륤ǥå */
    private int show = -1;
    /** @serial ǸΥǥå */
    private int last;
    /** @serial ʿΥå */
    private int hgap;
    /** @serial ľΥå */
    private int vgap;
    /** @serial ݡͥ */
    private Vector components = new Vector();

    /**
     * å̵ǡľ֤
     * 쥤ȥޥ͡Υ󥹥󥹤ޤ
     *
     * @param  sense ֤
     */
    public AlignLayout(int sense) {
        this.sense = sense;
    }

    /**
     * ꤵ줿åפǡľ֤
     * 쥤ȥޥ͡Υ󥹥󥹤ޤ
     *
     * @param  sense ֤
     * @param  hgap  ʿΥݡͥȴ֤Υå
     * @param  vgap  ľΥݡͥȴ֤Υå
     */
    public AlignLayout(int sense, int hgap, int vgap) {
        this.sense = sense;
        this.hgap  = hgap;
        this.vgap  = vgap;
    }

    /**
     * ʿΥåפ֤ޤ
     *
     * @return ʿΥå
     */
    public int getHgap() {
        return hgap;
    }

    /**
     * ʿΥåפꤷޤ
     *
     * @param  hgap ʿΥå
     */
    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    /**
     * ľΥåפ֤ޤ
     *
     * @return ľΥå
     */
    public int getVgap() {
        return vgap;
    }

    /**
     * ľΥåפꤷޤ
     *
     * @param  vgap ľΥå
     */
    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /**
     * ꤵ줿󥪥֥ȤѤơ
     * ꤵ줿ݡͥȤ쥤Ȥɲäޤ
     *
     * @param  comp ɲä륳ݡͥ
     * @param  constraints 쥤ȤؤΥݡͥȤɲð֤ɲˡ
     */
    public void addLayoutComponent(Component comp, Object constraints) {
        synchronized (comp.getTreeLock()) {
            if (!(constraints instanceof Integer)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a Integer");
            }

            int index = ((Integer) constraints).intValue();

            if (index < 0) {
                components.addElement(comp);
            } else {
                components.insertElementAt(comp, index);
            }
        }
    }

    /**
     * @deprecated  {@link #addLayoutComponent(Component, Object)}
     *             ѤƤ
     *
     * @param  name 
     * @param  comp ݡͥ
     */
    public void addLayoutComponent(String name, Component comp) {
        synchronized (comp.getTreeLock()) {
            try {
                addLayoutComponent(comp, Integer.valueOf(name));
            } catch (NumberFormatException e) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
            }
        }
    }

    /**
     * ꤵ줿ݡͥȤ쥤Ȥޤ
     *
     * @param  comp ݡͥ
     */
    public void removeLayoutComponent(Component comp) {
        synchronized (comp.getTreeLock()) {
            components.removeElement(comp);
        }
    }

    /**
     * ꤵ줿ѥͥο侩򻻽Фޤ
     *
     * @param  parent ƥƥ
     *
     * @return ΥѥͥΥ
     */
    public Dimension preferredLayoutSize(Container parent) {
        synchronized (parent.getTreeLock()) {
            Insets insets = parent.getInsets();
            int ncomponents = components.size();
            int w = 0;
            int h = 0;

            Dimension size;
            for (int i = 0; i < ncomponents; i++) {
                size = ((Component) components.elementAt(i)).getPreferredSize();

                if (sense == HORIZONTAL) {
                    w += size.width;
                    h =  Math.max(h, size.height);
                } else {
                    w =  Math.max(w, size.width);
                    h += size.height;
                }
            }

            return new Dimension(insets.left + insets.right + w + hgap * (ncomponents - top + 1),
                                 insets.top + insets.bottom + h + vgap * (ncomponents - top + 1));
        }
    }

    /**
     * ꤵ줿ѥͥκǾ򻻽Фޤ
     * Υ᥽åɤϡƥʤΥ礭׵᤹뤿ˡ
     * {@link #preferredLayoutSize(Container)} Ʊ̤֤ޤ
     * ⤷˺Ǿ򻻽Фɬפϡ
     * {@link #realMinimumLayoutSize(Container)} ѤƤ
     *
     * @param  parent ƥƥ
     *
     * @return ΥѥͥΥ
     */
    public Dimension minimumLayoutSize(Container parent) {
        return preferredLayoutSize(parent);
    }

    /**
     * ꤵ줿ѥͥκǾ򻻽Фޤ
     * ƥΡ礭ʥݡͥȤ˥åפǤ
     *
     * @param  parent ƥƥ
     *
     * @return ΥѥͥΥ
     */
    public Dimension realMinimumLayoutSize(Container parent) {
        synchronized (parent.getTreeLock()) {
            Insets insets = parent.getInsets();
            int ncomponents = components.size();
            int w = 0;
            int h = 0;

            Dimension size;
            for (int i = 0; i < ncomponents; i++) {
                size = ((Component) components.elementAt(i)).getMinimumSize();

                w = Math.max(w, size.width );
                h = Math.max(h, size.height);
            }

            return new Dimension(insets.left + insets.right + w + hgap * 2,
                                 insets.top + insets.bottom + h + vgap * 2);
        }
    }

    /**
     * ꤵ줿åȥƥ˥ݡͥȤ쥤ȤȤ
     * 祵֤ޤ
     *
     * @param  target ֤ɬפʥݡͥ
     *
     * @return 祵
     */
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /**
     * x ˡ֤ޤ
     *
     * @param  parent ƥƥ
     *
     * @return x ˡ
     */
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    /**
     * y ˡ֤ޤ
     *
     * @param  parent ƥƥ
     *
     * @return y ˡ
     */
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    /**
     * 쥤Ȥ̵ˤޤ
     *
     * @param  target ֤Ƥ륳ݡͥ
     */
    public void invalidateLayout(Container target) {
    }

    /**
     * ꤵ줿ѥͥΥ쥤ȤԤޤ
     *
     * @param  parent ƥƥ
     */
    public void layoutContainer(Container parent) {
        synchronized (parent.getTreeLock()) {
            Insets    insets = parent.getInsets();
            Dimension psize  = parent.getSize();
            psize.width  -= (insets.left + insets.right);
            psize.height -= (insets.top + insets.bottom);

            Dimension tsize = new Dimension(0, 0);
            int ncomponents = components.size();
            if (ncomponents == 0) {
                nowtop = last = -1;
                return;
            }

            if (show >= 0) {
                top  = show;
                show = -1;
                if (top >= last) {
                    int w = psize.width;
                    for (int i = top; i >= 0; i--) {
                        w -= ((Component) components.elementAt(i)).getPreferredSize().width;

                        if (w < 0) {
                            break;
                        }

                        top = i;
                    }
                }
            }

            Component comp;
            CHECK:
            {
                last = ncomponents - 1;
                top  = Math.min(top, last);

                // ϰ֤Υ׻
                for (int i = top; i < ncomponents; i++) {
                    comp = (Component) components.elementAt(i);

                    if (!countSize(psize, comp.getPreferredSize(), tsize)) {
                        break CHECK;
                    }

                    last = i;
                }

                // ;äƤϳϰ֤Υ׻
                for (int i = top - 1; i >= 0; i--) {
                    comp = (Component) components.elementAt(i);

                    if (!countSize(psize, comp.getPreferredSize(), tsize)) {
                        break CHECK;
                    }

                    top = i;
                }
            }

            // Ĥɽ
            last++;
            if (top >= last) {
                last = top + 1;
            }

            // Ϥɽ
            for (int i = 0; i < top; i++) {
                ((Component) components.elementAt(i)).setVisible(false);
            }

            // 
            Dimension size;
            Point p = new Point(hgap + insets.left, vgap + insets.top);
            for (int i = top; i < last; i++) {
                comp = (Component) components.elementAt(i);
                comp.setVisible(true);
                size = comp.getPreferredSize();

                if (sense == HORIZONTAL) {
                    comp.setBounds(p.x, p.y, size.width, tsize.height);
                    p.x += size.width + hgap;
                } else {
                    comp.setBounds(p.x, p.y, tsize.width, size.height);
                    p.y += size.height + vgap;
                }
            }

            // Ϥɽ
            for (int i = last; i < ncomponents ; i++) {
                ((Component) components.elementAt(i)).setVisible(false);
            }

            nowtop = top;
        }
    }

    /**
     * ꤷǥåΥݡͥȤɽ褦˺֤ޤ
     *
     * @param  parent ƥƥ
     * @param  index  ɽ륤ǥå
     */
    public void show(Container parent, int index) {
        synchronized (parent.getTreeLock()) {
            checkLayout(parent);
            if (top <= index && index < last) {
                return;
            }

            show = index;
            parent.invalidate();
        }
    }

    /**
     * ݡͥȥꥹȤƬɽ褦˺֤ޤ
     *
     * @param  parent ƥƥ
     */
    public void first(Container parent) {
        synchronized (parent.getTreeLock()) {
            checkLayout(parent);
            if (top == 0) {
                return;
            }

            top = 0;
            parent.invalidate();
            parent.validate();
        }
    }

    /**
     * ֤ƬߤƬΰļˤʤ褦֤ޤ
     *
     * @param  parent ƥƥ
     */
    public void next(Container parent) {
        synchronized (parent.getTreeLock()) {
            checkLayout(parent);
            if (last >= components.size()) {
                return;
            }

            top++;
            parent.invalidate();
            parent.validate();
        }
    }

    /**
     * ֤ƬߤƬΰˤʤ褦֤ޤ
     *
     * @param  parent ƥƥ
     */
    public void previous(Container parent) {
        synchronized (parent.getTreeLock()) {
            checkLayout(parent);
            if (top == 0) {
                return;
            }

            top--;
            parent.invalidate();
            parent.validate();
        }
    }

    /**
     * ݡͥȥꥹȤκǸ夬ɽ褦˺֤ޤ
     *
     * @param  parent ƥƥ
     */
    public void last(Container parent) {
        synchronized (parent.getTreeLock()) {
            checkLayout(parent);
            if (last >= components.size()) {
                return;
            }

            top = components.size() - 1;
            parent.invalidate();
            parent.validate();
        }
    }

    /**
     * ΥݡͥȤʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        return getClass().getName() + "[hgap=" + hgap + ",vgap=" + vgap + "]";
    }

    /**
     * ݡͥȤ־֤ޤ
     *
     * @return ־
     */
    public Status getStatus() {
        return new Status(nowtop, last - 1, components.size());
    }

//### private
    /** ­ʿƥݡͥȥ */
    private boolean countSize(Dimension p, Dimension c, Dimension t) {
        if (sense == HORIZONTAL) {
            if (t.width + c.width > p.width) {
                return false;
            }
            t.width  += c.width;
            t.height =  Math.max(t.height, c.height);
        } else {
            if (t.height + c.height > p.height) {
                return false;
            }
            t.width  =  Math.max(t.width, c.width);
            t.height += c.height;
        }
        return true;
    }

    /** ƤΥ쥤ȥޥ͡㤬˼ʬɤå */
    private void checkLayout(Container parent) {
        if (parent.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for AlignLayout");
        }
    }

//### Status
    /**
     * ơξǼ륯饹Ǥ
     */
    public final class Status {
        private final int top;
        private final int last;
        private final int total;

        /** 󥹥󥹤 */
        private Status(int top, int last, int total) {
            this.total = total;
            this.top   = top;
            this.last  = last;
        }

        /**
         * ʸɽ֤ޤ
         *
         * @return ʸɽ
         */
        public String toString() {
            return getClass().getName() + "[top=" + top + ",last=" + last + ",total=" + total + "]";
        }

        /**
         * Ƭ֤Ƥ륳ݡͥȤΥǥå֤ޤ
         *
         * @return ƬΥǥå
         */
        public int getTop() {
            return top;
        }

        /**
         * Ǹ֤Ƥ륳ݡͥȤΥǥå֤ޤ
         *
         * @return ǸΥǥå
         */
        public int getLast() {
            return last;
        }

        /**
         * ϿƤ륳ݡͥȤ֤ޤ
         *
         * @return ϿƤ륳ݡͥȤ
         */
        public int getTotal() {
            return total;
        }
    }
}
