/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.applet;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.addin.CookieManager;
import net.hizlab.kagetaka.awt.image.OffscreenBuffer;
import net.hizlab.kagetaka.awt.panel.HawkPanel;
import net.hizlab.kagetaka.awt.panel.PanelListener;
import net.hizlab.kagetaka.parser.ParserManager;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.HawkEngine;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Link;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.RequestList;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.Environment;
import net.hizlab.kagetaka.util.StringUtils;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ΥץåȤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.14 $
 */
public class HawkApplet extends Applet {
    private static final String RESOURCE = "net.hizlab.kagetaka.applet.Resources";
    private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
    static {
        Environment.isApplet = true;
    }

    /** @serial ݡȥץȥ */
    private Hashtable supportProtocol = new Hashtable();
    {
        StringTokenizer st = new StringTokenizer(Resource.getMessage("config.support.protocol", null), ",; ");
        while (st.hasMoreTokens()) {
            supportProtocol.put(st.nextToken(), "");
        }
    }

    /** @serial 륳ƥ */
    private HawkAppletContext context;
    /** @serial ե꡼󥤥᡼ */
    private OffscreenBuffer   offscreenBuffer;
    /** @serial åޥ͡ */
    private CookieManager     cookieManager;

    /** @serial ɥ쥹С */
    private TextField         addressBar;
    /** @serial ơСʸ */
    private String            statusText;
    /** @serial ץ */
    private Option            option        = new Option();
    /** @serial Сɽ */
    private int               showScrollbar = Value.SCROLLING_YES;
    /** @serial ٥ */
    private int               logLevel      = Reporter.ERROR;
    /** @serial ˬѤ URL */
    private Hashtable         visitedUrl    = new Hashtable();

    /**
     * 륢ץåȤΥ󥹥󥹤ޤ
     */
    public HawkApplet() {
    }

    /**
     * ץåȤޤ
     */
    public void init() {
        this.addressBar = new TextField();
        addressBar.setEditable(false);

        String  value;
        Font    font;
        boolean useAddressBar = true;

        // եȤ
        if ((font = getFontParameter("font"           )) != null) {
            option.setFontSansSerif(font);
        }
        if ((font = getFontParameter("font.serif"     )) != null) {
            option.setFontSerif    (font);
        }
        if ((font = getFontParameter("font.sans-serif")) != null) {
            option.setFontSansSerif(font);
        }
        if ((font = getFontParameter("font.cursive"   )) != null) {
            option.setFontCursive  (font);
        }
        if ((font = getFontParameter("font.fantasy"   )) != null) {
            option.setFontFantasy  (font);
        }
        if ((font = getFontParameter("font.monospace" )) != null) {
            option.setFontMonospace(font);
        }
        if ((value = getParameter("font.style")) != null) {
            option.setFontStyle(value);
        }

        // ѡ
        if ((value = getParameter("parser")) != null) {
            if (ParserManager.getParser(value) != null) {
                option.setInputStreamParser(value);
            } else {
                showStatus(getMessage("parameter.noparser", new String[]{value}));
            }
        }

        // ɥ쥹С
        if ((value = getParameter("addressbar")) != null) {
            useAddressBar = Boolean.valueOf(value).booleanValue();
        }

        // ɥ쥹С
        if ((value = getParameter("scrollbar")) != null) {
            value = value.trim().toLowerCase();
            if (value.compareTo("auto") == 0) {
                showScrollbar = Value.SCROLLING_AUTO;
            } else if (value.compareTo("yes") == 0 || value.compareTo("true") == 0) {
                showScrollbar = Value.SCROLLING_YES;
            } else if (value.compareTo("no") == 0 || value.compareTo("false") == 0) {
                showScrollbar = Value.SCROLLING_NO;
            }
        }

        // βž
        if ((value = getParameter("spin")) != null) {
            option.setSpinImage(Boolean.valueOf(value).booleanValue());
        }
        setupSpinImage(option, "gif" );     // GIF ž
        setupSpinImage(option, "jpeg");     // JPEG ž
        setupSpinImage(option, "png" );     // PNG ž
        setupSpinImage(option, "*"   );     // ¾ž

        // ƥȽ饤
        if ((value = getParameter("swapdecoration")) != null) {
            option.setSwapDecoration(Boolean.valueOf(value).booleanValue());
        }

        // LogLevel 
        if ((value = getParameter("loglevel")) != null) {
            logLevel = Integer.parseInt(value);
        }

        // URL 
        if ((value = getParameter("url")) == null) {
            showStatus(getMessage("parameter.nourl", null));
            return;
        }

        URL url = null;
        try {
            url = new URL(getCodeBase(), value);
        } catch (MalformedURLException e) {
            showStatus(getMessage("error.url.unknown", new String[]{value, e.toString()}));
            return;
        }

        // 
        this.context         = new HawkAppletContext();
        this.offscreenBuffer = new OffscreenBuffer(this);
        this.cookieManager   = CookieManager.createInstance();

        // ̤
        setLayout(new BorderLayout());
        if (useAddressBar) {
            add(addressBar, BorderLayout.NORTH );
        }
        add(context.hawkPanel, BorderLayout.CENTER);

        // եɤ߹
        open(url);
    }

    /**
     * ٤ƤΥ꥽˴ޤ
     */
    public void destroy() {
        super.destroy();
        removeAll();
        context.dispose();
    }

    /**
     * ץåȤμ¹Ԥ򳫻Ϥޤ
     */
    public void start() {
        super.start();
        context.hawkPanel.requestFocus();
    }

    /**
     * ץåȤμ¹Ԥߤޤ
     */
    /*
    public void stop() {
        super.stop();
    }
    */

    /**
     * 륢ץåȤˤĤƤξ֤ޤ
     *
     * @return 륢ץåȤξ
     */
    public String getAppletInfo() {
        return Resource.getMessage("kagetaka.copyright", null);
    }

    /**
     * 륢ץåȤǤѥ᡼֤ͤޤ
     *
     * @return 륢ץåȤǤѥ᡼
     */
    public String[][] getParameterInfo() {
        return new String[][] {
            {"font"           , "Font"   , "SansSerif font (deprecated)"             },
            {"font.serif"     , "Font"   , "Serif font"                              },
            {"font.sans-serif", "Font"   , "SansSerif font (Default)"                },
            {"font.cursive"   , "Font"   , "Cursive font"                            },
            {"font.fantasy"   , "Font"   , "Fantasy font"                            },
            {"font.monospace" , "Font"   , "Monospace font"                          },
            {"font.style"     , "String" , "Default font style (default: sans-serif)"},
            {"parser"         , "class"  , "Parser class"                            },
            {"addressbar"     , "boolean", "Use addressbar"                          },
            {"scrollbar"      , "string" , "Scrllbar visible mode"                   },
            {"spin"           , "boolean", "Spin image"                              },
            {"spin.gif"       , "String" , "Spin GIF image"                          },
            {"spin.jpeg"      , "String" , "Spin JPEG image"                         },
            {"spin.png"       , "String" , "Spin PNG image"                          },
            {"spin.*"         , "String" , "Spin Other image."                       },
            {"swapdecoration" , "boolean", "Swap decoration line"                    },
            {"loglevel"       , "int"    , "Log level."                              },
            {"url"            , "URL"    , "Load URL"                                },
        };
    }

    /**
     * ֥ѥͥκԤޤ
     *
     * @param  g եå
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * ᡼ºݤ褷ޤ
     *
     * @param  g եå
     */
    public void paint(Graphics g) {
        offscreenBuffer.paint(g);
    }

//### Private
    /** ǡɽޤ */
    private void open(URL url) {
        context.load(new Request(url, null, getDocumentBase(), null,
                                 Request.OPEN_DEFAULT, Request.CACHE_NORMAL));
    }

    /** եȤޤ */
    private Font getFontParameter(String key) {
        String value;
        if ((value = getParameter(key)) != null) {
            Font font = Font.decode(value);
            if (font != null) {
                return font;
            }
            showStatus(getMessage("parameter.nofont", new String[]{value}));
        }
        return null;
    }

    /** եȤޤ */
    private void setupSpinImage(Option option, String key) {
        String value;
        if ((value = getParameter("spin." + key)) != null) {
            value = value.toLowerCase();
            option.setSpinImage(key,
                                (value.compareTo("all") == 0 || value.compareTo("no") == 0));
            if (value.compareTo("all") == 0) {
                option.setSpinAspectRatio(key, 1.0);
                option.setSpinMinWidth   (key, Integer.MAX_VALUE);
            }
        }
    }

    /** ꥽ʸ */
    private String getMessage(String key, String[] args) {
        return Resource.getMessage(RESOURCE, key, args);
    }

//### HawkAppletContext
    /** 륦ɥѤα륳ƥ */
    private final class HawkAppletContext implements HawkContext, PanelListener, EngineListener {
        private AppletReporter reporter = new AppletReporter();

        private HawkEngine     hawkEngine;
        private HawkPanel      hawkPanel;

        // ꥯȡ
        private Request nextRequest;        // ɤ߹Υꥯ
        private Request viewRequest;        // ɽΥڡΥꥯ
        private boolean viewMoved;          // ɽΥڡư줿

        /** 󥹥󥹤 */
        private HawkAppletContext() {
            hawkEngine  = new HawkEngine (this);
            hawkPanel   = new HawkPanel  (this,
                                          new BasicScrollbar(BasicScrollbar.HORIZONTAL),
                                          new BasicScrollbar(BasicScrollbar.VERTICAL  ),
                                          showScrollbar);

            hawkEngine.setEngineListener(this);
            hawkPanel .setPanelListener (this);

            // ˥塼ѹ
            initContextMenu();
        }

        /** ѥͥΥƥȥ˥塼 */
        private void initContextMenu() {
            String   label = getMessage("contextmenu.openbrowser", null);
            Vector   items = null;
            MenuItem mi    = null;

            mi = new MenuItem(label);
            mi.addActionListener(new MenuActionListener(MenuActionListener.MAIN));
            items = hawkPanel.getMainMenuItems();
            items.addElement(new MenuItem("-"));
            items.addElement(mi);

            mi = new MenuItem(getMessage("contextmenu.dumpstatus", null));
            mi.addActionListener(new MenuActionListener(MenuActionListener.STATUS));
            items = hawkPanel.getMainMenuItems();
            items.addElement(new MenuItem("-"));
            items.addElement(mi);

            mi = new MenuItem(label);
            mi.addActionListener(new MenuActionListener(MenuActionListener.LINK));
            items = hawkPanel.getLinkMenuItems();
            items.addElement(new MenuItem("-"));
            items.addElement(mi);
        }

        /** URL  */
        private synchronized void load(Request request) {
            // ɤ߹ߤξǡPOST ǡ¸ߤ϶ɽ
            if (request.getDocument() != null              // ɤ߹߻ˤ Document ͭ
                    && request.postData != null) {
                hawkEngine.stop();
                synchronized (this) {
                    changeHistory(request);
                }
                setupPanel(request.getDocument());
                setStatus (getMessage("error.dorepost.stop", null));
                return;
            }

            synchronized (this) {
                // ƱڡΥե󥹤ˤưǺɤ߹ߤʤ
                if (viewRequest != null
                        && viewRequest != request                           // ɤ߹ߤǤϤʤ
                        && request.getUseCache() >= Request.CACHE_NORMAL    // åѲ
                        //### TODO POST ξ϶Ū˺ɤ߹ߡ֤ͭޤǤλ
                        && request.postData == null
                        && StringUtils.sameFile(viewRequest.getDocument().content.url, request.url)) {
                    request.copyFrom(viewRequest);
                    changeHistory(request);
                    movePosition (true   );
                    setStatus    (null   );
                    return;
                }
//Debug.out.println("URL=["+url+"]");
                nextRequest = request;
            }

            hawkPanel.setCursor(Cursor.WAIT_CURSOR);
            hawkEngine.load(request);
        }

        /**
         * ˴ޤ
         */
        void dispose() {
            hawkEngine.dispose();
            Request request = viewRequest;
            if (request != null) {
                request.cleanup();
            }
        }

//### HawkContext
        /** 륦ɥѤα륳ƥȤ */
        public Reporter getReporter() {
            return reporter;
        }

        /** ġ륭åȤ֤ */
        public Toolkit getToolkit() {
            return hawkPanel.getToolkit();
        }

        /** ꤷ URL ɽ */
        public void openHawk(Request request) {
            if (supportProtocol.containsKey(request.url.getProtocol())) {
                load(request);
            } else {
                // ݡȤƤʤץȥϥ֥饦ǳ
                if (request.openMode != Request.OPEN_DEFAULT) {
                    getAppletContext().showDocument(request.url, "_blank");
                } else {
                    getAppletContext().showDocument(request.url);
                }
            }
        }

        /** ꤵ줿 URL Υ֤ͥ */
        public Content getContent(Request request)
                throws IOException, InterruptedException {
            URLConnection connection = request.url.openConnection();

            // å
            if (cookieManager != null) {
                cookieManager.send(connection);
            }

            // POST ǡ³
            if (request.postData != null && connection instanceof HttpURLConnection) {
                request.postData.send(connection);
            }

            // ³
            try {
                connection.connect();
            } finally {
                if (Thread.interrupted()) {
                    throw new InterruptedException("connect");
                }
            }

            // å
            if (cookieManager != null) {
                cookieManager.receive(connection);
            }

            return new Content(connection);
        }

        /**  ꤵ줿ƥĤ */
        public void download(Content content) {
            getAppletContext().showDocument(content.url);
            setStatus(null);
        }

        /** ᡼֤ޤ */
        public Image createImage(int width, int height) {
            return hawkPanel.createImage(width, height);
        }

        /** ǥȥå֤ */
        public MediaTracker getMediaTracker() {
            return hawkPanel.getMediaTracker();
        }

        /** ꡼󥤥᡼ɲ */
        public int setImage(int index, int reason, int tag,
                            Image image, int width, int height, ItemMap itemMap) {
            int newIndex = hawkPanel.setImage(index, reason, tag,
                                              image, width, height, itemMap);
            if (index == -1) {
                synchronized (this) {
                    movePosition(false);
                }
            }
            return newIndex;
        }

        /** եॢƥɲ */
        public void addFormItem(FormItem item) {
            hawkPanel.addFormItem(item);
        }

        /** ѥͥ򥻥åȥå */
        public void setupPanel(Document document) {
            hawkPanel.setup(document, true);
        }

        /** ѥͥե졼Ѥ˥åȥå */
        public void setupPanel(Document document, FrameItem rootItem) {
        }

        /** ѥͥ */
        public void commitPanel(Document document, int tag) {
            hawkPanel.commit(document, tag);
        }

        /** ХϰϤꤷƺɽ */
        public void repaint(int x, int y, int width, int height) {
            hawkPanel.repaintScreen(x, y, width, height);
        }

        /** ơå */
        public void setStatus(String status) {
            statusText = status;
            showStatus(status);
        }

        /** Ūʥơå */
        public void setTemporaryStatus(String status) {
            showStatus((status != null ? status : statusText));
        }

        /** ӥ塼ݡȤθߤΥ֤ */
        public Dimension getViewportSize(boolean def) {
            return hawkPanel.getViewportSize(def);
        }

        /** ץ֤ */
        public Option getOption() {
            return option;
        }

        /** ꤷ URL ˬ䤷Ȥ뤫ɤ֤ */
        public boolean haveEverVisited(URL url) {
            return visitedUrl.containsKey(url.toString());
        }

        /** å */
        public void setCookie(String value, URL url) {
            if (cookieManager != null) {
                cookieManager.setCookie(value, url);
            }
        }

//### PanelListener
        /**  */
        public void back() {
            Request request = (viewRequest != null ? viewRequest.getPrevious() : null);

            if (request == null || request == viewRequest) {
                return;
            }

            request.setUseCache(Request.CACHE_SOFT);
            load(request);
        }

        /** 뤫ɤ */
        public boolean canBack() {
            return (viewRequest != null && viewRequest.getPrevious() != null);
        }

        /** ؿʤ */
        public void forward() {
            Request request = (viewRequest != null ? viewRequest.getNext() : null);

            if (request == null || request == viewRequest) {
                return;
            }

            request.setUseCache(Request.CACHE_SOFT);
            load(request);
        }

        /** ؿʤ뤫ɤ */
        public boolean canForward() {
            return (viewRequest != null && viewRequest.getNext() != null);
        }

        /** ɹ */
        public void reload(int mode) {
            Request request = viewRequest;
            if (request != null) {
                request.setUseCache(mode);
                load(request);
            }
        }

        /** ɹǤ뤫ɤ */
        public boolean canReload() {
            return (viewRequest != null);
        }

        /**  */
        public void stop() {
            hawkEngine.stop();
        }

        /** ߤǤ뤫ɤ */
        public boolean canStop() {
            return (nextRequest != null);
        }

        /** 襹꡼Υѹ줿 */
        public void screenResized(int tag) {
        }

//### EngineListener
        /** ³Ϥ˸ƤӽФ */
        public void connecting(Request request) {
/*
            if (nextRequest != request) {
                return;
            }
*/
        }

        /** ³λȸƤӽФ */
        public void connected(Request request, boolean noerror) {
/*
            if (nextRequest != request) {
                return;
            }
*/
        }

        /** 褬åפ줿Ȥ˸ƤӽФ */
        public synchronized void renderingSkipped(Request request) {
            if (nextRequest != request) {
                return;
            }

            nextRequest = null;
            hawkPanel.setCursor(Cursor.DEFAULT_CURSOR);
        }

        /** 褬Ϥ˸ƤӽФ */
        public synchronized void renderingStarted(Request request) {
            if (nextRequest != request) {
                return;
            }

            changeHistory(request);
            hawkPanel.requestFocus();
        }

        /** 褬λȸƤӽФ */
        public synchronized void renderingStopped(Request request, boolean noerror) {
            if (nextRequest != request) {
                return;
            }

            renderingSkipped(request);
            movePosition(true);
        }

        /** ꤷ URL ɽ */
        public synchronized void refresh(Request baseRequest, Request newRequest) {
            if (viewRequest != baseRequest) {
                return;
            }

            load(newRequest);
        }

//### private
        /** ѹ */
        private void changeHistory(Request request) {
            // ߤɽ֤¸
            if (viewRequest != null) {
                viewRequest.save(hawkPanel.getScrollPosition());
            }

            // ξ
            if (!request.isChain()) {
                RequestList.append(viewRequest, request);
                visitedUrl.put(request.url.toString(), "");
            }

            if (viewRequest != null && viewRequest != request) {
                viewRequest.cleanup();
            }
            viewRequest = request;
            viewMoved   = false;

            addressBar.setText(request.getContentURL().toString());
        }

        /** ݥư */
        private void movePosition(boolean force) {
            if (viewMoved) {
                return;
            }

            Point position;

            // 桼ư֤
            if ((position = viewRequest.getPosition()) != null) {
                // 桼ˤꥯ뤵Ƥʤ
                Point scpos = hawkPanel.getScrollPosition();
                if ((force || (scpos.x == 0 && scpos.y == 0))
                        && !hawkPanel.setScrollPosition(position.x, position.y, false)) {
                    return;
                }
            } else

            // # ե󥹤ΰ֤ء307 ʤɤξǤ⡢ꥯ URL Υե󥹤Ȥ
            if (!hawkPanel.setScrollPosition(viewRequest.url.getRef(), force)) {
                return;
            }

            viewMoved = true;
        }
    }

//### AppletReporter
    /** 륦ɥѤΥݡ */
    private final class AppletReporter implements Reporter {
        /** 󥹥󥹤 */
        private AppletReporter() {
        }

        /** ݡȽ */
        public void report(int facility, int level, int emphasis,
                           Content source, int line, int column,
                           String tag, String message) {
            if (level >= logLevel) {
                StringBuffer sb = new StringBuffer();
                sb.append("#");

                switch (level) {
                case Reporter.ERROR  : sb.append("ERROR"  ); break;
                case Reporter.PROF   : sb.append("PROF"   ); break;
                case Reporter.WARNING: sb.append("WARNING"); break;
                default              : sb.append("MESSAGE");
                }

                sb.append(":");
                sb.append(line);
                sb.append(":");
                sb.append(column);
                sb.append(":");
                sb.append(tag);
                sb.append(":");
                sb.append(message);
                Debug.out.println(sb.toString());
            }

            switch (emphasis) {
            case ALERT:
            case FYI:
                context.setStatus(message);
                break;
            default: // AVOID
            }
        }

        /** ݡȽ */
        public void report(Throwable t, Request request) {
            t.printStackTrace(Debug.err);
        }

        /** ꤵ줿ݡȤ𤹤ɬפ뤫ɤ֤ */
        public boolean isReported(int facility, int level) {
            return (level >= logLevel);
        }
    }

//### MenuActionListener
    /** ץꥱ󤫤鳫ѤΥꥹ */
    private final class MenuActionListener implements ActionListener {
        private static final int MAIN   = 0;
        private static final int LINK   = 1;
        private static final int STATUS = 2;

        private int type;

        /** ꥹʤ */
        private MenuActionListener(int type) {
            this.type = type;
        }

        /** ϥɥ */
        public void actionPerformed(ActionEvent e) {
            switch (type) {
            case MAIN:
            case LINK:
            {
                URL url = null;
                if (type == MAIN) {
                    url = ((context.viewRequest != null) ? context.viewRequest.url : null);
                } else {
                    Link link = context.hawkPanel.getSelectedLink();
                    if (link != null) {
                        url = link.url;
                    }
                }
                if (url == null) {
                    return;
                }

                getAppletContext().showDocument(url);

                break;
            }
            case STATUS:
                Debug.out.println(Resource.getMessage("kagetaka.name.en"  , null) + " "
                                 + Resource.getMessage("kagetaka.version"  , null) + " "
                                 + "(Build: " + Resource.getMessage(BUILD_RESOURCE, "build.number", null) + " "
                                              + Resource.getMessage(BUILD_RESOURCE, "build.date"  , null) + ")");
                Debug.out.println(Resource.getMessage("kagetaka.copyright", null) + " "
                                 + Resource.getMessage("kagetaka.vender.en", null));
                break;
            default: // AVOID
            }
        }
    }
}
