/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.applet;

import net.hizlab.kagetaka.awt.panel.PanelScrollbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Scrollbar;

/**
 * ѥͥѤδŪʥСǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
class BasicScrollbar extends Scrollbar implements PanelScrollbar {
    private boolean isHorizontal;
    private int     value;
    private int     maximum;
    private int     visible;

    /**
     * 󥹥󥹤
     *
     * @param  orientation 
     */
    BasicScrollbar(int orientation) {
        super(orientation, 0, 1, 0, 1);
        setEnabled(false);
        this.isHorizontal = (orientation == HORIZONTAL);

        setUnitIncrement (1);
        setBlockIncrement(1);
    }

    /* ݡͥȤ֤ */
    /** {@inheritDoc} */
    public Component getComponent() {
        return this;
    }

    /* ͤꤹ */
    /** {@inheritDoc} */
    public synchronized void setValue(int newValue) {
        if (value == newValue) {
            return;
        }

        super.setValue(newValue);
        value = newValue;
    }

    /* ͤꤹ */
    /** {@inheritDoc} */
    public synchronized void setMaximum(int newMaximum) {
        if (maximum == newMaximum) {
            return;
        }

        super.setMaximum(newMaximum);
        if (isHorizontal) {
            value += newMaximum - maximum;
            if (value < 0) {
                value = 0;
            }
            super.setValue(value);
        } else {
            value = getValue();
        }

        maximum = newMaximum;
        fixValue();
    }

    /* Ļʬꤹ */
    /** {@inheritDoc} */
    public synchronized void setVisibleAmount(int newVisible) {
        if (newVisible == visible) {
            return;
        }

        super.setVisibleAmount(newVisible);
        if (isHorizontal) {
            value -= newVisible - visible;
            if (value < 0) {
                value = 0;
            }
            super.setValue(value);
        }

        visible = newVisible;
        fixValue();
    }

    /** Ĵ᤹ */
    private void fixValue() {
        boolean enabled = isEnabled();

        if (enabled != (maximum > visible)) {
            enabled = (!enabled);
            setEnabled(enabled);
        }
    }

    /**
     * 侩֤ޤ
     *
     * @return 侩
     */
    public Dimension getPreferredSize() {
        return (isHorizontal)
               ? new Dimension(0, 16)
               : new Dimension(16, 0);
    }

    /**
     * 祵֤ޤ
     *
     * @return 祵
     */
    public Dimension getMaximumSize() {
        return getPreferredSize();
    }

    /**
     * ե뤳Ȥ뤫֤ޤ
     *
     * @return ե뤳ȤǤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean isFocusTraversable() {
        return false;
    }
}
