/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.table;

/**
 * ơ֥ιԤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class Row {
    private static final int DEFAULT_SIZE = 16;

    private int         row;                // ֹ
    private CellBlock[] cols;               // 
    private int         index;              // 

    /**  */
    int size;

    /** ι */
    Row next;

    /**
     * Ԥޤ
     */
    Row() {
        this(0, DEFAULT_SIZE);
    }

    /**
     * Ԥޤ
     *
     * @param  row      ֹ
     * @param  capacity 
     */
    private Row(int row, int capacity) {
        this.row  = row;
        this.cols = new CellBlock[capacity];
    }

    /**
     * ֥åɲäޤ
     *
     * @param  cell ֥å
     *
     * @return ɲäֹ
     */
    int add(CellBlock cell) {
        int colSpan = cell.colSpan;
        int rowSpan = cell.rowSpan;

        // Ϣ
        for (;;) {
            // ХåեϹ
            if (cols.length <= index) {
                resize(index + colSpan);
                break;
            }

            // ޤäƤʾιԤȷҤäƤ˼ذư
            if (cols[index] != null) {
                index++;
                continue;
            }

            // ĤΤ٤ʤϹ
            if (cols.length <= index + colSpan) {
                resize(index + colSpan);
            }
            break;
        }
        // ϢȤ߹碌ˤꥻ뤬Ťʤ硢Ϣͥ褵
        int beginIndex = index;
        do {
            if (cols[index] == null) {
               cols[index] = cell;
            }
            index++;
        } while (--colSpan > 0);
        size = Math.max(size, index);

        // ԤϢ
        if (rowSpan > 1) {
            next().set(cell, beginIndex, index, --rowSpan);
        }

        cell.setPosition(beginIndex, row);

        return beginIndex;
    }

    /** ֤ */
    private void set(CellBlock cell, int beginIndex, int endIndex, int rowSpan) {
        // ԤϡιԤƱϤϤʤΤǥå
        for (int i = endIndex - 1; i >= beginIndex; i--) {
            if (cols[i] == null) {
               cols[i] = cell;
            }
        }
        size = Math.max(size, endIndex);

        // ԤϢ
        if (rowSpan > 1) {
            next().set(cell, beginIndex, endIndex, --rowSpan);
        }
    }

    /**
     * Ԥ֤ޤ
     *
     * @return 
     */
    Row next() {
        if (next != null) {
            return next;
        }

        return next = new Row(row + 1, cols.length);
    }

    /**
     * Ϥ߽ФƤ륻άޤ
     */
    void cut() {
        CellBlock cell;
        for (int c = size - 1; c >= 0; c--) {
            if ((cell = cols[c]) != null && cell.col == c) {
                cell.rowSpan = row - cell.row;
            }
        }
        index = size = 0;
        cols  = null;
        next  = null;
    }

    /**
     * 򥳥ԡޤ
     *
     * @param  cells      
     * @param  copyLength ԡĹ
     */
    void copy(CellBlock[][] cells, int copyLength) {
        if (cols.length >= copyLength) {
            cells[row] = cols;
        } else {
            cells[row] = new CellBlock[copyLength];
            System.arraycopy(cols, 0, cells[row], 0, cols.length);
        }
    }

    /**
     * 򥳥ԡޤ
     *
     * @param  cells      
     * @param  srcIndex   ԡʼʬˤγϥǥå
     * @param  dstIndex   ԡγϥǥå
     * @param  copyLength ԡĹ
     * @param  cutLength  ڤĹ
     */
    void copy(CellBlock[][] cells, int srcIndex, int dstIndex, int copyLength,
              int cutLength) {
//Debug.out.println(row+","+cols.length+","+srcIndex+","+cells[row].length+","+dstIndex+","+copyLength+","+cutLength);
        System.arraycopy(cols, srcIndex, cells[row], dstIndex, copyLength);

        // ṳ̂줿Ϣ
        if (cutLength > 0) {
            CellBlock cell = cols[srcIndex + copyLength];
            if (cell != null) {
                cell.colSpan -= cutLength;
            }
        }

        // ֤ѤäΤ
        if (srcIndex > dstIndex) {
            CellBlock cell;
            int       diff = srcIndex - dstIndex;
            for (int c = srcIndex + copyLength - 1; c >= srcIndex; c--) {
                if ((cell = cols[c]) != null && cell.col == c) {
                    cell.col -= diff;
                }
            }
        }
    }

    /** Хåե򹭤 */
    private void resize(int required) {
        required = Math.max(cols.length * 2, required);
        CellBlock[] newCols = new CellBlock[required];
        System.arraycopy(cols, 0, newCols, 0, cols.length);
        cols = newCols;
    }
}
