/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.table;

import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.block.Block;
import net.hizlab.kagetaka.rendering.block.ContainerBlock;
import net.hizlab.kagetaka.token.Value;

import java.util.BitSet;

/**
 * ơ֥ΥåɤʬǤɽ֥åǤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.8 $
 */
class GridBlock extends Block {
    private CellBlock    colChain;          // ƬϢ뤷Ƥʤ
    private CellBlock    rowChain;          // ƬιϢ뤷Ƥʤ
    private CellBlock    colSpanChain;      // ƬϢ
    private CellBlock    rowSpanChain;      // ƬιϢ
    private CellBlock    lastCellBlock;     // ǸΥ֥å

    private int verticalSpacing;            // ֤
    private int horizontalSpacing;          // ιԴ֤

    private int gridPreferredWidth;         // åɤο侩
    private int gridPreferredHeight;        // åɤο侩⤵

    // Ϣ륻νɬ
    private BitSet        colSet;           // ¸ߤ뤫
    private boolean       isExistsColSpan;  // Ϣ뤬뤫
    private boolean       isExistsRowSpan;  // Ϣ뤬뤫
    private Row           topRow;           // ǽι
    private Row           curRow;           // ߹

    private int           colNum;           // åɤιԿ
    private int           rowNum;           // åɤ
    private CellBlock[][] cells;            // 

    private int[]         minHeights;       // Ǿι⤵
    private int[]         maxHeights;       // ι⤵
    private int[]         preHeights;       // 侩ι⤵ʸ or %
    private int           minHeightSum;     // κιסʥ֤ϴޤޤʤ
    private int           maxHeightSum;     // κιסʥ֤ϴޤޤʤ
    private int           preHeightSum;     // ο侩ιסʥ֤ϴޤޤʤor % ι
    private boolean       hasPercent;       // λ꤬ % ɤ

    /**
     * ơ֥륰åɤޤ
     *
     * @param  drawkit   ɥå
     * @param  status    ơ
     * @param  container ƥʥ֥å
     *                   եȤαƶʤ <code>null</code>
     * @param  parent    ƥ֥å
     */
    GridBlock(Drawkit drawkit, Status status,
              ContainerBlock container, Block parent) {
        super(drawkit, status, container, parent);

        this.isAdoptee = true;

        colSet = new BitSet(32);            // Ϥ٤Ͻʬ
        topRow = curRow = new Row();

        // ֤׻
        verticalSpacing   = (status.borderVerticalSpacing   != null
                             ? status.borderVerticalSpacing  .getValue(1, 0,
                                                                       status.fontData,
                                                                       Value.DATA_VERTICAL  )
                             : 2);
        horizontalSpacing = (status.borderHorizontalSpacing != null
                             ? status.borderHorizontalSpacing.getValue(1, 0,
                                                                       status.fontData,
                                                                       Value.DATA_HORIZONTAL)
                             : 2);
//Debug.out.println(this + ":GridBlock.layoutBlock: space=[" + verticalSpacing + "," + horizontalSpacing + "]");
    }

    /** {@inheritDoc} */
    protected void calculatePreferred() {
        super.calculatePreferred();
        gridPreferredWidth  = preferredWidth;
        gridPreferredHeight = preferredHeight;
        preferredWidth  = SIZE_NONE;
        preferredHeight = SIZE_NONE;
    }

    /** {@inheritDoc} */
    public Block createBlock(Status status, Status markerStatus) {
        CellBlock cellBlock = new CellBlock(drawkit, status, this);
        if (colChain == null) {
            colChain = rowChain = lastCellBlock = cellBlock;
        } else {
            lastCellBlock = lastCellBlock.nextCol = lastCellBlock.nextRow = cellBlock;
        }

        // ȹԿ򽸷
        colSet.set(curRow.add(cellBlock));
        if (!isExistsColSpan && cellBlock.colSpan > 1) {
            isExistsColSpan = true;
        }
        if (!isExistsRowSpan && cellBlock.rowSpan > 1) {
            isExistsRowSpan = true;
        }

        // ɲ
        contents.addElement(cellBlock);
        return cellBlock;
    }

    /** {@inheritDoc} */
    public Block commitBlock() {
        if (lastCellBlock != null) {
            lastCellBlock.isVertical = false;
        }

        //// 
        if (colChain != null) {
            // ѿȤƷ׻
            Row           curRow = this.curRow;
            int           colNum = this.colNum;
            int           rowNum = this.rowNum;
            CellBlock[][] cells  = null;

            Row row;

            //// 뤬ˤϤ߽ФƤ
            if (curRow.size > 0) {
                curRow.cut();
            }

            //// Ϣˤꡢξάȯˡξ
            if (isExistsColSpan) {
                // 륭å
                BitSet colSet    = this.colSet;
                int    newColNum = colNum;
                for (int c = 0; c < colNum; c++) {
                    if (!colSet.get(c)) {
                        newColNum--;
                    }
                }
                // Ϣ륻ˤꡢפȯ
                if (newColNum != colNum) {
                    // 
                    cells = new CellBlock[rowNum][newColNum];
                    int start, copyLength, cutLength;
                    int srcIndex = 0;
                    int dstIndex = 0;

                    // ǽڤܤޤǰưʣܤɬ뤬ˡ
                    // 򥳥ԡڤܤνʬޤǤϢû
                    while (srcIndex < colNum) {
                        start = srcIndex;
                        // ڤܤޤǰư
                        do {
                            srcIndex++;
                        } while (srcIndex < colNum && colSet.get(srcIndex));
                        copyLength = srcIndex - start; // Ĺ

                        // ڤܤνޤǰư
                        while (srcIndex < colNum && !colSet.get(srcIndex)) {
                            srcIndex++;
                        }
                        cutLength = srcIndex - start - copyLength;

                        // ڤܤޤǤ򥳥ԡ
                        row = topRow;
                        do {
                            row.copy(cells, start, dstIndex, copyLength, cutLength);
                        } while ((row = row.next) != curRow);
                        dstIndex += copyLength;
                    }
                    this.colNum = colNum = newColNum;
                }
            }

            //// Ϣ륻ˤάȯʤäˡξ
            if (cells == null) {
                cells = new CellBlock[rowNum][];
                row = topRow;
                do {
                    row.copy(cells, colNum);
                } while ((row = row.next) != curRow);
            }

            //// Ϣ뤷Ƥ륻Υ
            if (isExistsColSpan) {
                CellBlock prev = null, top = null, last = null;
                CellBlock cell = colChain;
                for (;;) {
                    if (cell.colSpan > 1) {
                        // ColSpan Ϣ
                        if (top == null) {
                            top = last = cell;
                        } else {
                            last = last.nextColSpan = cell;
                        }
                        cell = cell.nextCol;
                        // ̾󤫤
                        if (prev == null) {
                            colChain = cell;
                        } else {
                            prev.nextCol = cell;
                        }
                        // Υ
                        if (cell != null) {
                            last.nextCol = null;
                            continue;
                        }
                        break;
                    }
                    if ((cell = (prev = cell).nextCol) == null) {
                        break;
                    }
                }
                colSpanChain = top;
            }

            //// Ϣ뤷Ƥ륻Υ
            if (isExistsRowSpan) {
                CellBlock prev = null, top = null, last = null;
                // Ȥꤢ̾󤫤
                CellBlock cell = rowChain;
                for (;;) {
                    if (cell.rowSpan > 1) {
                        last = cell;
                        cell = cell.nextRow;
                        // ̾󤫤
                        if (prev == null) {
                            rowChain = cell;
                        } else {
                            prev.nextRow = cell;
                        }
                        // Υ
                        if (cell != null) {
                            last.nextRow = null;
                            continue;
                        }
                        break;
                    }
                    if ((cell = (prev = cell).nextRow) == null) {
                        break;
                    }
                }
                // RowSpan Ϣ
                int c, r;
                for (r = 0; r < rowNum; r++) {
                    for (c = 0; c < colNum; c++) {
                        if ((cell = cells[r][c]) != null && cell.rowSpan > 0
                                && cell.col == c
                                && (cell.row + cell.rowSpan - 1) == r) {
                            if (top == null) {
                                top = last = cell;
                            } else {
                                last = last.nextRowSpan = cell;
                            }
                        }
                    }
                }
                rowSpanChain = top;
            }

            this.cells  = cells;
        }

        // פʾ򥯥ꥢ
        colSet = null;
        topRow = null;
        curRow = null;

        return super.commitBlock();
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        // ե졼ι⤵
        int minFrameHeight = getFrameHeight(minParentHeight);
        int maxFrameHeight = getFrameHeight(maxParentHeight);

        //// åɤξ
        if (contents.size() == 0) {
            this.minHeight = verticalSpacing + minFrameHeight;
            this.maxHeight = verticalSpacing + maxFrameHeight;
            return;
        }

        // Ҥ analyze Τˡ礭
        minParentHeight -= minFrameHeight;
        maxParentHeight -= maxFrameHeight;

        // ѿȤƷ׻
        int   verticalSpacing = this.verticalSpacing;
        int   colNum          = this.colNum;
        int[] minHeights      = new int[colNum];
        int[] maxHeights      = new int[colNum];
        int[] fixHeights      = new int[colNum];
        int[] perHeights      = new int[colNum];
        int   minHeightSum    = 0;
        int   maxHeightSum    = 0;
        int   preHeightSum    = 0;

        CellBlock cell;
        int       c, min, max, fix, per;

        //// Ϣ뤷ƤʤκǾ⡢⡢侩
        cell = colChain;
        do {
            cell.analyze(minParentHeight, maxParentHeight);
            c = cell.col;
            minHeights[c] = Math.max(minHeights[c], cell.min);
            maxHeights[c] = Math.max(maxHeights[c], cell.max);
            fixHeights[c] = Math.max(fixHeights[c], cell.fix);
            perHeights[c] = Math.max(perHeights[c], cell.per);
        } while ((cell = cell.nextCol) != null);

        //// Ϣ뤬ͭ˺Ǿ⡢⡢侩⡢ѡȤ򿶤ʬ
        if ((cell = colSpanChain) != null) {
            int space, start, end, perNum;
            do {
                cell.analyze(minParentHeight, maxParentHeight);

                perNum = cell.colSpan;         // ѡȤꤵƤ
                space  = (perNum - 1) * verticalSpacing; // ֤Υڡ
                start  = cell.col;
                end    = start + perNum - 1;
                min    = cell.min - space;
                max    = cell.max - space;
                per    = cell.per;

                // Ϣ뤵Ƥ򽸷
                for (c = start; c <= end; c++) {
                    min -= minHeights[c];
                    max -= maxHeights[c];
                    if (perHeights[c] > 0) {
                        per -= perHeights[c];
                        perNum--;
                    }
                }

                // ʬδˤʤΤǡֺǽ
                if (max > 0) {
                    divideColSpan(start, end, max, maxHeights,
                                  perHeights, maxHeights, fixHeights);
                }

                // Ǿι⤵
                if (min > 0) {
                    divideColSpan(start, end, min, minHeights,
                                  perHeights, maxHeights, fixHeights);
                }

                // ѡȤƤѡȻξʤ
                if (per > 0 && perNum > 0) {
                    divideColSpan(start, end, per, perHeights, maxHeights);
                }
            } while ((cell = cell.nextColSpan) != null);
        }

        //// ѡȤνסͤȸͤνǾͤνפԤ
        per = 0;                            // ѡȤ 1 ʾ 100% ĶޤǤΥο
        max = 0;                            // ѡȤꤵƤʤ max ι
        // ѡȤλȡѡ̤κιפ
        for (c = 0; c < colNum; c++) {
            // ѡȤꤵƤ硢פԤ
            if (perHeights[c] > 0) {
                if (preHeightSum < 100) {
                    per++;
                    preHeightSum += perHeights[c];

                    // ǸΥ 100% Ķ硢100% ˼ޤ褦˽
                    if (preHeightSum > 100 && c + 1 == colNum) {
                        int diff = preHeightSum - 100;
                        preHeightSum  -= diff;
                        perHeights[c] -= diff;
                    }
                } else {
                    preHeightSum += perHeights[c];
                }
            } else {
                max += maxHeights[c];
            }

            /*
             * // MozillaͤꤵƤκͤϡ
             * // Ǿͤͤ礭ۤˤʤ
             * if (fixHeights[c] > 0) {
             *     maxHeights[c] = fixHeights[c]
             *                   = Math.max(minHeights[c], fixHeights[c]);
             * }
             */

            // Ǿͤν
            minHeightSum += minHeights[c];
        }

        //// ѡȤλ꤬ĤǤ⤢硢Ƥ˥ѡȤ
        if (preHeightSum > 0) {
            this.hasPercent = true;

            /*
             * 1. 100% ʤϡ% ꤷƤʤоݤˡ
             *    㤷ʬۤ롣% ꤷƤʤ󤬤ʤϡ
             *    פ 100% ʤޤޤȤʤ롣
             * 2. ǸΥǹפ 100% Ķ硢Υ 100% 
             *    ޤ褦ĴʾǹԤäƤˡ
             * 3. ơ֥륵ϡƥ %  100% ˤ硢
             *    Ǥ⹭Ȥʤ롣100% ʾΥ 100% Ƿ׻롣
             * 4. 0% Υ뤬ĤǤ⤢ϡơ֥륵ϲ̤äѤ
             *    Ȥʤ롣
             */

            if (per < colNum) {
                if (preHeightSum < 100 && max > 0) {
                    // ѡȤλ꤬ξ硢ĤΥѡȤʬۤ
                    preHeightSum = 100 - preHeightSum;
                    int diff;
                    for (c = 0; c < colNum; c++) {
                        if (perHeights[c] == 0 && preHeightSum > 0) {
                            diff          =  preHeightSum * maxHeights[c] / max;
                            max           -= maxHeights[c];
                            perHeights[c] =  diff;
                            preHeightSum  -= diff;
                        }
                        // 100 ѡȤκ
                        maxHeightSum = Math.max(maxHeightSum,
                                                (int) Math.ceil((double) maxHeights[c] * 100 / perHeights[c]));
                    }
                    preHeightSum = 100;
                } else {
                    // ѡ̤Υι׹⤬ 0max == 0ˤäꡢ
                    // ѡȤιפ 100 ѡȰʾξϡ̤äѤ˹
                    maxHeightSum = maxParentHeight - ((colNum + 1) * verticalSpacing + maxFrameHeight);
                }
            } else {
                // 100 ѡȤκ
                for (c = 0; c < colNum; c++) {
                    maxHeightSum = Math.max(maxHeightSum,
                                            (int) Math.ceil((double) maxHeights[c] * 100 / perHeights[c]));
                }
            }
            // ѡȤ᤿ maxHeightSum  minHeightSum 꾮礬Τ
            maxHeightSum = Math.max(maxHeightSum, minHeightSum);
        } else {
            this.hasPercent = false;

            //// ѡȻ̵ξ硢⡢侩ιפ
            for (c = 0; c < colNum; c++) {
                maxHeightSum += maxHeights[c];

                // 侩ιͤϡ侩⤬ꤵƤʤ
                // Ǿ­ʤˤ layoutBlock 
                // 侩˷׻Ǥ褦ˤʤ -  D
                // ޤ⤬侩礭硢侩
                // Ǿˤʤ
                preHeightSum += ((fix = fixHeights[c]) > 0 && maxHeights[c] <= fix
                                 ? fix
                                 : (fixHeights[c] = minHeights[c]));

            }
        }

        // ѿեɤ᤹
        this.minHeights   = minHeights;
        this.maxHeights   = maxHeights;
        this.preHeights   = (hasPercent ? perHeights : fixHeights);
        this.minHeightSum = minHeightSum;
        this.maxHeightSum = maxHeightSum;
        this.preHeightSum = preHeightSum;

        // ơ֥ι⤵ϡcellspacing ޤबܡϴޤޤʤ
        this.minHeight    = Math.max(gridPreferredHeight, minHeightSum + (colNum + 1) * verticalSpacing + minFrameHeight);
        this.maxHeight    = Math.max(gridPreferredHeight, maxHeightSum + (colNum + 1) * verticalSpacing + maxFrameHeight);
        if (gridPreferredHeight >= 0) {
            this.maxHeight = Math.max(this.minHeight, Math.min(this.maxHeight, gridPreferredHeight));
        }

//Debug.out.println(this + ":GridBlock.analyze: " + minHeight + "," + maxHeight + " : minS=" + minHeightSum + ",maxS=" + maxHeightSum + ",preS=" + preHeightSum);
    }

    /** {@inheritDoc} */
    protected void layoutBlock(int newHeight, int containerX, int containerY) {
//Debug.out.println(this + ":GridBlock.layoutBlock: " + newHeight + "," + minHeight + "," + maxHeight);

        // 륭åʤ褯ȤʪΤߡ
        int           verticalSpacing   = this.verticalSpacing;
        int           horizontalSpacing = this.horizontalSpacing;
        int           colNum            = this.colNum;
        int           rowNum            = this.rowNum;
        CellBlock[][] cells             = this.cells;
        int[]         minHeights        = this.minHeights;
        int[]         maxHeights        = this.maxHeights;
        int[]         preHeights        = this.preHeights;
        int           maxHeightSum      = this.maxHeightSum;

        int[]         curWidths         = new int[rowNum]; // 
        int[]         curHeights        = new int[colNum]; // 
        int[]         curOffsetX        = new int[colNum]; // 󳫻ϰ
        int           sumWidth;             // 륵ι
        int           sumHeight;            // 륵ι׹

        CellBlock cell;
        int       c, r, cur, offset;

        // Ȥ䥻̵֤뤷ι⤵
        newHeight -= verticalSpacing * (colNum + 1) + frameHeight;

        if (hasPercent) {
            //// A. ѡȻ꤬ͭϡͥ
//Debug.out.println(this + ":GridBlock.layoutBlock: mode : A (% base)");

            int minHeightSum = this.minHeightSum;
            int preHeightSum = this.preHeightSum;
            int oddHeight    = newHeight;

            // ١ %  100 Ȥ
            if (preHeightSum > 100) {
                preHeightSum = 100;
            }

            // ǾͰʲ˺ǾͤѤ
            for (c = 0; c < colNum; c++) {
                if (preHeights[c] > 0) {
                    cur = oddHeight * preHeights[c] / preHeightSum;
                    if (cur > minHeights[c]) {
                        continue;
                    }
                    preHeightSum -= preHeights[c];
                }
                cur           =  minHeights[c];
                oddHeight     -= cur;
                minHeightSum  -= cur;
                curHeights[c] =  cur;
            }

            // ѡȤʤ
            if (preHeightSum <= 0) {
                for (c = 0; c < colNum; c++) {
                    if (curHeights[c] != 0) {
                        curHeights[c] = minHeights[c];
                    }
                }
            } else {
                // ѡȤ˽ʬۤ
                for (c = 0; c < colNum; c++) {
                    if (curHeights[c] != 0) {
                        continue;
                    }
//Debug.out.println("per["+c+"]="+preHeights[c]);
                    cur = Math.max(oddHeight * preHeights[c] / preHeightSum,
                                   minHeights[c]);
//Debug.out.println("cur0["+c+"]=( "+cur+"="+oddHeight+"*"+preHeights[c]+"/"+preHeightSum+", " + minHeights[c] + " )");
                    preHeightSum -= preHeights[c];
                    oddHeight    -= cur;
                    minHeightSum -= minHeights[c];

                    // Ĥι⤵Ǿͤ򲼲ä硢Ĥꤹ٤ƺǾͤ
                    if (oddHeight <= minHeightSum) {
                        cur -= minHeightSum - oddHeight;
                        curHeights[c] = cur;
                        while (++c < colNum) {
                            curHeights[c] = minHeights[c];
                        }
                        break;
                    }

                    curHeights[c] =  cur;
                }
            }
            sumHeight = newHeight;

        } else if (maxHeightSum == newHeight) {
            //// B. ơ֥륵Ʊ硢
//Debug.out.println(this + ":GridBlock.layoutBlock: mode : B (use max) : " + maxHeightSum + "," + newHeight);

            for (c = 0; c < colNum; c++) {
                curHeights[c] = maxHeights[c];
            }
            sumHeight = maxHeightSum;

        } else if (maxHeightSum < newHeight) {
            //// C. 礬ơ֥륵꾮ϡ㤷ƹ
//Debug.out.println(this + ":GridBlock.layoutBlock: mode : C (max base) : " + maxHeightSum + "," + newHeight);

            int oddHeight = newHeight;

            if (maxHeightSum > 0) {
                // ̾
                for (c = 0; c < colNum; c++) {
                    cur = oddHeight * maxHeights[c] / maxHeightSum;
                    maxHeightSum  -= maxHeights[c];
                    curHeights[c] =  cur;
                    if ((oddHeight -= cur) == 0) {
                        break;
                    }
                }
            } else {
                // ٤ƤΥ뤬ξ
                for (c = 0; c < colNum; c++) {
                    cur =  oddHeight / (colNum - c);
                    oddHeight     -= cur;
                    curHeights[c] =  cur;
                    if ((oddHeight -= cur) == 0) {
                        break;
                    }
                }
            }
            sumHeight = newHeight;

        } else if (preHeightSum <= newHeight) {
            //// D. ơ֥륵侩ʺǾˤ礭硢
            ////    侩١ˤơ˶Ť褦㤷ƹ
//Debug.out.println(this + ":GridBlock.layoutBlock: mode : D (pre base) : " + preHeightSum + "," + newHeight);

            // IE#{
            // 侩ͤˤơˤƹ
            divideHeight(maxHeightSum, newHeight, curHeights, preHeights, maxHeights);
            // }#IE

            /*
             * // Mozilla width 깭ʤå
             * // 侩ŬѤξ

             * int oddHeight = newHeight;

             * for (c = 0; c < colNum; c++) {
             *     if ((curHeights[c] = preHeights[c]) == 0) {
             *         sumMax += maxHeights[c];
             *     } else {
             *         oddHeight -= curHeights[c];
             *     }
             * }

             * // ˤƹ
             * divideHeight(sumMax, oddHeight, curHeights, minHeights, maxHeights);
             */
            sumHeight = newHeight;

        } else {
            //// E. ơ֥륵侩꾮Ǿ礭硢
            ////    Ǿ١ˤơ侩˶Ť褦㤷ƹ
//Debug.out.println(this + ":GridBlock.layoutBlock: mode : E (to pre) : " + newHeight + "," + preHeightSum);

            // 侩ˤƹ
            divideHeight(preHeightSum, newHeight, curHeights, minHeights, preHeights);
            sumHeight = newHeight;
        }

        //// ΥեåȤ
        offset = verticalSpacing;
        for (c = 0; c < colNum; c++) {
//Debug.out.println(this + ":GridBlock.layoutBlock: heights[" + c + "]=" + curHeights[c]);
            curOffsetX[c] = offset;
            offset += (curHeights[c] + verticalSpacing);
        }

        //// Ϣ뤵ƤʤԤ˹⤵ŬѤ
        cell = rowChain;
        while (cell != null) {
            r = cell.row;
            curWidths[r] = Math.max(curWidths[r],
                                    cell.validateHeight(curHeights,
                                                        verticalSpacing,
                                                        curOffsetX[cell.col]));
            cell = cell.nextRow;
        }

        //// Ϣ뤵ƤԤ˹⤵ŬѤ
        if ((cell = rowSpanChain) != null) {
            int start, end, all;
            do {
                r     = cell.rowSpan;
                start = cell.row;
                end   = start + r - 1;
                /*
                 * ʤ顢cur Ϥʤ all ⥻֥ڡ
                 * Ʒ׻٤ǤMozilla ϤƤˡ
                 * IE Ϥɤ all ϰˡ
                 * cur Τ߰Ƥ褦
                 * ϡϢԤʬۤ㤵줺
                 * ǲԤʥ֥ڡʬ
                 * 뤳Ȥ¬Ǥ롣
                 * IE ξΥСǤΥХ
                 * ǽϤ롣
                 */
                // IE#{
                all   = cell.validateHeight(curHeights,
                                            verticalSpacing,
                                            curOffsetX[cell.col]);
                cur   = all - ((r - 1) * horizontalSpacing);
                // }#IE
                /*
                 * // Mozillaall 
                 * all   = cell.validateHeight(curHeights,
                 *                             verticalSpacing,
                 *                             curOffsetX[cell.col])
                 *       - ((r - 1) * horizontalSpacing);
                 * cur   = all;
                 */

                // Ϣ뤵ƤԤ򽸷
                for (r = start; r <= end; r++) {
                    cur -= curWidths[r];
                }

                // 
                if (cur > 0) {
                    divideRowSpan(start, end, all, cur, curWidths);
                }
            } while ((cell = cell.nextRowSpan) != null);
        }

        //// ٤ƤΥФŬѤ
        offset   = horizontalSpacing;
        sumWidth = 0;
        for (r = 0; r < rowNum; r++) {
//Debug.out.println(this + ":GridBlock.layoutBlock: widths[" + r + "]=" + curWidths[r]);
            for (c = 0; c < colNum; c++) {
                if ((cell = cells[r][c]) == null || cell.col != c || cell.row != r) {
                    continue;
                }

                cell.validateWidth(curWidths, horizontalSpacing, offset);
            }
            sumWidth += curWidths[r];
            offset   += (curWidths[r] + horizontalSpacing);
        }

        width      = sumWidth  + horizontalSpacing * (rowNum + 1);
        height     = sumHeight + verticalSpacing   * (colNum + 1);
        bottom     = top   + height + frameHeight;
        left       = right + width  + frameWidth;
        drawTop    = top;
        drawRight  = right;
        drawBottom = bottom;
        drawLeft   = left;
//Debug.out.println(this + ":GridBlock.layoutBlock: commit=[" + width + "x" + height + "],[" + top + "," + right + "," + bottom + "," + left + "]");
    }

    /**
     * ⤵֤ޤ
     * <p>
     * Υ᥽åɤϤĤǤѤǤޤ
     *
     * @param  parentHeight ƥ֥åʪι⤵
     *
     * @return ⤵
     */
    int getHeight(int parentHeight) {
        return Math.max(minHeight,
                        (gridPreferredHeight >= 0
                         ? Math.min(gridPreferredHeight
                                    + getMargin(parentHeight, MARGIN_TOP)
                                    + getMargin(parentHeight, MARGIN_BOTTOM),
                                    parentHeight)
                         : (gridPreferredHeight == SIZE_PERCENT
                            ? ((parentHeight * status.height.getNumber().intValue()) / 100)
                            : Math.min(parentHeight, maxHeight))));
    }

//### ơ֥
    /** {@inheritDoc} */
    public void commitRow() {
        if (lastCellBlock != null) {
            lastCellBlock.isVertical = false;
        }

        // Կ򽸷
        rowNum++;
        colNum =  Math.max(colNum, curRow.size);
        curRow =  curRow.next();
    }

    /** Ϣι⤵ʬ */
    private void divideColSpan(int start, int end, int odd, int[] heights,
                               int[] perHeights, int[] maxHeights, int[] fixHeights) {
        int sumHeight  = odd;
        int sumMaxAll  = 0;
        int sumMaxPart = 0;
        boolean existsNoPer = false;
        int diff;

        // 1-1. % ιͤ򽸷
        for (int i = end; i >= start; i--) {
            sumHeight += heights[i];
            if (perHeights[i] > 0) {
                sumMaxAll  += perHeights[i];
            } else {
                sumMaxPart += maxHeights[i];
                existsNoPer = true;
            }
        }

        // 1-2. % ꤵƤϡ% ˤʬ
        if (sumMaxAll > 0) {
            if (sumMaxAll >= 100) {
                // % ꤵƤ 100 ĶƤ
                sumMaxAll = 100;
                for (int i = end; i >= start; i--) {
                    if (perHeights[i] > 0) {
                        diff       =  Math.max(sumHeight * Math.min(perHeights[i], sumMaxAll) / sumMaxAll, heights[i]);
                        sumMaxAll  -= perHeights[i];
                        heights[i] =  diff;
                        // perHeights  0 Υ뤬ꤨΤ
                        if ((sumHeight -= diff) == 0) {
                            return;
                        }
                    }
                }
            } else if (!existsNoPer) {
                // ٤Ƥ % ꤵƤ
                for (int i = end; i >= start; i--) {
                    diff       =  Math.max(sumHeight * perHeights[i] / sumMaxAll, heights[i]);
                    sumMaxAll  -= perHeights[i];
                    heights[i] =  diff;
                    // perHeights  0 Υ뤬ꤨΤ
                    if ((sumHeight -= diff) == 0) {
                        return;
                    }
                }
            } else {
                //  % ꤵƤ 100 ̤ξ
                sumMaxAll = 100;
                for (int i = end; i >= start; i--) {
                    if (perHeights[i] > 0) {
                        diff       =  Math.max(sumHeight * perHeights[i] / sumMaxAll, heights[i]);
                        sumMaxAll  -= perHeights[i];
                        heights[i] =  diff;
                        sumHeight  -= diff;
                    }
                }
                if (sumMaxPart > 0) {
                    // % ꤵƤʤκͤ㤷ʬ
                    for (int i = end; i >= start; i--) {
                        if (perHeights[i] == 0) {
                            diff       =  Math.max(sumHeight * maxHeights[i] / sumMaxPart, heights[i]);
                            sumMaxPart -= maxHeights[i];
                            heights[i] =  diff;
                            // maxHeights  0 Υ뤬ꤨΤ
                            if ((sumHeight -= diff) == 0) {
                                return;
                            }
                        }
                    }
                } else {
                    // Ƭʬ
                    for (int i = end; i >= start; i--) {
                        if (perHeights[i] == 0) {
                            heights[i] = Math.max(sumHeight, heights[i]);
                            return;
                        }
                    }
                }
            }
            return;
        }

        sumMaxAll  = 0;
        sumMaxPart = 0;

        // 1. ͤꤵƤʤȤκͤ򽸷
        for (int i = end; i >= start; i--) {
            if (fixHeights[i] == 0) {
                sumMaxPart += maxHeights[i];
            } else {
                // ǤͤꤵƤʤСsumMaxAll ϻȤʤ
                sumMaxAll  += maxHeights[i];
            }
        }

        if (sumMaxPart > 0) {
            // 2-1. ͤꤵƤʤȤˡͤ㤷ʬ

            for (int i = end; i >= start; i--) {
                if (fixHeights[i] == 0) {
                    diff       =  odd * maxHeights[i] / sumMaxPart;
                    sumMaxPart -= maxHeights[i];
                    heights[i] += diff;
                    // maxHeights  0 Υ뤬ꤨΤ
                    if ((odd -= diff) == 0) {
                        return;
                    }
                }
            }
            return;
        }

        if (sumMaxAll > 0) {                // ơ֥뤬ĤϢ륻ξ 0 ꤨ
            // 2-2. ٤Ƥ˸ͤꤵƤϡΤФƺͤ㤷ʬ

            // Ǹ -> (Ƭ + 1)
            for (int i = end; i > start; i--) {
                diff       =  odd * maxHeights[i] / sumMaxAll;
                sumMaxAll  -= maxHeights[i];
                heights[i] += diff;
                // maxHeights  0 Υ뤬ꤨΤ
                if ((odd -= diff) == 0) {
                    return;
                }
            }

        } else {
            // 2-3. ٤Ƥ 0 ξ硢ʬ

            sumMaxAll = end - start + 1;
            for (int i = end; i > start; i--) {
                diff       =  odd / sumMaxAll;
                heights[i] += diff;
                odd        -= diff;
                sumMaxAll--;
            }
        }

        // Ƭ
        heights[start] += odd;
    }

    /** Ϣι⤵Υѡͤʬ */
    private void divideColSpan(int start, int end, int odd,
                               int[] perHeights, int[] maxHeights) {
        int diff;
        int sum = 0;                        // ι
        int i;

        // ѡȤ̤κιפ
        for (i = end; i >= start; i--) {
            if (perHeights[i] == 0) {
                sum += maxHeights[i];
            }
        }

        // Ǹ -> (Ƭ + 1)
        for (i = end; i > start; i--) {
            if (perHeights[i] == 0) {
                diff          =  odd * maxHeights[i] / sum;
                sum           -= maxHeights[i];
                perHeights[i] =  diff;
                // maxHeights  0 Υ뤬ꤨΤ
                if ((odd -= diff) == 0) {
                    return;
                }
            }
        }
        // Ƭ
        if (perHeights[start] == 0) {
            perHeights[start] += odd;
        }
    }

    /** ϢԤʬ */
    private void divideRowSpan(int start, int end, int all, int odd, int[] widths) {
        int diff;
        int sum = all - odd;                // ʬۺѤߤι

        // ϢоݹԤΡġιԤ٤ 0 ξ
        if (sum == 0) {
            sum = end - start + 1;
            // Ƭ -> (Ǹ - 1)
            for (int i = start; i < end; i++) {
                diff      =  odd / sum;
                widths[i] += diff;
                odd       -= diff;
                sum--;
            }
        } else {
            // Ƭ -> (Ǹ - 1)
            for (int i = start; i < end; i++) {
                diff      =  odd * widths[i] / sum;
                sum       -= widths[i];
                widths[i] += diff;
                // widths  0 Υ뤬ꤨΤ
                if ((odd -= diff) == 0) {
                    return;
                }
            }
        }
        // Ǹ
        widths[end] += odd;
    }

    /**
     * γ˽oddHeight ʬʬۤޤ
     * curHeights ꤵƤʤȤˤΤʬۤޤ
     * maxHeights γ˽ʬۤޤη
     * minHeights 򲼲ä硢minHeights ͤͥ褵ޤ
     * äơξ硢¾ʬۤʤʤޤ
     *
     * <pre>
     * sumMax    = 160
     * oddHeight =  40
     * +---+---+---+---+---+---+---+
     * |   |min|max|cur|ng1|ng2| ok|
     * +---+---+---+---+---+---+---+
     * |1| 10|120|   | 60| 40| 50|
     * |2| 30| 40|   | 20| 40| 30|
     * +---+---+---+---+---+---+---+
     * </pre>
     *
     * ȡoddHeight + min ιפ maxHeights 㤷ʬۤ
     * ng1 ˡoddHeight  maxHeights 㤷 min ­ ng2 
     * ʤäƤޤޤ
     * ºݤ minHeights ʲˤϤʤʤΤǡok ˤʤޤ
     *
     * @param  sumMax     ʬоκͤι
     * @param  oddHeight  ʬۤɬפΤ
     * @param  curHeights 
     * @param  minHeights 
     * @param  maxHeights Ǿ
     */
    private void divideHeight(int sumMax, int oddHeight, int[] curHeights,
                              int[] minHeights, int[] maxHeights) {
        boolean exists;
        int     c, sum, odd, cur;

        // 1. ǾͤŬѤꤹ뤿ᡢ
        //    Ǿͤ꾮ͤʤʤޤǥ롼
        do {
            exists = false;
            sum    = sumMax;
            odd    = oddHeight;
            for (c = 0; c < colNum; c++) {
                // ޤ̤Τо
                if (curHeights[c] == 0) {
                    cur = odd * maxHeights[c] / sum;

                    // ͤǾͤ꾮ʤä硢Ǿͤͥ
                    if (cur < minHeights[c]) {
//Debug.out.println("cur1["+c+"]=(" + cur + " = " + odd + " * " + maxHeights[c] + " / " + sum + ", " + minHeights[c]);
                        sumMax        -= maxHeights[c];
                        oddHeight     -= minHeights[c];
                        curHeights[c] =  minHeights[c];
                        exists        =  true;
                    }

                    sum -= maxHeights[c];
                    if ((odd -= cur) == 0) {
                        break;
                    }
                }
            }
        } while (exists);

        // 2. Ĥ̤ʬ
        for (c = 0; c < colNum; c++) {
            // ޤ̤Τо
            if (curHeights[c] == 0) {
                cur           =  oddHeight * maxHeights[c] / sumMax;
//Debug.out.println("cur2["+c+"]=(" + cur + " = " + oddHeight + " * " + maxHeights[c] + " / " + sumMax + ")");
                sumMax        -= maxHeights[c];
                curHeights[c] =  cur;
                if ((oddHeight -= cur) == 0) {
                    return;
                }
            }
        }
    }
}
