/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.table;

import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.block.Block;
import net.hizlab.kagetaka.rendering.block.ContainerBlock;
import net.hizlab.kagetaka.rendering.block.FloatManager;
import net.hizlab.kagetaka.token.Value;

/**
 * ơ֥륻Υ֥åǤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
class CellBlock extends ContainerBlock {

    /** Ϣ뤵Ƥʤ֥å */
    CellBlock nextCol;
    /** ιϢ뤵Ƥʤ֥å */
    CellBlock nextRow;
    /** Ϣ륻֥å */
    CellBlock nextColSpan;
    /** ιϢ륻֥å */
    CellBlock nextRowSpan;
    /** Υ뤬³ */
    boolean   isVertical;

    /**  0- */
    int       col;
    /** Ϲ 0- */
    int       row;
    /** Ϣ 1- */
    int       colSpan;
    /** Ϣ 1- */
    int       rowSpan;

    /** Ǿ⤵ʥե졼ޤ */
    int       min;
    /** ⤵ʥե졼ޤ */
    int       max;
    /** 侩⤵ʥե졼ޤ */
    int       fix;
    /** ѡ */
    int       per;

    private int fixHeight;                  // ꤵ줿⤵preferredHeight ǥե졼ϴޤޤʤ
    private int contentWidth;               // *Ǥvalign ѡ

    /**
     * ֥åޤ
     *
     * @param  drawkit ɥå
     * @param  status  ơ
     * @param  parent  ƥ֥å
     */
    CellBlock(Drawkit drawkit, Status status, Block parent) {
        super(drawkit, status, parent);

        this.isVertical = true;
        this.colSpan    = status.colSpan;
        this.rowSpan    = status.rowSpan;
    }

    /**
     * ֹֹꤷޤ
     *
     * @param  col ֹ
     * @param  row ֹ
     */
    void setPosition(int col, int row) {
        this.col = col;
        this.row = row;
    }

    /** {@inheritDoc} */
    protected void calculatePreferred() {
        //### TODO % ꤬ԲĤʤΤǡб
        preferredWidth  = (status.width  == null
                           ? SIZE_AUTO
                           : (status.width .getUnit() == Value.UNIT_PERCENT
                              ? SIZE_AUTO
                              : status.width .getValue(1, 0,
                                                       status.fontData,
                                                       Value.DATA_HORIZONTAL)));
        // ⤵ GridBlock ˤꥳȥ뤵Τ SIZE_NONE
        // ͤ per%ˡfixHeightʸ͡ 
        preferredHeight = SIZE_NONE;
        if (status.height != null) {
            if (status.height.getUnit() == Value.UNIT_PERCENT) {
                // IE#{
                this.per       = Math.max(status.height.getNumber().intValue(), 0);
                // }#IE
                /*
                 * // Mozilla% κ 100
                 * this.per       = Math.min(Math.max(status.height.getNumber().intValue(), 0), 100);
                 */
            } else {
                this.fixHeight = status.height.getValue(1, 0,
                                                        status.fontData,
                                                        Value.DATA_VERTICAL);
            }
        }
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        int lowerHeight = 0;

        // եȤ¸ߤ硢ǾΤߵƤ
        if (floatBlocks != null) {
            Block block;
            for (int i = floatBlocks.size() - 1; i >= 0; i--) {
                block = (Block) floatBlocks.elementAt(i);
                block.analyze(minParentHeight, maxParentHeight);
                lowerHeight = Math.max(lowerHeight, block.minHeight);
            }
        }

        /*
         * κǾϡ侩ʤ
         * ʺΥ % ιפ 100 Ķ硢
         *   width ̵꤬뤵 min ޤǽ̤ǽ뤿
         */
        analyze(minParentHeight, maxParentHeight, lowerHeight);

        /*
         * ǥե졼򻻽ФƤޤ
         * ϥѥǥ󥰤 % ꤵƤ
         * Ǿ˻ФʤȻפ
         * ʤʤ顢 % δͤǤʤ
         * ʿƤꤷʤ¤ѥǥ󥰤 % ϳǤʤ
         *   Ҥꤷʤ¤ơ֥륵ޤʤ
         * IE  Mozilla Ǥϡư㤦
         */
        calculateFrame(minHeight);

        // ꤵƤϡ祵ꥵˤ
        this.min = minHeight;

        if (fixHeight > 0) {
            this.max = this.fix = Math.max(fixHeight + frameHeight, min);
            maxHeight = Math.max(maxHeight, max);
        } else {
            this.max = maxHeight;
        }
//Debug.out.println(this + ":CellBlock.analyze: " + min + "," + max + "," + fix);
    }

    /** {@inheritDoc} */
    public void validate(int parentHeight, int prevLeftMargin, int x, int y,
                         int containerX, int containerY) {
//Debug.out.println(this + ":CellBlock.validate: " + parentHeight + "," + prevLeftMargin + "," + x + "," + y + "," + minHeight + "," + maxHeight);
        // եȥޥ͡
        if (floatBlocks != null) {
            floatManager = new FloatManager(0, parentHeight);
        }

        int newHeight;

        // ֤򻻽
        this.top = y;

        // ι⤵׻
        newHeight = (parentHeight >= minHeight ? parentHeight : minHeight)
                  - frameHeight;

        // ⤵¸
        this.height = newHeight;

        // 
        layoutBlock(newHeight, 0, 0);

        // եȤäƤ硢եȤ꤭褦礭Ĵ
        adjustInnerFloat();

        // Ƥ¸valign ѡ
        this.contentWidth = width;
//Debug.out.println(this + ":Block.validate2: " + width + "x" + height + ", " + top + "," + right + "," + bottom + "," + left);
    }

    /**
     * ֥å˹⤵ŬѤޤ
     *
     * @param  heights ι⤵
     * @param  space   ֥ڡ
     * @param  y       Y 
     *
     * @return ʥܡѥǥ󥰡֥ڡޤ
     */
    int validateHeight(int[] heights, int space, int y) {
        int newHeight = heights[col];
        // Ϣ륻ι⤵
        if (colSpan > 1) {
            newHeight += (colSpan - 1) * space;
            int colEnd = col + colSpan - 1;
            for (int i = col + 1; i <= colEnd; i++) {
                newHeight += heights[i];
            }
        }

//Debug.out.println(this+":CellBlock.validateHeight1: " + newHeight + "," + y);
        validate(newHeight, 0, 0, y, 0, 0);
//Debug.out.println(this+":CellBlock.validateHeight2: " + newHeight + "," + y + " -> " + (height + frameHeight) + "," + (width + frameWidth));
        return width + frameWidth;
    }

    /**
     * ֥åŬѤޤ
     *
     * @param  widths ΰ
     *                ʥܡѥǥ󥰡֥ڡޤ
     * @param  space  ֥ڡ
     * @param  x      X 
     */
    void validateWidth(int[] widths, int space, int x) {
        int newWidth = widths[row];
        // Ϣ륻
        if (rowSpan > 1) {
            newWidth += (rowSpan - 1) * space;
            int rowEnd = row + rowSpan - 1;
            for (int i = row + 1; i <= rowEnd; i++) {
                newWidth += widths[i];
            }
        }

//Debug.out.println(this+":CellBlock.validateWidth: " + newWidth + "," + x);
        this.width     = newWidth - frameWidth;
        this.drawRight = this.right = x;
        this.drawLeft  = this.left  = x + newWidth;
//Debug.out.println("pos="+top+","+right+","+bottom+","+left);
    }

    /** {@inheritDoc} */
    protected void drawContent(Canvas canvas, int x, int y) {
        // ·
        switch (status.valign) {
        case Value.VALIGN_BOTTOM: x -= (width - contentWidth);     break;
        case Value.VALIGN_TOP   : break;
        default                 : x -= (width - contentWidth) / 2; break;
        }

        super.drawContent(canvas, x, y);
    }
}
