/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.table;

import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.block.Block;
import net.hizlab.kagetaka.rendering.block.ContainerBlock;
import net.hizlab.kagetaka.rendering.block.FloatManager;
import net.hizlab.kagetaka.token.Value;

/**
 * ơ֥Υץ֥åǤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
class CaptionBlock extends ContainerBlock {
    /**
     * ץ֥åޤ
     *
     * @param  drawkit ɥå
     * @param  status  ơ
     * @param  parent  ƥ֥å
     */
    CaptionBlock(Drawkit drawkit, Status status, Block parent) {
        super(drawkit, status, parent);

        this.isAdoptee = true;
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        // ե졼򻻽СRIGHT or LEFT ץɬǾˤʤ
        switch (status.captionSide) {
        case Value.ALIGN_LEFT:
        case Value.ALIGN_RIGHT:
            calculateFrame(minParentHeight);
            break;
        default: // AVOID
        }

        super.analyze(minParentHeight, maxParentHeight);
    }

    /** {@inheritDoc} */
    public void validate(int parentHeight, int prevLeftMargin, int x, int y,
                         int containerX, int containerY) {
        // եȥޥ͡
        if (floatBlocks != null) {
            floatManager = new FloatManager(0, parentHeight);
        }

        super.validate(parentHeight, prevLeftMargin, x, y, containerX, containerY);

        // եȤäƤ硢եȤ꤭褦礭Ĵ
        adjustInnerFloat();
    }
}
