/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.style;

import net.hizlab.kagetaka.awt.Transparent;
import net.hizlab.kagetaka.token.AttributeConverter;

import java.awt.Color;
import java.net.URL;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * CSS 礭ɽץѥƥͤǼ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.6 $
 */
class Value extends net.hizlab.kagetaka.token.Value {
    private static Hashtable keywords = new Hashtable();
    private static Hashtable units    = new Hashtable();
    static {
        keywords.put("inherit"             , new Integer(TYPE_KEY_INHERIT             ));
        keywords.put("normal"              , new Integer(TYPE_KEY_NORMAL              ));
        keywords.put("none"                , new Integer(TYPE_KEY_NONE                ));
        keywords.put("hidden"              , new Integer(TYPE_KEY_HIDDEN              ));
        keywords.put("dotted"              , new Integer(TYPE_KEY_DOTTED              ));
        keywords.put("dashed"              , new Integer(TYPE_KEY_DASHED              ));
        keywords.put("solid"               , new Integer(TYPE_KEY_SOLID               ));
        keywords.put("double"              , new Integer(TYPE_KEY_DOUBLE              ));
        keywords.put("groove"              , new Integer(TYPE_KEY_GROOVE              ));
        keywords.put("ridge"               , new Integer(TYPE_KEY_RIDGE               ));
        keywords.put("inset"               , new Integer(TYPE_KEY_INSET               ));
        keywords.put("outset"              , new Integer(TYPE_KEY_OUTSET              ));
        keywords.put("thin"                , new Integer(TYPE_KEY_THIN                ));
        keywords.put("medium"              , new Integer(TYPE_KEY_MEDIUM              ));
        keywords.put("thick"               , new Integer(TYPE_KEY_THICK               ));
        keywords.put("left"                , new Integer(TYPE_KEY_LEFT                ));
        keywords.put("right"               , new Integer(TYPE_KEY_RIGHT               ));
        keywords.put("center"              , new Integer(TYPE_KEY_CENTER              ));
        keywords.put("justify"             , new Integer(TYPE_KEY_JUSTIFY             ));
        keywords.put("both"                , new Integer(TYPE_KEY_BOTH                ));
        keywords.put("baseline"            , new Integer(TYPE_KEY_BASELINE            ));
        keywords.put("sub"                 , new Integer(TYPE_KEY_SUB                 ));
        keywords.put("super"               , new Integer(TYPE_KEY_SUPER               ));
        keywords.put("top"                 , new Integer(TYPE_KEY_TOP                 ));
        keywords.put("text-top"            , new Integer(TYPE_KEY_TEXT_TOP            ));
        keywords.put("middle"              , new Integer(TYPE_KEY_MIDDLE              ));
        keywords.put("bottom"              , new Integer(TYPE_KEY_BOTTOM              ));
        keywords.put("text-bottom"         , new Integer(TYPE_KEY_TEXT_BOTTOM         ));
        keywords.put("pre"                 , new Integer(TYPE_KEY_PRE                 ));
        keywords.put("nowrap"              , new Integer(TYPE_KEY_NOWRAP              ));
        keywords.put("xx-small"            , new Integer(TYPE_KEY_XX_SMALL            ));
        keywords.put("x-small"             , new Integer(TYPE_KEY_X_SMALL             ));
        keywords.put("small"               , new Integer(TYPE_KEY_SMALL               ));
        keywords.put("large"               , new Integer(TYPE_KEY_LARGE               ));
        keywords.put("x-large"             , new Integer(TYPE_KEY_X_LARGE             ));
        keywords.put("xx-large"            , new Integer(TYPE_KEY_XX_LARGE            ));
        keywords.put("smaller"             , new Integer(TYPE_KEY_SMALLER             ));
        keywords.put("larger"              , new Integer(TYPE_KEY_LARGER              ));
        keywords.put("serif"               , new Integer(TYPE_KEY_SERIF               ));
        keywords.put("sans-serif"          , new Integer(TYPE_KEY_SANS_SERIF          ));
        keywords.put("cursive"             , new Integer(TYPE_KEY_CURSIVE             ));
        keywords.put("fantasy"             , new Integer(TYPE_KEY_FANTASY             ));
        keywords.put("monospace"           , new Integer(TYPE_KEY_MONOSPACE           ));
        keywords.put("oblique"             , new Integer(TYPE_KEY_OBLIQUE             ));
        keywords.put("italic"              , new Integer(TYPE_KEY_ITALIC              ));
        keywords.put("bold"                , new Integer(TYPE_KEY_BOLD                ));
        keywords.put("bolder"              , new Integer(TYPE_KEY_BOLDER              ));
        keywords.put("lighter"             , new Integer(TYPE_KEY_LIGHTER             ));
        keywords.put("disc"                , new Integer(TYPE_KEY_DISC                ));
        keywords.put("circle"              , new Integer(TYPE_KEY_CIRCLE              ));
        keywords.put("square"              , new Integer(TYPE_KEY_SQUARE              ));
        keywords.put("decimal"             , new Integer(TYPE_KEY_DECIMAL             ));
        keywords.put("decimal-leading-zero", new Integer(TYPE_KEY_DECIMAL_LEADING_ZERO));
        keywords.put("lower-roman"         , new Integer(TYPE_KEY_LOWER_ROMAN         ));
        keywords.put("upper-roman"         , new Integer(TYPE_KEY_UPPER_ROMAN         ));
        keywords.put("hebrew"              , new Integer(TYPE_KEY_HEBREW              ));
        keywords.put("georgian"            , new Integer(TYPE_KEY_GEORGIAN            ));
        keywords.put("armenian"            , new Integer(TYPE_KEY_ARMENIAN            ));
        keywords.put("cjk-ideographic"     , new Integer(TYPE_KEY_CJK_IDEOGRAPHIC     ));
        keywords.put("hiragana"            , new Integer(TYPE_KEY_HIRAGANA            ));
        keywords.put("katakana"            , new Integer(TYPE_KEY_KATAKANA            ));
        keywords.put("hiragana-iroha"      , new Integer(TYPE_KEY_HIRAGANA_IROHA      ));
        keywords.put("katakana-iroha"      , new Integer(TYPE_KEY_KATAKANA_IROHA      ));
        keywords.put("lower-latin"         , new Integer(TYPE_KEY_LOWER_LATIN         ));
        keywords.put("upper-latin"         , new Integer(TYPE_KEY_UPPER_LATIN         ));
        keywords.put("lower-alpha"         , new Integer(TYPE_KEY_LOWER_ALPHA         ));
        keywords.put("upper-alpha"         , new Integer(TYPE_KEY_UPPER_ALPHA         ));
        keywords.put("lower-greek"         , new Integer(TYPE_KEY_LOWER_GREEK         ));
        keywords.put("inside"              , new Integer(TYPE_KEY_INSIDE              ));
        keywords.put("outside"             , new Integer(TYPE_KEY_OUTSIDE             ));
        keywords.put("yes"                 , new Integer(TYPE_KEY_YES                 ));
        keywords.put("auto"                , new Integer(TYPE_KEY_AUTO                ));
        keywords.put("no"                  , new Integer(TYPE_KEY_NO                  ));
        keywords.put("inline"              , new Integer(TYPE_KEY_INLINE              ));
        keywords.put("block"               , new Integer(TYPE_KEY_BLOCK               ));
        keywords.put("list-item"           , new Integer(TYPE_KEY_LIST_ITEM           ));
        keywords.put("run-in"              , new Integer(TYPE_KEY_RUN_IN              ));
        keywords.put("compact"             , new Integer(TYPE_KEY_COMPACT             ));
        keywords.put("marker"              , new Integer(TYPE_KEY_MARKER              ));
        keywords.put("table"               , new Integer(TYPE_KEY_TABLE               ));
        keywords.put("inline-table"        , new Integer(TYPE_KEY_INLINE_TABLE        ));
        keywords.put("table-row-group"     , new Integer(TYPE_KEY_TABLE_ROW_GROUP     ));
        keywords.put("table-header-group"  , new Integer(TYPE_KEY_TABLE_HEADER_GROUP  ));
        keywords.put("table-footer-group"  , new Integer(TYPE_KEY_TABLE_FOOTER_GROUP  ));
        keywords.put("table-row"           , new Integer(TYPE_KEY_TABLE_ROW           ));
        keywords.put("table-column-group"  , new Integer(TYPE_KEY_TABLE_COLUMN_GROUP  ));
        keywords.put("table-column"        , new Integer(TYPE_KEY_TABLE_COLUMN        ));
        keywords.put("table-cell"          , new Integer(TYPE_KEY_TABLE_CELL          ));
        keywords.put("table-caption"       , new Integer(TYPE_KEY_TABLE_CAPTION       ));
        keywords.put("repeat"              , new Integer(TYPE_KEY_REPEAT              ));
        keywords.put("repeat-x"            , new Integer(TYPE_KEY_REPEAT_X            ));
        keywords.put("repeat-y"            , new Integer(TYPE_KEY_REPEAT_Y            ));
        keywords.put("no-repeat"           , new Integer(TYPE_KEY_NO_REPEAT           ));
        keywords.put("scroll"              , new Integer(TYPE_KEY_SCROLL              ));
        keywords.put("fixed"               , new Integer(TYPE_KEY_FIXED               ));
        keywords.put("underline"           , new Integer(TYPE_KEY_UNDERLINE           ));
        keywords.put("overline"            , new Integer(TYPE_KEY_OVERLINE            ));
        keywords.put("line-through"        , new Integer(TYPE_KEY_LINE_THROUGH        ));
        keywords.put("blink"               , new Integer(TYPE_KEY_BLINK               ));
        keywords.put("transparent"         , new Integer(TYPE_KEY_TRANSPARENT         ));

        units.put("em", new Integer(UNIT_EM));
        units.put("ex", new Integer(UNIT_EX));
        units.put("px", new Integer(UNIT_PX));
        units.put("in", new Integer(UNIT_IN));
        units.put("cm", new Integer(UNIT_CM));
        units.put("mm", new Integer(UNIT_MM));
        units.put("pt", new Integer(UNIT_PT));
        units.put("pc", new Integer(UNIT_PC));
    }

    private static final int[] TYPES_INT_PER = {TYPE_INTEGER, TYPE_PERCENTAGE};

    /**
     * ͤ¿ͥפΥץѥƥͤޤ
     *
     * @param  value 
     * @param  unit  ñ
     */
    public Value(long value, int unit) {
        super(value, unit);
    }

    /**
     * ꤷ s  type ȤƲϤͤ˽줿
     * Value ֥Ȥޤ
     *
     * @param  s ͤɽʸ
     * @param  types ͤΥ
     *
     * @throws ParseException ϤǤʤ
     */
    Value(String s, int[] types)
            throws ParseException {
        if (s == null || s.length() == 0) {
            throw new ParseException(s, 0);
        }

        String ls = s.toLowerCase();

        if (ls.endsWith("!important")) {
            if (ls.length() == 10) {
                throw new ParseException(s, 0);
            }

            super.important = true;
            ls = ls.substring(0, ls.length() - 10);
        }

        char   c = ls.charAt(0);
        Object o;

        // פưȽꤷѴ
        if ((o = keywords.get(ls)) != null) {
            // 
            super.type   = ((Integer) o).intValue();
            super.string = ls;

            if (super.type == TYPE_KEY_TRANSPARENT) {
                // Ʃ
                super.type  = TYPE_COLOR;
                super.color = Transparent.COLOR;
            }
        } else if (('0' <= c && c <= '9') || c == '-') {
            // ͷ

            ParsePosition pp = new ParsePosition(0);
            super.number = toNumber(ls, pp);

            int    index      = pp.getIndex();
            String unitString = ls.substring(index);

            if (unitString.length() == 0) {
                // 
                super.type = TYPE_INTEGER;
            } else if (unitString.compareTo("%") == 0) {
                // ѡȥ
                super.type = TYPE_PERCENTAGE;
                super.unit = UNIT_PERCENT;
            } else if ((o = units.get(unitString)) != null) {
                // Ĺ
                super.type = TYPE_LENGTH;
                super.unit = ((Integer) o).intValue();
            } else {
                throw new ParseException(s, index);
            }
        } else if (c == '"' || c == '\'') {
            // ʸ
            super.type = TYPE_STRING;
            //### BUGS ΰϤߤȡʸΥפCSSParser Ĵ
            super.string = ls;
        } else if (ls.startsWith("url(") && ls.endsWith(")")) {
            // URL
            super.type = TYPE_URL;

            ls = CSSParser.unescape(s, 4, ls.length() - 1, true);
            super.url = ls;
        } else if (ls.startsWith("rgb(") && ls.endsWith(")")) {
            // rgb(r, g, b) 
            super.type = TYPE_COLOR;

            StringTokenizer st = new StringTokenizer(s.substring(4, s.length() - 1), ",");
            Value vr = null, vg = null, vb = null;
            if (st.hasMoreTokens()) { vr = new Value(st.nextToken().trim(), TYPES_INT_PER); }
            if (st.hasMoreTokens()) { vg = new Value(st.nextToken().trim(), TYPES_INT_PER); }
            if (st.hasMoreTokens()) { vb = new Value(st.nextToken().trim(), TYPES_INT_PER); }
            if (vr == null || vg == null || vb == null || st.hasMoreTokens()) {
                throw new ParseException(s, 4);
            }

            super.color = new Color(
                (vr.getUnit() == UNIT_PERCENT ? 0xFF * vr.intValue() / 100 : vr.intValue()),
                (vg.getUnit() == UNIT_PERCENT ? 0xFF * vg.intValue() / 100 : vg.intValue()),
                (vb.getUnit() == UNIT_PERCENT ? 0xFF * vb.intValue() / 100 : vb.intValue())
            );
        } else if ((super.color = AttributeConverter.convertToColorSilent(ls)) != null) {
            // ʿ̾#rrggbb, #rgb 
            super.type = TYPE_COLOR;
        } else {
            // ¾ʸȤƲ
            super.type   = TYPE_STRING;
            super.string = s;
        }

        if (types == null) {
            return;
        }

        // ꤷɤå
        for (int i = 0; i < types.length; i++) {
            if (types[i] == super.type) {
                return;
            }
        }

        // 0 ꤵ줿 0px ȤƥåƤߤ
        if (super.type == TYPE_INTEGER && super.number.intValue() == 0) {
            super.type = TYPE_LENGTH;
            super.unit = UNIT_PX;
            for (int i = 0; i < types.length; i++) {
                if (types[i] == super.type) {
                    return;
                }
            }
        }

        // ꤷǤϤʤä
        throw new ParseException(s, 0);
    }

    /**
     * ꤷ s  type ȤƲϤͤ˽줿
     * Value ֥Ȥޤ
     *  s Ϣ뤵ƲϤޤ
     *
     * @param  s ͤɽʸ
     * @param  types ͤΥ
     *
     * @throws ParseException ϤǤʤ
     */
    Value(String[] s, int[] types)
            throws ParseException {
        this((s.length == 1 ? s[0] : concat(s)), types);
    }

    /**
     * URL פξ֤ͤޤ
     *
     * @param  base ١ URL
     *
     * @return 
     */
    String getURL(URL base) {
        try {
            URL newUrl = new URL(base, url);
            return newUrl.toString();
        } catch (MalformedURLException e) {
        }
        return url;
    }

    /** ͤѴ */
    private static Number toNumber(String s, ParsePosition pp)
            throws ParseException {
        DecimalFormat df = new DecimalFormat("0.#");
        if (pp == null) {
            pp = new ParsePosition(0);
        }

        Number n = df.parse(s, pp);
        if (pp.getIndex() == 0) {
            throw new ParseException(s, 0);
        }

        return n;
    }

    /** ʸϢ */
    private static String concat(String[] s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; i++) {
            sb.append(s[i]);
        }
        return sb.toString();
    }
}
