/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.style;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.token.Value;

/**
 * 륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class StyleManagerFactory
        implements net.hizlab.kagetaka.addin.StyleManagerFactory {

    private static final String RESOURCE = "net.hizlab.kagetaka.addin.style.Resources";

    /**
     * 륯ꥨޤ
     */
    public StyleManagerFactory() {
    }

    /** {@inheritDoc} */
    public net.hizlab.kagetaka.addin.StyleManager create(HawkContext context,
                                                         Document document,
                                                         Request request) {
        return new StyleManager(context, document, request);
    }

//### Utils
    /** {@inheritDoc} */
    public String getListCounter(int type, int count) {
        StringBuffer buffer = new StringBuffer();

        switch (type) {
        case Value.LIST_CJK_IDEOGRAPHIC: //  , , , ...
        {
            String list = Resource.getMessage(RESOURCE, "chars.list.cjk.ideographic", null);
            if (count <= 0) {
                count = 1;
            }
            int n, n4 = 1, nx = 0;
            boolean bx = false;
            for (;;) {
                n = count % 10;
                if (n > 0) {
                    if (nx > 0 && !bx) {
                        buffer.append(list.charAt(nx + 11));
                        bx = true;
                    }
                    if (n4 > 1) {
                        buffer.append(list.charAt(n4 + 7));
                    }
                    buffer.append(list.charAt(n - 1));
                }

                count /= 10;
                if (count == 0) {
                    break;
                }

                if (++n4 == 5) {
                    n4 = 1;
                    nx++;
                    bx = false;
                }
            }
            buffer.reverse();
            buffer.append(Resource.getMessage("chars.value.list.2", null));

            break;
        }
        case Value.LIST_HIRAGANA       : // ʿ̾ ,,,,, ...
        case Value.LIST_KATAKANA       : // Ҳ̾ ,,,,, ...
        case Value.LIST_HIRAGANA_IROHA : // ʿ̾Τ ,,,, ...
        case Value.LIST_KATAKANA_IROHA : // Ҳ̾Τ ,,,, ...
        case Value.LIST_LOWER_GREEK    : // ʸθ奮ꥷʸ
        {
            String key = null;
            switch (type) {
            case Value.LIST_HIRAGANA       : key = "chars.list.hiragana"      ; break;
            case Value.LIST_KATAKANA       : key = "chars.list.katakana"      ; break;
            case Value.LIST_HIRAGANA_IROHA : key = "chars.list.hiragana.iroha"; break;
            case Value.LIST_KATAKANA_IROHA : key = "chars.list.katakana.iroha"; break;
            case Value.LIST_LOWER_GREEK    : key = "chars.list.lower.greek"   ; break;
            default: // AVOID
            }
            String list = Resource.getMessage(RESOURCE, key, null);
            count--;
            if (count < 0) {
                count = 0;
            }
            if (count >= list.length()) {
                return null;
            }
            buffer.append(list.charAt(count));
            buffer.append(Resource.getMessage((type == Value.LIST_LOWER_GREEK
                                               ? "chars.value.list.1"
                                               : "chars.value.list.2"),
                                              null));

            break;
        }
        default:
            return null;
        }

        return buffer.toString();
    }
}
