/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.style;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenTypes;

import java.io.IOException;
import java.util.Vector;

/**
 * 륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class StyleManager
        extends net.hizlab.kagetaka.addin.StyleManager {

    private HawkContext context;
    private Document    document;
    private Content     content;
    private Request     request;

    private Style top  = null;
    private Style last = null;

    /**
     * ޥ͡ޤ
     *
     * @param  context  륳ƥ
     * @param  document ɥ
     * @param  request  ꥯ
     */
    StyleManager(HawkContext context, Document document, Request request) {
        this.context  = context;
        this.document = document;
        this.content  = document.content;
        this.request  = request;
    }

    /** {@inheritDoc} */
    public void addStyle(Content content, Request request)
            throws IOException {
        addStyle(new CSSParser(context, document, content, request));
    }

    /** {@inheritDoc} */
    public void addStyle(Content content, String data) {
        try {
            addStyle(new CSSParser(context, document, content, request, data));
        } catch (IOException e) { }
    }

    /** ɲ */
    private void addStyle(CSSParser parser)
            throws IOException {
        try {
            Style style = null;

            while ((style = parser.next()) != null) {
                addStyle(style);
            }
        } finally {
            parser.close();
        }
    }

    /** ɲ */
    private void addStyle(Style style) {
        //### TODO 쥯ξܺ٤η׻CSS2 6.4.3
        //### TODO ǽ׵§CSS2 6.4.2

        if (top == null) {
            top = last = style;
        } else {
            last = (last.next = style);
        }
    }

    /** {@inheritDoc} */
    public void changeStatus(int media, StartToken token, Status status,
                             int pseudo) {
        Style   style;
        boolean block = TokenTypes.isBlockEx(token.getType());

        if (pseudo == Render.PSEUDO_NONE) {
            // ΤΥŬ
            if (top != null) {
                Selector selector = null;

                style = top;
                do {
                    if (style.isPage() || (style.getMedia() & media) == 0) {
                        continue;
                    }

                    selector = style.getSelector();
                    if (selector == null || selector.isMatch(token, status)) {
                        style.changeStatus(block, status);
                    }
                } while ((style = style.next) != null);
            }

            // ȡ˻ꤵ줿Ŭ
            Attribute attr = token.getAttribute();
            if (attr != null) {
                Object o = attr.getStyle();
                if (o != null) {
                    if (o instanceof Style) {
                        style = (Style) o;
                    } else {
                        style = CSSParser.valueOf(context, content, (String) o);
                        if (style != null) {
                            attr.setStyle(style);
                        }
                    }
                    if (style != null) {
                        style.changeStatus(block, status);
                    }
                }
            }
        } else {
            // 饹ǤΥޥå
            Vector styles = status.pseudoStyles;
            if (styles != null) {
                int size = styles.size();
                for (int i = 0; i < size; i++) {
                    style = (Style) styles.elementAt(i);
                    if (style.getSelector().isMatch(pseudo)) {
                        style.changeStatus(block, status);
                    }
                }
            }
        }
    }
}
