/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.style;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Status;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
class Style {
    private static final String RESOURCE = "net.hizlab.kagetaka.addin.style.Resources";

    private static final int TOP    = 0;
    private static final int RIGHT  = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT   = 3;

    private static final int TARGET_TOP    =  1;
    private static final int TARGET_RIGHT  =  2;
    private static final int TARGET_BOTTOM =  4;
    private static final int TARGET_LEFT   =  8;
    private static final int TARGET_ALL    = 15;

    /** ϻ˵åϿݡ */
    protected Reporter reporter = null;
    /** ƥ */
    protected Content  content  = null;
    /** ΥȡγϤֹ */
    protected int lineNumber = 0;
    /** Υȡ󤬳ϤƬΥ */
    protected int columnNumber = 0;

    /** μΥ */
    Style next = null;

    private int       media        = 0;
    private Selector  selector     = null;
    private boolean   page         = false;
    private Hashtable properties   = null;

    // ֥å٥륨
    private Value   propertyTextIndent           = null;
    private Value   propertyTextAlign            = null;
    private Value   propertyWhiteSpace           = null;
    // оݥ
    private Value[] propertyMargin               = new Value[4];
    private Value[] propertyBorderStyle          = new Value[4];
    private Value[] propertyBorderColor          = new Value[4];
    private Value[] propertyBorderWidth          = new Value[4];
    private Value[] propertyPadding              = new Value[4];
    private Value   propertyWidth                = null;
    private Value   propertyHeight               = null;
    private Value   propertyLineHeight           = null;
    private Value   propertyVerticalAlign        = null;
    private Value   propertyLetterSpacing        = null;
    private Value   propertyListStyleType        = null;
    private Value   propertyListStylePosition    = null;
    private Value   propertyListStyleImage       = null;
    private Value   propertyFloat                = null;
    private Value   propertyClear                = null;
    private Value   propertyColor                = null;
    private Value   propertyBackgroundColor      = null;
    private Value   propertyBackgroundImage      = null;
    private Value   propertyBackgroundRepeat     = null;
    private Value   propertyBackgroundAttachment = null;
    private Value   propertyBackgroundPositionH  = null;
    private Value   propertyBackgroundPositionV  = null;
    private Value[] propertyFontFamily           = null;
    private Value   propertyFontStyle            = null;
    private Value   propertyFontWeight           = null;
    private Value   propertyFontSize             = null;
    private Value[] propertyTextDecoration       = null;

    private static final int[] TYPES_LEN_PER         = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_LENGTH          ,
                                                        Value.TYPE_PERCENTAGE      };
    private static final int[] TYPES_SIZE            = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_LENGTH          ,
                                                        Value.TYPE_PERCENTAGE      ,
                                                        /*Value.TYPE_KEY_AUTO        */};
    private static final int[] TYPES_COLOR           = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_COLOR           };
    private static final int[] TYPES_COLOR_TRANS     = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_COLOR           ,
                                                        Value.TYPE_KEY_TRANSPARENT };
    private static final int[] TYPES_URL             = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NONE        ,
                                                        Value.TYPE_URL             };
    private static final int[] TYPES_ALIGN           = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_LEFT        ,
                                                        Value.TYPE_KEY_RIGHT       ,
                                                        Value.TYPE_KEY_CENTER      ,
                                                        /*Value.TYPE_KEY_JUSTIFY     ,*/
                                                        /*Value.TYPE_STRING          */};
    private static final int[] TYPES_WHITE_SPACE     = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NORMAL      ,
                                                        Value.TYPE_KEY_PRE         ,
                                                        Value.TYPE_KEY_NOWRAP      };
    private static final int[] TYPES_BORDER_WIDTH    = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_THIN        ,
                                                        Value.TYPE_KEY_MEDIUM      ,
                                                        Value.TYPE_KEY_THICK       ,
                                                        Value.TYPE_LENGTH          };
    private static final int[] TYPES_BORDER_STYLE    = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NONE        ,
                                                        Value.TYPE_KEY_HIDDEN      ,
                                                        Value.TYPE_KEY_DOTTED      ,
                                                        Value.TYPE_KEY_DASHED      ,
                                                        Value.TYPE_KEY_SOLID       ,
                                                        Value.TYPE_KEY_DOUBLE      ,
                                                        Value.TYPE_KEY_GROOVE      ,
                                                        Value.TYPE_KEY_RIDGE       ,
                                                        Value.TYPE_KEY_INSET       ,
                                                        Value.TYPE_KEY_OUTSET      };
    private static final int[] TYPES_LINE_HEIGHT     = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NORMAL      ,
                                                        Value.TYPE_INTEGER         ,
                                                        Value.TYPE_LENGTH          ,
                                                        Value.TYPE_PERCENTAGE      };
    private static final int[] TYPES_VERTICAL_ALIGN  = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_BASELINE    ,
                                                        Value.TYPE_KEY_SUB         ,
                                                        Value.TYPE_KEY_SUPER       ,
                                                        Value.TYPE_KEY_TOP         ,
                                                        Value.TYPE_KEY_TEXT_TOP    ,
                                                        Value.TYPE_KEY_MIDDLE      ,
                                                        Value.TYPE_KEY_BOTTOM      ,
                                                        Value.TYPE_KEY_TEXT_BOTTOM ,
                                                        Value.TYPE_INTEGER         ,
                                                        Value.TYPE_LENGTH          ,
                                                        Value.TYPE_PERCENTAGE      };
    private static final int[] TYPES_LETTER_SPACING  = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NORMAL      ,
                                                        Value.TYPE_LENGTH          };
    private static final int[] TYPES_LIST_STYLE_TYPE     = {Value.TYPE_KEY_INHERIT             ,
                                                            Value.TYPE_KEY_NONE                ,
                                                            Value.TYPE_KEY_DISC                ,
                                                            Value.TYPE_KEY_CIRCLE              ,
                                                            Value.TYPE_KEY_SQUARE              ,
                                                            Value.TYPE_KEY_DECIMAL             ,
                                                            Value.TYPE_KEY_DECIMAL_LEADING_ZERO,
                                                            Value.TYPE_KEY_LOWER_ROMAN         ,
                                                            Value.TYPE_KEY_UPPER_ROMAN         ,
                                                            Value.TYPE_KEY_HEBREW              ,
                                                            Value.TYPE_KEY_GEORGIAN            ,
                                                            Value.TYPE_KEY_ARMENIAN            ,
                                                            Value.TYPE_KEY_CJK_IDEOGRAPHIC     ,
                                                            Value.TYPE_KEY_HIRAGANA            ,
                                                            Value.TYPE_KEY_KATAKANA            ,
                                                            Value.TYPE_KEY_HIRAGANA_IROHA      ,
                                                            Value.TYPE_KEY_KATAKANA_IROHA      ,
                                                            Value.TYPE_KEY_LOWER_LATIN         ,
                                                            Value.TYPE_KEY_UPPER_LATIN         ,
                                                            Value.TYPE_KEY_LOWER_ALPHA         ,
                                                            Value.TYPE_KEY_UPPER_ALPHA         ,
                                                            Value.TYPE_KEY_LOWER_GREEK         };
    private static final int[] TYPES_LIST_STYLE_POSITION = {Value.TYPE_KEY_INHERIT             ,
                                                            Value.TYPE_KEY_INSIDE              ,
                                                            Value.TYPE_KEY_OUTSIDE             };
    private static final int[] TYPES_BG_REPEAT       = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_REPEAT      ,
                                                        Value.TYPE_KEY_REPEAT_X    ,
                                                        Value.TYPE_KEY_REPEAT_Y    ,
                                                        Value.TYPE_KEY_NO_REPEAT   };
    private static final int[] TYPES_BG_ATTACHMENT   = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_SCROLL      ,
                                                        Value.TYPE_KEY_FIXED       };
    private static final int[] TYPES_BG_POSITION     = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_PERCENTAGE      ,
                                                        Value.TYPE_LENGTH          ,
                                                        Value.TYPE_KEY_TOP         ,
                                                        Value.TYPE_KEY_CENTER      ,
                                                        Value.TYPE_KEY_BOTTOM      ,
                                                        Value.TYPE_KEY_LEFT        ,
                                                        Value.TYPE_KEY_RIGHT       };
    private static final int[] TYPES_FLOAT           = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_LEFT        ,
                                                        Value.TYPE_KEY_RIGHT       ,
                                                        Value.TYPE_KEY_NONE        };
    private static final int[] TYPES_CLEAR           = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NONE        ,
                                                        Value.TYPE_KEY_LEFT        ,
                                                        Value.TYPE_KEY_RIGHT       ,
                                                        Value.TYPE_KEY_BOTH        };
    private static final int[] TYPES_FONT_FAMILY     = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_SERIF       ,
                                                        Value.TYPE_KEY_SANS_SERIF  ,
                                                        Value.TYPE_KEY_CURSIVE     ,
                                                        Value.TYPE_KEY_FANTASY     ,
                                                        Value.TYPE_KEY_MONOSPACE   ,
                                                        Value.TYPE_STRING          };
    private static final int[] TYPES_FONT_STYLE      = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NORMAL      ,
                                                        Value.TYPE_KEY_OBLIQUE     ,
                                                        Value.TYPE_KEY_ITALIC      };
    private static final int[] TYPES_FONT_WEIGHT     = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NORMAL      ,
                                                        Value.TYPE_KEY_BOLD        ,
                                                        Value.TYPE_KEY_BOLDER      ,
                                                        Value.TYPE_KEY_LIGHTER     ,
                                                        Value.TYPE_INTEGER         };
    private static final int[] TYPES_FONT_SIZE       = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_XX_SMALL    ,
                                                        Value.TYPE_KEY_X_SMALL     ,
                                                        Value.TYPE_KEY_SMALL       ,
                                                        Value.TYPE_KEY_MEDIUM      ,
                                                        Value.TYPE_KEY_LARGE       ,
                                                        Value.TYPE_KEY_X_LARGE     ,
                                                        Value.TYPE_KEY_XX_LARGE    ,
                                                        Value.TYPE_KEY_LARGER      ,
                                                        Value.TYPE_KEY_SMALLER     ,
                                                        Value.TYPE_LENGTH          ,
                                                        Value.TYPE_PERCENTAGE      };
    private static final int[] TYPES_TEXT_DECORATION = {Value.TYPE_KEY_INHERIT     ,
                                                        Value.TYPE_KEY_NONE        ,
                                                        Value.TYPE_KEY_UNDERLINE   ,
                                                        Value.TYPE_KEY_OVERLINE    ,
                                                        Value.TYPE_KEY_LINE_THROUGH,
                                                        Value.TYPE_KEY_BLINK       };

    /**
     * 쥯դ̤ΥΥ󥹥ȥ饯Ǥ
     *
     * @param  reporter 顼ݡ
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  media    ǥ
     * @param  selector 쥯
     * @param  page     ڡ§ξ <code>true</code>
     *                  ʳξ <code>false</code>
     */
    Style(Reporter reporter, Content content, int line, int column,
          int media, Selector selector, boolean page) {
        this.reporter     = reporter;
        this.content      = content;
        this.lineNumber   = line;
        this.columnNumber = column;
        this.media        = media;
        this.selector     = selector;
        this.page         = page;

        if (selector != null) {
            selector.style = this;
        }
    }

    /**
     * ץѥƥԤޤ
     *
     * @param  name   ץѥƥ̾
     * @param  values ץѥƥ
     */
    void initProperties(String name, String[] values) {
        // \ ǻϤޤ̵
        if (name.charAt(0) == '\\') {
            return;
        }
        name = CSSParser.unescape(name, 0, name.length(), false).toLowerCase();
        if (properties == null) {
            properties = new Hashtable();
        }
        properties.put(name, values);

        if (values.length == 0) {
            return;
        }

        try {
            //// ֥å٥륨
            if (name.compareTo("text-indent") == 0) { propertyTextIndent = new Value(values, TYPES_LEN_PER    ); return; }
            if (name.compareTo("text-align" ) == 0) { propertyTextAlign  = new Value(values, TYPES_ALIGN      ); return; }
            if (name.compareTo("white-space") == 0) { propertyWhiteSpace = new Value(values, TYPES_WHITE_SPACE); return; }
            if (name.compareTo("clear"      ) == 0) { propertyClear      = new Value(values, TYPES_CLEAR      ); return; }

            //// оݥ
            // ޡ
            if (name.compareTo("margin-top"   ) == 0) { propertyMargin[TOP   ] = new Value(values, TYPES_SIZE); return; }
            if (name.compareTo("margin-right" ) == 0) { propertyMargin[RIGHT ] = new Value(values, TYPES_SIZE); return; }
            if (name.compareTo("margin-bottom") == 0) { propertyMargin[BOTTOM] = new Value(values, TYPES_SIZE); return; }
            if (name.compareTo("margin-left"  ) == 0) { propertyMargin[LEFT  ] = new Value(values, TYPES_SIZE); return; }
            if (name.compareTo("margin"       ) == 0) { distribute(values, propertyMargin, TYPES_SIZE); return; }
            // ܡ
            if (name.compareTo("border-top-width"   ) == 0) { propertyBorderWidth[TOP   ] = new Value(values, TYPES_BORDER_WIDTH); return; }
            if (name.compareTo("border-right-width" ) == 0) { propertyBorderWidth[RIGHT ] = new Value(values, TYPES_BORDER_WIDTH); return; }
            if (name.compareTo("border-bottom-width") == 0) { propertyBorderWidth[BOTTOM] = new Value(values, TYPES_BORDER_WIDTH); return; }
            if (name.compareTo("border-left-width"  ) == 0) { propertyBorderWidth[LEFT  ] = new Value(values, TYPES_BORDER_WIDTH); return; }
            if (name.compareTo("border-width"       ) == 0) { distribute(values, propertyBorderWidth, TYPES_BORDER_WIDTH); return; }
            // ܡ
            if (name.compareTo("border-top-color"   ) == 0) { propertyBorderColor[TOP   ] = new Value(values, TYPES_COLOR_TRANS); return; }
            if (name.compareTo("border-right-color" ) == 0) { propertyBorderColor[RIGHT ] = new Value(values, TYPES_COLOR_TRANS); return; }
            if (name.compareTo("border-bottom-color") == 0) { propertyBorderColor[BOTTOM] = new Value(values, TYPES_COLOR_TRANS); return; }
            if (name.compareTo("border-left-color"  ) == 0) { propertyBorderColor[LEFT  ] = new Value(values, TYPES_COLOR_TRANS); return; }
            if (name.compareTo("border-color"       ) == 0) { distribute(values, propertyBorderColor, TYPES_COLOR_TRANS); return; }
            // ܡ
            if (name.compareTo("border-top-style"   ) == 0) { propertyBorderStyle[TOP   ] = new Value(values, TYPES_BORDER_STYLE); return; }
            if (name.compareTo("border-right-style" ) == 0) { propertyBorderStyle[RIGHT ] = new Value(values, TYPES_BORDER_STYLE); return; }
            if (name.compareTo("border-bottom-style") == 0) { propertyBorderStyle[BOTTOM] = new Value(values, TYPES_BORDER_STYLE); return; }
            if (name.compareTo("border-left-style"  ) == 0) { propertyBorderStyle[LEFT  ] = new Value(values, TYPES_BORDER_STYLE); return; }
            if (name.compareTo("border-style"       ) == 0) { distribute(values, propertyBorderStyle, TYPES_BORDER_STYLE); return; }
            // ܡά
            if (name.compareTo("border-top"   ) == 0) { normalizeBorder(values, TARGET_TOP   ); return; }
            if (name.compareTo("border-right" ) == 0) { normalizeBorder(values, TARGET_RIGHT ); return; }
            if (name.compareTo("border-bottom") == 0) { normalizeBorder(values, TARGET_BOTTOM); return; }
            if (name.compareTo("border-left"  ) == 0) { normalizeBorder(values, TARGET_LEFT  ); return; }
            if (name.compareTo("border"       ) == 0) { normalizeBorder(values, TARGET_ALL   ); return; }
            // ѥǥ
            if (name.compareTo("padding-top"   ) == 0) { propertyPadding[TOP   ] = new Value(values, TYPES_LEN_PER); return; }
            if (name.compareTo("padding-right" ) == 0) { propertyPadding[RIGHT ] = new Value(values, TYPES_LEN_PER); return; }
            if (name.compareTo("padding-bottom") == 0) { propertyPadding[BOTTOM] = new Value(values, TYPES_LEN_PER); return; }
            if (name.compareTo("padding-left"  ) == 0) { propertyPadding[LEFT  ] = new Value(values, TYPES_LEN_PER); return; }
            if (name.compareTo("padding"       ) == 0) { distribute(values, propertyPadding, TYPES_LEN_PER); return; }

            if (name.compareTo("width"              ) == 0) { propertyWidth             = new Value(values, TYPES_SIZE               ); return; }
            if (name.compareTo("height"             ) == 0) { propertyHeight            = new Value(values, TYPES_SIZE               ); return; }
            if (name.compareTo("line-height"        ) == 0) { propertyLineHeight        = new Value(values, TYPES_LINE_HEIGHT        ); return; }
            if (name.compareTo("vertical-align"     ) == 0) { propertyVerticalAlign     = new Value(values, TYPES_VERTICAL_ALIGN     ); return; }
            if (name.compareTo("letter-spacing"     ) == 0) { propertyLetterSpacing     = new Value(values, TYPES_LETTER_SPACING     ); return; }
            if (name.compareTo("list-style-type"    ) == 0) { propertyListStyleType     = new Value(values, TYPES_LIST_STYLE_TYPE    ); return; }
            if (name.compareTo("list-style-position") == 0) { propertyListStylePosition = new Value(values, TYPES_LIST_STYLE_POSITION); return; }
            if (name.compareTo("list-style-image"   ) == 0) { propertyListStyleImage    = new Value(values, TYPES_URL                ); return; }
            if (name.compareTo("list-style"         ) == 0) { normalizeListStyle(values); return; }
            if (name.compareTo("float"              ) == 0) { propertyFloat             = new Value(values, TYPES_FLOAT              ); return; }
            if (name.compareTo("color"              ) == 0) { propertyColor             = new Value(values, TYPES_COLOR              ); return; }

            if (name.compareTo("background-color"     ) == 0) { propertyBackgroundColor      = new Value(values, TYPES_COLOR_TRANS  ); return; }
            if (name.compareTo("background-image"     ) == 0) { propertyBackgroundImage      = new Value(values, TYPES_URL          ); return; }
            if (name.compareTo("background-repeat"    ) == 0) { propertyBackgroundRepeat     = new Value(values, TYPES_BG_REPEAT    ); return; }
            if (name.compareTo("background-attachment") == 0) { propertyBackgroundAttachment = new Value(values, TYPES_BG_ATTACHMENT); return; }
            if (name.compareTo("background-position"  ) == 0) { normalizePosition  (values); return; }
            if (name.compareTo("background"           ) == 0) { normalizeBackground(values); return; }
            //### BUGS font-family ޤƯʤ
            if (name.compareTo("font-family"    ) == 0) { propertyFontFamily     = createValues(values, TYPES_FONT_FAMILY    , propertyFontFamily    ); return; }
            if (name.compareTo("font-style"     ) == 0) { propertyFontStyle      = new Value(values, TYPES_FONT_STYLE ); return; }
            if (name.compareTo("font-weight"    ) == 0) { propertyFontWeight     = new Value(values, TYPES_FONT_WEIGHT); return; }
            if (name.compareTo("font-size"      ) == 0) { propertyFontSize       = new Value(values, TYPES_FONT_SIZE  ); return; }
            if (name.compareTo("text-decoration") == 0) { propertyTextDecoration = createValues(values, TYPES_TEXT_DECORATION, propertyTextDecoration); return; }
        } catch (ParseException e) {
        }

        reportMessage(Reporter.WARNING, "style.warning.notsupported", new String[]{name});
    }

    /**
     * Υ򸵤ˡ襹ơѹޤ
     *
     * @param  block  оݤ֥åξ <code>true</code>
     *                ʳξ <code>false</code>
     * @param  status 襹ơ
     */
    void changeStatus(boolean block, Status status) {
        // ֥å٥륨
        if (block) {
            if (propertyTextIndent != null) { status.textIndent = propertyTextIndent; }
            if (propertyTextAlign  != null) { status.align      = propertyTextAlign .getType(); }
            if (propertyWhiteSpace != null) { status.whiteSpace = propertyWhiteSpace.getType(); }
            if (propertyClear      != null) { status.clearType  = propertyClear     .getType(); }
        }

        // оݥ
        if (propertyMargin[TOP   ]      != null) { status.setMargin(Status.TARGET_RIGHT , propertyMargin[TOP   ]); }
        if (propertyMargin[RIGHT ]      != null) { status.setMargin(Status.TARGET_BOTTOM, propertyMargin[RIGHT ]); }
        if (propertyMargin[BOTTOM]      != null) { status.setMargin(Status.TARGET_LEFT  , propertyMargin[BOTTOM]); }
        if (propertyMargin[LEFT  ]      != null) { status.setMargin(Status.TARGET_TOP   , propertyMargin[LEFT  ]); }
        if (propertyBorderStyle[TOP   ] != null) { status.setBorderStyle(Status.TARGET_RIGHT , propertyBorderStyle[TOP   ]); }
        if (propertyBorderStyle[RIGHT ] != null) { status.setBorderStyle(Status.TARGET_BOTTOM, propertyBorderStyle[RIGHT ]); }
        if (propertyBorderStyle[BOTTOM] != null) { status.setBorderStyle(Status.TARGET_LEFT  , propertyBorderStyle[BOTTOM]); }
        if (propertyBorderStyle[LEFT  ] != null) { status.setBorderStyle(Status.TARGET_TOP   , propertyBorderStyle[LEFT  ]); }
        if (propertyBorderColor[TOP   ] != null) { status.setBorderColor(Status.TARGET_RIGHT , propertyBorderColor[TOP   ].getColor()); }
        if (propertyBorderColor[RIGHT ] != null) { status.setBorderColor(Status.TARGET_BOTTOM, propertyBorderColor[RIGHT ].getColor()); }
        if (propertyBorderColor[BOTTOM] != null) { status.setBorderColor(Status.TARGET_LEFT  , propertyBorderColor[BOTTOM].getColor()); }
        if (propertyBorderColor[LEFT  ] != null) { status.setBorderColor(Status.TARGET_TOP   , propertyBorderColor[LEFT  ].getColor()); }
        if (propertyBorderWidth[TOP   ] != null) { status.setBorderWidth(Status.TARGET_RIGHT , propertyBorderWidth[TOP   ]); }
        if (propertyBorderWidth[RIGHT ] != null) { status.setBorderWidth(Status.TARGET_BOTTOM, propertyBorderWidth[RIGHT ]); }
        if (propertyBorderWidth[BOTTOM] != null) { status.setBorderWidth(Status.TARGET_LEFT  , propertyBorderWidth[BOTTOM]); }
        if (propertyBorderWidth[LEFT  ] != null) { status.setBorderWidth(Status.TARGET_TOP   , propertyBorderWidth[LEFT  ]); }
        if (propertyPadding[TOP   ]     != null) { status.setPadding(Status.TARGET_RIGHT , propertyPadding[TOP   ]); }
        if (propertyPadding[RIGHT ]     != null) { status.setPadding(Status.TARGET_BOTTOM, propertyPadding[RIGHT ]); }
        if (propertyPadding[BOTTOM]     != null) { status.setPadding(Status.TARGET_LEFT  , propertyPadding[BOTTOM]); }
        if (propertyPadding[LEFT  ]     != null) { status.setPadding(Status.TARGET_TOP   , propertyPadding[LEFT  ]); }
        if (propertyWidth               != null) { status.height        = propertyWidth;      }
        if (propertyHeight              != null) { status.width         = propertyHeight;     }
        if (propertyLineHeight          != null) { status.lineHeight    = propertyLineHeight; }
        if (propertyVerticalAlign       != null) { status.valign        = propertyVerticalAlign.getType(); }
        if (propertyLetterSpacing       != null) { status.letterSpacing = propertyLetterSpacing; }
        if (propertyListStyleType       != null) { status.setList      (propertyListStyleType.getType()); }
        /* if (propertyListStylePosition   != null) { ??? } */
        /* if (propertyListStyleImage      != null) { ??? } */
        if (propertyFloat               != null) { status.floatType     = propertyFloat          .getType (); }
        if (propertyColor               != null) { status.foreColor     = propertyColor          .getColor(); }
        if (propertyBackgroundColor     != null) { status.setBackground(propertyBackgroundColor.getColor()); }
        if (propertyBackgroundImage     != null) { status.setBackground(propertyBackgroundImage.getURL(content.url), propertyBackgroundRepeat, propertyBackgroundPositionV, propertyBackgroundPositionH); }
        if (propertyFontFamily          != null) { status.setFontFamily(propertyFontFamily); }
        if (propertyFontStyle           != null) { status.setFontStyle (propertyFontStyle ); }
        if (propertyFontWeight          != null) { status.setFontWeight(propertyFontWeight); }
        if (propertyFontSize            != null) { status.setFontSize  (propertyFontSize  , Status.STYLE); }
        if (propertyTextDecoration      != null) { status.decoration = getOr(propertyTextDecoration); }
    }

    /**  */
    private void distribute(String[] values, Value[] props, int[] types)
            throws ParseException {
        switch (values.length) {
        case 1:
            props[TOP   ] =
            props[RIGHT ] =
            props[BOTTOM] =
            props[LEFT  ] = new Value(values[0], types);
            return;
        case 2:
            props[TOP   ] =
            props[BOTTOM] = new Value(values[0], types);
            props[RIGHT ] =
            props[LEFT  ] = new Value(values[1], types);
            return;
        case 3:
            props[TOP   ] = new Value(values[0], types);
            props[RIGHT ] =
            props[LEFT  ] = new Value(values[1], types);
            props[BOTTOM] = new Value(values[2], types);
            return;
        case 4:
            props[TOP   ] = new Value(values[0], types);
            props[RIGHT ] = new Value(values[1], types);
            props[BOTTOM] = new Value(values[2], types);
            props[LEFT  ] = new Value(values[3], types);
            return;
        default:
            throw new ParseException(values[4], 0);
        }
    }

    /** ꥹȤ */
    private Value[] createValues(String[] values, int[] types, Value[] props)
            throws ParseException {
        Vector vector = new Vector();
        Value  v;

        if (/*---*/props != null
                && props.length > 0
                && props[0].getType() != Value.TYPE_KEY_INHERIT) {
            for (int i = 0; i < props.length; i++) {
                vector.addElement(props[i]);
            }
        }

        for (int i = 0; i < values.length; i++) {
            v = new Value(values[i], types);
            if (v.getType() == Value.TYPE_KEY_INHERIT) {
                if (values.length != 1) {
                    throw new ParseException(values[i], 0);
                }

                return new Value[]{v};
            }

            vector.addElement(v);
        }

        props = new Value[vector.size()];
        vector.copyInto(props);

        return props;
    }

    /** ܡ */
    private void normalizeBorder(String[] values, int target)
            throws ParseException {
        Value v;
        int type, i, j;

        VALUES:
        for (i = values.length - 1; i >= 0; i--) {
            v = new Value(values[i], null);
            type = v.getType();

            if (type == Value.TYPE_KEY_INHERIT) {
                if (values.length != 1) {
                    break;
                }

                distributeBorder(propertyBorderWidth, v, target);
                distributeBorder(propertyBorderStyle, v, target);
                distributeBorder(propertyBorderColor, v, target);
                return;
            }

            // 
            for (j = 0; j < TYPES_BORDER_WIDTH.length; j++) {
                if (TYPES_BORDER_WIDTH[j] == type) {
                    distributeBorder(propertyBorderWidth, v, target);
                    continue VALUES;
                }
            }

            // 
            for (j = 0; j < TYPES_BORDER_STYLE.length; j++) {
                if (TYPES_BORDER_STYLE[j] == type) {
                    distributeBorder(propertyBorderStyle, v, target);
                    continue VALUES;
                }
            }

            // 
            for (j = 0; j < TYPES_COLOR_TRANS.length; j++) {
                if (TYPES_COLOR_TRANS[j] == type) {
                    distributeBorder(propertyBorderColor, v, target);
                    continue VALUES;
                }
            }

            throw new ParseException(values[i], 0);
        }
    }

    /** ܡѤʬ */
    private void distributeBorder(Value[] props, Value v, int target) {
        if ((target & TARGET_TOP   ) != 0) { props[TOP   ] = v; }
        if ((target & TARGET_RIGHT ) != 0) { props[RIGHT ] = v; }
        if ((target & TARGET_BOTTOM) != 0) { props[BOTTOM] = v; }
        if ((target & TARGET_LEFT  ) != 0) { props[LEFT  ] = v; }
    }

    /** ꥹȥ */
    private void normalizeListStyle(String[] values)
            throws ParseException {
        Value v;
        int type, i, j;

        VALUES:
        for (i = values.length - 1; i >= 0; i--) {
            v = new Value(values[i], null);
            type = v.getType();

            if (type == Value.TYPE_KEY_INHERIT) {
                if (values.length != 1) {
                    break;
                }

                propertyListStyleType     = v;
                propertyListStylePosition = v;
                propertyListStyleImage    = v;
                return;
            }

            // 
            for (j = 0; j < TYPES_LIST_STYLE_TYPE.length; j++) {
                if (TYPES_LIST_STYLE_TYPE[j] == type) {
                    propertyListStyleType = v;
                    continue VALUES;
                }
            }

            // ݥ
            for (j = 0; j < TYPES_LIST_STYLE_POSITION.length; j++) {
                if (TYPES_LIST_STYLE_POSITION[j] == type) {
                    propertyListStylePosition = v;
                    continue VALUES;
                }
            }

            // ᡼
            for (j = 0; j < TYPES_URL.length; j++) {
                if (TYPES_URL[j] == type) {
                    propertyListStyleImage = v;
                    continue VALUES;
                }
            }

            throw new ParseException(values[i], 0);
        }
    }

    /** ݥ */
    private void normalizePosition(String[] values)
            throws ParseException {
        Value[] v2 = {
            new Value(values[0], TYPES_BG_POSITION),
            (values.length >= 2 ? new Value(values[1], TYPES_BG_POSITION) : null),
        };

        distributePosition(v2);
        propertyBackgroundPositionH = v2[0];
        propertyBackgroundPositionV = v2[1];
    }

    /** Хå饦ɤ */
    private void normalizeBackground(String[] values)
            throws ParseException {
        Value v;
        int type, i, j;

        VALUES:
        for (i = values.length - 1; i >= 0; i--) {
            v = new Value(values[i], null);
            type = v.getType();

            if (type == Value.TYPE_KEY_INHERIT) {
                if (values.length != 1) {
                    break;
                }

                propertyBackgroundColor      = v;
                propertyBackgroundImage      = v;
                propertyBackgroundRepeat     = v;
                propertyBackgroundAttachment = v;
                propertyBackgroundPositionH  = v;
                propertyBackgroundPositionV  = v;
                return;
            }

            // 
            for (j = 0; j < TYPES_COLOR_TRANS.length; j++) {
                if (TYPES_COLOR_TRANS[j] == type) {
                    propertyBackgroundColor = v;
                    continue VALUES;
                }
            }

            // ᡼
            for (j = 0; j < TYPES_URL.length; j++) {
                if (TYPES_URL[j] == type) {
                    propertyBackgroundImage = v;
                    continue VALUES;
                }
            }

            // ԡ
            for (j = 0; j < TYPES_BG_REPEAT.length; j++) {
                if (TYPES_BG_REPEAT[j] == type) {
                    propertyBackgroundRepeat = v;
                    continue VALUES;
                }
            }

            // ź
            for (j = 0; j < TYPES_BG_ATTACHMENT.length; j++) {
                if (TYPES_BG_ATTACHMENT[j] == type) {
                    propertyBackgroundAttachment = v;
                    continue VALUES;
                }
            }

            // 
            for (j = 0; j < TYPES_BG_POSITION.length; j++) {
                if (TYPES_BG_POSITION[j] == type) {
                    if (propertyBackgroundPositionH != null) {
                        propertyBackgroundPositionV = propertyBackgroundPositionH;
                    }
                    propertyBackgroundPositionH = v;
                    continue VALUES;
                }
            }

            throw new ParseException(values[i], 0);
        }

        if (propertyBackgroundPositionH != null) {
            Value[] v2 = {propertyBackgroundPositionH, propertyBackgroundPositionV};
            distributePosition(v2);
            propertyBackgroundPositionH = v2[0];
            propertyBackgroundPositionV = v2[1];
        }
    }

    /** ݥ */
    private void distributePosition(Value[] v2) {
        Value h = null, v = null;
        boolean isSingle = (v2[1] == null);

        switch (v2[0].getType()) {
        case Value.TYPE_PERCENTAGE:
        case Value.TYPE_LENGTH:
            h = v = v2[0];
            break;
        case Value.TYPE_KEY_TOP:
            h = new Value( 50, Value.UNIT_PERCENT);
            v = new Value(  0, Value.UNIT_PERCENT);
            break;
        case Value.TYPE_KEY_CENTER:
            h = v = new Value( 50, Value.UNIT_PERCENT);
            break;
        case Value.TYPE_KEY_BOTTOM:
            h = new Value( 50, Value.UNIT_PERCENT);
            v = new Value(100, Value.UNIT_PERCENT);
            break;
        case Value.TYPE_KEY_LEFT:
            h = new Value(  0, Value.UNIT_PERCENT);
            v = new Value( 50, Value.UNIT_PERCENT);
            break;
        case Value.TYPE_KEY_RIGHT:
            h = new Value(100, Value.UNIT_PERCENT);
            v = new Value( 50, Value.UNIT_PERCENT);
            break;
        default: // AVOID
        }

        if (!isSingle) {
            switch (v2[1].getType()) {
            case Value.TYPE_PERCENTAGE:
            case Value.TYPE_LENGTH:
                v = v2[1];
                break;
            case Value.TYPE_KEY_TOP:
                v = new Value(  0, Value.UNIT_PERCENT);
                break;
            case Value.TYPE_KEY_CENTER:
                v = new Value( 50, Value.UNIT_PERCENT);
                break;
            case Value.TYPE_KEY_BOTTOM:
                v = new Value(100, Value.UNIT_PERCENT);
                break;
            case Value.TYPE_KEY_LEFT:
                h = new Value(  0, Value.UNIT_PERCENT);
                break;
            case Value.TYPE_KEY_RIGHT:
                h = new Value(100, Value.UNIT_PERCENT);
                break;
            default: // AVOID
            }
        }

        v2[0] = h;
        v2[1] = v;
    }

    /** OR ͤ */
    private int getOr(Value[] props) {
        int typeOr = 0, type = 0;

        for (int i = 0; i < props.length; i++) {
            type = props[i].getType();
            if (type == Value.TYPE_KEY_INHERIT) {
                return type;
            }

            typeOr |= type;
        }

        return typeOr;
    }

    /**
     * 쥯֤ޤ
     *
     * @return 쥯
     */
    Selector getSelector() {
        return selector;
    }

    /**
     * ǥ֤ޤ
     *
     * @return ǥ
     */
    int getMedia() {
        return media;
    }

    /**
     * ǥʸ󤫤顢ǥפο֤ͤޤ
     *
     * @param  list ǥΥꥹ
     *
     * @return ǥ
     */
    static int convertMedia(String[] list) {
        if (list == null) {
            return 0;
        }

        String s;
        int    type = 0;

        for (int i = 0; i < list.length; i++) {
            s = list[i];
            if (s.compareTo("aural"     ) == 0) { type |= Value.MEDIA_AURAL     ; } else
            if (s.compareTo("braille"   ) == 0) { type |= Value.MEDIA_BRAILLE   ; } else
            if (s.compareTo("embossed"  ) == 0) { type |= Value.MEDIA_EMBOSSED  ; } else
            if (s.compareTo("handheld"  ) == 0) { type |= Value.MEDIA_HANDHELD  ; } else
            if (s.compareTo("print"     ) == 0) { type |= Value.MEDIA_PRINT     ; } else
            if (s.compareTo("projection") == 0) { type |= Value.MEDIA_PROJECTION; } else
            if (s.compareTo("screen"    ) == 0) { type |= Value.MEDIA_SCREEN    ; } else
            if (s.compareTo("tty"       ) == 0) { type |= Value.MEDIA_TTY       ; } else
            if (s.compareTo("tv"        ) == 0) { type |= Value.MEDIA_TV        ; } else
            if (s.compareTo("all"       ) == 0) { type |= Value.MEDIA_ALL       ; } else
            { type |= Value.MEDIA_0; }
        }

        return type;
    }

    /**
     * &#64page §ɤ֤ޤ
     *
     * @return &#64page §ξ <code>true</code>
     *         ʳξ <code>false</code>
     */
    boolean isPage() {
        return page;
    }

    /**
     * ȡγϰ֤ιֹ֤ޤ
     *
     * @return ϰ֤ιֹ
     */
    int getLineNumber() {
        return lineNumber;
    }

    /**
     * ȡγϰ֤Υ֤֤ޤ
     *
     * @return ϰ֤Υ
     */
    int getColumnNumber() {
        return columnNumber;
    }

    /**
     * Υ쥯ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        String   key;
        String[] values;
        StringBuffer sb = new StringBuffer();
        if (media != 0 && media != Value.MEDIA_0) {
            sb.append('<');
            if ((media & Value.MEDIA_AURAL     ) != 0) { sb.append("aural, "     ); }
            if ((media & Value.MEDIA_BRAILLE   ) != 0) { sb.append("braille, "   ); }
            if ((media & Value.MEDIA_EMBOSSED  ) != 0) { sb.append("embossed, "  ); }
            if ((media & Value.MEDIA_HANDHELD  ) != 0) { sb.append("handheld, "  ); }
            if ((media & Value.MEDIA_PRINT     ) != 0) { sb.append("print, "     ); }
            if ((media & Value.MEDIA_PROJECTION) != 0) { sb.append("projection, "); }
            if ((media & Value.MEDIA_SCREEN    ) != 0) { sb.append("screen, "    ); }
            if ((media & Value.MEDIA_TTY       ) != 0) { sb.append("tty, "       ); }
            if ((media & Value.MEDIA_TV        ) != 0) { sb.append("tv, "        ); }
            sb.setLength(sb.length() - 2);
            sb.append('>');
        }
        if (selector != null) {
            sb.append(selector.toString());
        }
        sb.append('{');
        if (properties != null) {
            for (Enumeration e = properties.keys(); e.hasMoreElements();) {
                key    = (String) e.nextElement();
                values = (String[]) properties.get(key);

                sb.append(key);
                sb.append(':');
                for (int i = 0; i < values.length; i++) {
                    sb.append(' ');
                    sb.append(values[i]);
                }
                sb.append("; ");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        //sb.append(hashCode());
        return sb.toString();
    }

    /**
     * å𤷤ޤ
     *
     * @param  level å٥
     * @param  key   å꥽Υ
     * @param  args  åɲð
     *               ɬפʤ <code>null</code>
     */
    private void reportMessage(int level, String key, String[] args) {
        if (reporter == null) {
            return;
        }

        reporter.report(Reporter.STYLE, level, Reporter.NONE,
                        content, lineNumber, columnNumber,
                        "Style", Resource.getMessage(RESOURCE, key, args));
    }
}
